/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalLine;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalLine;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import java.awt.Dimension;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResizeWithSnapBaseTarget
extends ResizeBaseTarget {
    private static final int MAX_MATCH_DISTANCE = 10;
    private static final int CANNOT_SNAP = Integer.MAX_VALUE;
    @NotNull
    protected Future<Dimension> myWrapSizeFuture = CompletableFuture.completedFuture(null);

    @Nullable
    private Dimension getWrapSize() {
        try {
            return this.myWrapSizeFuture.get(250L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return null;
    }

    public ResizeWithSnapBaseTarget(@NotNull ResizeBaseTarget.Type type) {
        super(type);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.isHittable()) {
            DrawResize.add(list, sceneContext, this.myLeft, this.myTop, this.mIsOver ? 1 : 0);
            Dimension wrapSize = this.getWrapSize();
            if (wrapSize != null) {
                this.renderWrapSizeSnapLines(list, sceneContext, wrapSize.width, wrapSize.height);
            }
        }
    }

    private void renderWrapSizeSnapLines(@NotNull DisplayList list, @NotNull SceneContext sceneContext, int wrapX, int wrapY) {
        switch (this.myType) {
            case LEFT_TOP: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY2 - wrapY, this.myStartY2);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY2 - wrapY, this.myStartX2);
                break;
            }
            case LEFT: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY1, this.myStartY2);
                break;
            }
            case LEFT_BOTTOM: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY1, this.myStartY1 + wrapY);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY2 - wrapY, this.myStartX2);
                break;
            }
            case TOP: {
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY2 - wrapY, this.myStartX2);
                break;
            }
            case BOTTOM: {
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY1 + wrapY, this.myStartX2);
                break;
            }
            case RIGHT_TOP: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX1 + wrapX, this.myStartY2 - wrapY, this.myStartY2);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY2 - wrapY, this.myStartX1 + wrapX);
                break;
            }
            case RIGHT: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX1 + wrapX, this.myStartY1, this.myStartY2);
                break;
            }
            case RIGHT_BOTTOM: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX1 + wrapX, this.myStartY1, this.myStartY1 + wrapY);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY1 + wrapY, this.myStartX1 + wrapX);
            }
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myWrapSizeFuture = this.myComponent.getScene().measureWrapSize(this.myComponent);
        super.mouseDown(x, y);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext sceneContext) {
        x = this.snapX(x);
        y = this.snapY(y);
        super.mouseDrag(x, y, closestTargets, sceneContext);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        x = this.snapX(x);
        y = this.snapY(y);
        super.mouseRelease(x, y, closestTargets);
        this.myWrapSizeFuture = CompletableFuture.completedFuture(null);
    }

    protected int getNewXPos(int x) {
        SceneComponent parent = this.myComponent.getParent();
        int parentX = parent != null ? parent.getDrawX() : 0;
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return Math.min(x, this.myStartX2) - parentX;
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return Math.min(x, this.myStartX1) - parentX;
            }
        }
        return this.myStartX1 - parentX;
    }

    protected int getNewYPos(int y) {
        SceneComponent parent = this.myComponent.getParent();
        int parentY = parent != null ? parent.getDrawY() : 0;
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return Math.min(y, this.myStartY2) - parentY;
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return Math.min(y, this.myStartY1) - parentY;
            }
        }
        return this.myStartY1 - parentY;
    }

    protected String getNewWidth(int x) {
        int width = this.getNewDpWidth(x);
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null && width == parent.getDrawWidth() && this.getNewXPos(x) == 0) {
            return "match_parent";
        }
        Dimension wrapSize = this.getWrapSize();
        if (wrapSize != null && width == wrapSize.width) {
            return "wrap_content";
        }
        return String.format("%ddp", width);
    }

    protected String getNewHeight(int y) {
        int height = this.getNewDpHeight(y);
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null && height == parent.getDrawHeight() && this.getNewYPos(y) == 0) {
            return "match_parent";
        }
        Dimension wrapSize = this.getWrapSize();
        if (wrapSize != null && height == wrapSize.height) {
            return "wrap_content";
        }
        return String.format("%ddp", height);
    }

    private int getNewDpWidth(int x) {
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return Math.abs(this.myStartX2 - x);
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return Math.abs(this.myStartX1 - x);
            }
        }
        return this.myStartX2 - this.myStartX1;
    }

    private int getNewDpHeight(int y) {
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return Math.abs(this.myStartY2 - y);
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return Math.abs(this.myStartY1 - y);
            }
        }
        return this.myStartY2 - this.myStartY1;
    }

    private int snapX(int x) {
        int dx = this.snapToParentBoundaryX(x);
        if (Math.abs(dx) < 10) {
            return x + dx;
        }
        dx = this.snapToWrapWidth(x);
        if (Math.abs(dx) < 10) {
            return x + dx;
        }
        return x;
    }

    private int snapY(int y) {
        int dy = this.snapToParentBoundaryY(y);
        if (Math.abs(dy) < 10) {
            return y + dy;
        }
        dy = this.snapToWrapHeight(y);
        if (Math.abs(dy) < 10) {
            return y + dy;
        }
        return y;
    }

    private int snapToWrapWidth(int x) {
        Dimension wrapSize = this.getWrapSize();
        if (wrapSize == null) {
            return Integer.MAX_VALUE;
        }
        int width = wrapSize.width;
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return x < this.myStartX2 ? this.myStartX2 - x - width : width - (x - this.myStartX2);
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return x < this.myStartX1 ? this.myStartX1 - x - width : width - (x - this.myStartX1);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int snapToWrapHeight(int y) {
        Dimension wrapSize = this.getWrapSize();
        if (wrapSize == null) {
            return Integer.MAX_VALUE;
        }
        int height = wrapSize.height;
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return y < this.myStartY2 ? this.myStartY2 - y - height : height - (y - this.myStartY2);
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return y < this.myStartY1 ? this.myStartY1 - y - height : height - (y - this.myStartY1);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int snapToParentBoundaryX(int x) {
        SceneComponent parent = this.myComponent.getParent();
        if (parent == null) {
            return Integer.MAX_VALUE;
        }
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return x < this.myStartX2 ? -x : parent.getDrawWidth() - (x - this.myStartX2);
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return x < this.myStartX1 ? -x : parent.getDrawWidth() - (x - this.myStartX1);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int snapToParentBoundaryY(int y) {
        SceneComponent parent = this.myComponent.getParent();
        if (parent == null) {
            return Integer.MAX_VALUE;
        }
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return y < this.myStartY2 ? -y : parent.getDrawHeight() - (y - this.myStartY2);
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return y < this.myStartY1 ? -y : parent.getDrawHeight() - (y - this.myStartY1);
            }
        }
        return Integer.MAX_VALUE;
    }
}

