/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class Insets {
    public static final Insets NONE = new Insets(0, 0, 0, 0);
    public final int left;
    public final int top;
    public final int right;
    public final int bottom;

    public Insets(int left2, int top, int right2, int bottom2) {
        this.left = left2;
        this.right = right2;
        this.top = top;
        this.bottom = bottom2;
    }

    public boolean isEmpty() {
        return this == NONE || this.left == 0 && this.top == 0 && this.right == 0 && this.bottom == 0;
    }

    public boolean subtractFrom(Rectangle bounds2) {
        if (this.isEmpty()) {
            return false;
        }
        bounds2.x -= this.left;
        bounds2.width += this.left;
        bounds2.y -= this.top;
        bounds2.height += this.top;
        bounds2.width += this.right;
        bounds2.height += this.bottom;
        return true;
    }

    public boolean addTo(Rectangle bounds2) {
        if (this.isEmpty()) {
            return false;
        }
        bounds2.x += this.left;
        bounds2.width -= this.left;
        bounds2.y += this.top;
        bounds2.height -= this.top;
        bounds2.width -= this.right;
        bounds2.height -= this.bottom;
        return true;
    }

    public int width() {
        return this.left + this.right;
    }

    public int height() {
        return this.top + this.bottom;
    }

    @NotNull
    public String toString() {
        return "Margins [left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Insets insets = (Insets)o;
        if (this.bottom != insets.bottom) {
            return false;
        }
        if (this.left != insets.left) {
            return false;
        }
        if (this.right != insets.right) {
            return false;
        }
        return this.top == insets.top;
    }

    public int hashCode() {
        int result2 = this.left;
        result2 = 31 * result2 + this.top;
        result2 = 31 * result2 + this.right;
        result2 = 31 * result2 + this.bottom;
        return result2;
    }
}

