/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.DBSCANColorExtractor;
import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.android.tools.idea.uibuilder.mockup.editor.creators.forms.ViewAndColorForm;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SimpleViewCreator
extends WidgetCreator {
    private final Rectangle mySelectionBounds;
    Rectangle myAndroidBounds = new Rectangle();

    public SimpleViewCreator(@NotNull Mockup mockup, @NotNull NlModel model2, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        super(mockup, model2, screenView);
        this.mySelectionBounds = selection;
        Rectangle cropping = this.getMockup().getComputedCropping();
        NlComponent component = this.getMockup().getComponent();
        float xScale = (float)NlComponentHelperKt.getW(component) / (float)cropping.width;
        float yScale = (float)NlComponentHelperKt.getH(component) / (float)cropping.height;
        this.myAndroidBounds.setBounds(Math.round(xScale * (float)this.mySelectionBounds.x), Math.round(yScale * (float)this.mySelectionBounds.y), Math.round(xScale * (float)this.mySelectionBounds.width), Math.round(yScale * (float)this.mySelectionBounds.height));
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        return "View";
    }

    protected void extractColor(@NotNull BufferedImage image, @NotNull ColorExtractor.ColorExtractorCallback callback2) {
        Rectangle realCropping = this.getMockup().getComputedCropping();
        Rectangle selectionBounds = this.getSelectionBounds();
        BufferedImage subimage = image.getSubimage(realCropping.x + selectionBounds.x, realCropping.y + selectionBounds.y, selectionBounds.width, selectionBounds.height);
        DBSCANColorExtractor colorExtractor = new DBSCANColorExtractor(subimage, 1.3f, DBSCANColorExtractor.getMinClusterSize(subimage));
        ((ColorExtractor)colorExtractor).run(callback2);
    }

    protected void extractColor(final ViewAndColorForm viewAndColorForm, BufferedImage image) {
        this.extractColor(image, new ColorExtractor.ColorExtractorCallback(){

            @Override
            public void result(Collection<ExtractedColor> rgbColors) {
                viewAndColorForm.addColors(rgbColors);
            }

            @Override
            public void progress(int progress) {
                viewAndColorForm.setProgress(progress);
            }
        });
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        this.addLayoutEditorPositionAttribute(transaction, this.myAndroidBounds);
        this.addSizeAttributes(transaction, this.myAndroidBounds);
        this.addMockupAttributes(transaction, this.mySelectionBounds);
    }

    public Rectangle getAndroidBounds() {
        return this.myAndroidBounds;
    }

    public Rectangle getSelectionBounds() {
        return this.mySelectionBounds;
    }
}

