/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.WidgetCreator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public final class ResourcesUtil {
    private static final Logger LOGGER = Logger.getInstance(ResourcesUtil.class);

    public static boolean checkDrawableExist(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet2) {
        List<VirtualFile> drawableSubDirs = IdeResourcesUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, ResourceRepositoryManager.getModuleResources(facet2).getResourceDirs());
        for (VirtualFile dir : drawableSubDirs) {
            if (dir.findChild(String.format("%s.%s", drawableName, drawableType)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull NlModel model2, @NotNull BufferedImage image, @NotNull Object requestor) {
        AndroidFacet facet2 = model2.getFacet();
        List<VirtualFile> drawableSubDirs = IdeResourcesUtil.getResourceSubdirs(ResourceFolderType.DRAWABLE, ResourceRepositoryManager.getModuleResources(facet2).getResourceDirs());
        try {
            byte[] imageInByte = ResourcesUtil.imageToByteArray(image, drawableType);
            Project project = model2.getProject();
            if (!drawableSubDirs.isEmpty()) {
                ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableSubDirs.get(0), doneCallback, requestor);
            } else {
                ResourcesUtil.createDrawableAndFolder(drawableName, drawableType, facet2, imageInByte, project, doneCallback, requestor);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Error while converting image to bytes");
            return false;
        }
    }

    public static boolean createDrawable(@NotNull String drawableName, @NotNull String drawableType, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Mockup mockup, @NotNull NlModel model2, @NotNull Rectangle selectionBounds, @NotNull Object requestor) {
        BufferedImage image = mockup.getImage();
        if (image == null) {
            return false;
        }
        Rectangle realCropping = mockup.getComputedCropping();
        BufferedImage subImage = image.getSubimage(selectionBounds.x + realCropping.x, selectionBounds.y + realCropping.y, selectionBounds.width, selectionBounds.height);
        return ResourcesUtil.createDrawable(drawableName, drawableType, doneCallback, model2, subImage, requestor);
    }

    public static byte[] imageToByteArray(BufferedImage subImage, String imageType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)subImage, imageType, baos);
        baos.flush();
        byte[] imageInByte = baos.toByteArray();
        baos.close();
        return imageInByte;
    }

    private static void createDrawableAndFolder(@NotNull String drawableName, @NotNull String drawableType, @NotNull AndroidFacet facet2, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        Iterable<VirtualFile> resDirectories = SourceProviderManager.getInstance(facet2).getMainIdeaSourceProvider().getResDirectories();
        Iterator<VirtualFile> iterator = resDirectories.iterator();
        if (iterator.hasNext()) {
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    VirtualFile drawableDir = AndroidUtils.createChildDirectoryIfNotExist(project, (VirtualFile)iterator.next(), "drawable");
                    ResourcesUtil.createDrawableFile(drawableName + "." + drawableType, imageInByte, project, drawableDir, doneCallback, requestor);
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
            }), "Export selection to drawable", null);
        }
    }

    private static void createDrawableFile(@NotNull String fileName, @NotNull byte[] imageInByte, @NotNull Project project, @NotNull VirtualFile drawableDir, @NotNull WidgetCreator.DoneCallback doneCallback, @NotNull Object requestor) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VirtualFile folder = drawableDir.createChildData(requestor, fileName);
                folder.setBinaryContent(imageInByte);
                doneCallback.done(1);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                doneCallback.done(0);
            }
        }), "Export selection to drawable", null);
    }
}

