/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.colorextractor.ExtractedColor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;

public final class ImageUtils {
    static BufferedImage posterize(BufferedImage image, Collection<ExtractedColor> colorsCollection) {
        HashMap<Integer, Integer> rgbToExtractedColor = new HashMap<Integer, Integer>();
        BufferedImage copy2 = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        int width = copy2.getWidth();
        int height = copy2.getHeight();
        int[] pixels = image.getRGB(0, 0, width, height, null, 0, width);
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            Integer replacementColor;
            int rgb = pixels[i2];
            if (!rgbToExtractedColor.containsKey(rgb)) {
                for (ExtractedColor extractedColor : colorsCollection) {
                    if (!extractedColor.getNeighborColor().contains(rgb)) continue;
                    rgbToExtractedColor.put(rgb, extractedColor.getColor());
                }
            }
            pixels[i2] = (replacementColor = (Integer)rgbToExtractedColor.get(rgb)) != null ? replacementColor.intValue() : JBColor.CYAN.getRGB();
        }
        copy2.setRGB(0, 0, width, height, pixels, 0, width);
        return copy2;
    }

    @VisibleForTesting
    public static BufferedImage createScaledImage(BufferedImage image, int maxImageSize) {
        int longestEdge = Math.max(image.getHeight(), image.getWidth());
        if (longestEdge < maxImageSize) {
            return image;
        }
        double scale = (double)maxImageSize / (double)longestEdge;
        AffineTransform transform = new AffineTransform();
        transform.scale(scale, scale);
        int newWidth = (int)Math.round((double)image.getWidth() * scale);
        int newHeight = (int)Math.round((double)image.getHeight() * scale);
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, transform, null);
        return newImage;
    }
}

