/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.layout3d;

import com.android.tools.idea.uibuilder.layout3d.Matrix;
import com.android.tools.idea.uibuilder.layout3d.Quaternion;
import com.android.tools.idea.uibuilder.layout3d.TriData;
import com.android.tools.idea.uibuilder.layout3d.VectorUtil;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.Arrays;

public class ViewMatrix
extends Matrix {
    double[] myLookPoint;
    double[] myEyePoint;
    double[] myUpVector;
    double myScreenWidth;
    int[] myScreenDim;
    public static final char UP_AT = '\u0001';
    public static final char DOWN_AT = '\u0002';
    public static final char RIGHT_AT = '\u0010';
    public static final char LEFT_AT = ' ';
    public static final char FORWARD_AT = '\u0100';
    public static final char BEHIND_AT = '\u0200';
    private static DecimalFormat df = new DecimalFormat("##0.000");
    int mStartx;
    int mStarty;
    Matrix mStartMatrix;
    double[] mStartV = new double[3];
    double[] mMoveToV = new double[3];
    double[] mStartEyePoint;
    double[] mStartUpVector;
    Quaternion mQ = new Quaternion(0.0, 0.0, 0.0, 0.0);

    private static String toStr(double d) {
        String s = "       " + df.format(d);
        return s.substring(s.length() - 8);
    }

    private static String toStr(double[] d) {
        String s = "[";
        for (int i2 = 0; i2 < d.length; ++i2) {
            s = s + ViewMatrix.toStr(d[i2]);
        }
        return s + "]";
    }

    @Override
    public void print() {
        System.out.println("myLookPoint  :" + ViewMatrix.toStr(this.myLookPoint));
        System.out.println("myEyePoint   :" + ViewMatrix.toStr(this.myEyePoint));
        System.out.println("myUpVector   :" + ViewMatrix.toStr(this.myUpVector));
        System.out.println("myScreenWidth:" + ViewMatrix.toStr(this.myScreenWidth));
        System.out.println("myScreenDim  :[" + this.myScreenDim[0] + "," + this.myScreenDim[1] + "]");
    }

    public void setScreenDim(int x, int y) {
        this.myScreenDim = new int[]{x, y};
    }

    public double[] getLookPoint() {
        return this.myLookPoint;
    }

    public void setLookPoint(double[] mLookPoint) {
        this.myLookPoint = mLookPoint;
    }

    public double[] getEyePoint() {
        return this.myEyePoint;
    }

    public void setEyePoint(double[] mEyePoint) {
        this.myEyePoint = mEyePoint;
    }

    public double[] getUpVector() {
        return this.myUpVector;
    }

    public void setUpVector(double[] mUpVector) {
        this.myUpVector = mUpVector;
    }

    public double getScreenWidth() {
        return this.myScreenWidth;
    }

    public void setScreenWidth(double screenWidth) {
        this.myScreenWidth = screenWidth;
    }

    public void makeUnit() {
    }

    public double screenDistance() {
        double[] zv = new double[]{this.myLookPoint[0] - this.myEyePoint[0], this.myLookPoint[1] - this.myEyePoint[1], this.myLookPoint[2] - this.myEyePoint[2]};
        return VectorUtil.norm(zv);
    }

    public void calcMatrix() {
        if (this.myScreenDim == null) {
            return;
        }
        double scale = this.myScreenWidth / (double)this.myScreenDim[0];
        double[] zv = new double[]{this.myLookPoint[0] - this.myEyePoint[0], this.myLookPoint[1] - this.myEyePoint[1], this.myLookPoint[2] - this.myEyePoint[2]};
        VectorUtil.normalize(zv);
        double[] m = new double[16];
        m[2] = zv[0] * scale;
        m[6] = zv[1] * scale;
        m[10] = zv[2] * scale;
        m[14] = 0.0;
        ViewMatrix.calcRight(zv, this.myUpVector, zv);
        double[] right2 = zv;
        m[0] = right2[0] * scale;
        m[4] = right2[1] * scale;
        m[8] = right2[2] * scale;
        m[12] = 0.0;
        m[1] = -this.myUpVector[0] * scale;
        m[5] = -this.myUpVector[1] * scale;
        m[9] = -this.myUpVector[2] * scale;
        m[13] = 0.0;
        double sw = (double)(this.myScreenDim[0] / 2) - 0.5;
        double sh = (double)(this.myScreenDim[1] / 2) - 0.5;
        double sz = -0.5;
        m[3] = this.myEyePoint[0] - (m[0] * sw + m[1] * sh + m[2] * sz);
        m[7] = this.myEyePoint[1] - (m[4] * sw + m[5] * sh + m[6] * sz);
        m[11] = this.myEyePoint[2] - (m[8] * sw + m[9] * sh + m[10] * sz);
        m[15] = 1.0;
        this.m = m;
    }

    static void calcRight(double[] a, double[] b, double[] out) {
        VectorUtil.cross(a, b, out);
    }

    public static void main(String[] args) {
        double[] up = new double[]{0.0, 0.0, 1.0};
        double[] look = new double[]{0.0, 0.0, 0.0};
        double[] eye = new double[]{-10.0, 0.0, 0.0};
        ViewMatrix v = new ViewMatrix();
        v.setEyePoint(eye);
        v.setLookPoint(look);
        v.setUpVector(up);
        v.setScreenWidth(10.0);
        v.setScreenDim(512, 512);
        v.calcMatrix();
    }

    private void calcLook(TriData tri, float[] voxelDim, int w, int h) {
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float minz = Float.MAX_VALUE;
        float maxx = -3.4028235E38f;
        float maxy = -3.4028235E38f;
        float maxz = -3.4028235E38f;
        for (int i2 = 0; i2 < tri.myVert.length; i2 += 3) {
            maxx = Math.max(tri.myVert[i2], maxx);
            minx = Math.min(tri.myVert[i2], minx);
            maxy = Math.max(tri.myVert[i2 + 1], maxy);
            miny = Math.min(tri.myVert[i2 + 1], miny);
            maxz = Math.max(tri.myVert[i2 + 2], maxz);
            minz = Math.min(tri.myVert[i2 + 2], minz);
        }
        this.myLookPoint = new double[]{voxelDim[0] * (maxx + minx) / 2.0f, voxelDim[1] * (maxy + miny) / 2.0f, voxelDim[2] * (maxz + minz) / 2.0f};
        this.myScreenWidth = Math.max(voxelDim[0] * (maxx - minx), Math.max(voxelDim[1] * (maxy - miny), voxelDim[2] * (maxz - minz))) * 2.0f;
    }

    private void calcLook(TriData triW) {
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float minz = Float.MAX_VALUE;
        float maxx = -3.4028235E38f;
        float maxy = -3.4028235E38f;
        float maxz = -3.4028235E38f;
        for (int i2 = 0; i2 < triW.myVert.length; i2 += 3) {
            maxx = Math.max(triW.myVert[i2], maxx);
            minx = Math.min(triW.myVert[i2], minx);
            maxy = Math.max(triW.myVert[i2 + 1], maxy);
            miny = Math.min(triW.myVert[i2 + 1], miny);
            maxz = Math.max(triW.myVert[i2 + 2], maxz);
            minz = Math.min(triW.myVert[i2 + 2], minz);
        }
        this.myLookPoint = new double[]{(maxx + minx) / 2.0f, (maxy + miny) / 2.0f, (maxz + minz) / 2.0f};
        this.myScreenWidth = Math.max(maxx - minx, Math.max(maxy - miny, maxz - minz));
    }

    public void look(char dir, TriData tri, int width, int height) {
        this.calcLook(tri);
        int dx = dir >> 4 & 0xF;
        int dy = dir >> 8 & 0xF;
        int dz = dir >> 0 & 0xF;
        if (dx > 1) {
            dx = -1;
        }
        if (dy > 1) {
            dy = -1;
        }
        if (dz > 1) {
            dz = -1;
        }
        this.myEyePoint = new double[]{this.myLookPoint[0] + 2.0 * this.myScreenWidth * (double)dx, this.myLookPoint[1] + 2.0 * this.myScreenWidth * (double)dy, this.myLookPoint[2] + 2.0 * this.myScreenWidth * (double)dz};
        double[] zv = new double[]{-dx, -dy, -dz};
        double[] rv = new double[]{dx == 0 ? 1.0 : 0.0, dx == 0 ? 0.0 : 1.0, 0.0};
        double[] up = new double[3];
        VectorUtil.norm(zv);
        VectorUtil.norm(rv);
        VectorUtil.cross(zv, rv, up);
        VectorUtil.cross(zv, up, rv);
        VectorUtil.cross(zv, rv, up);
        this.myUpVector = up;
        this.myScreenDim = new int[]{width, height};
        this.calcMatrix();
    }

    public void lookAt(TriData tri, float[] voxelDim, int w, int h) {
        this.calcLook(tri, voxelDim, w, h);
        this.myEyePoint = new double[]{this.myLookPoint[0] + this.myScreenWidth, this.myLookPoint[1] + this.myScreenWidth, this.myLookPoint[2] + this.myScreenWidth};
        double[] zv = new double[]{-1.0, -1.0, -1.0};
        double[] rv = new double[]{1.0, 1.0, 0.0};
        double[] up = new double[3];
        VectorUtil.norm(zv);
        VectorUtil.norm(rv);
        VectorUtil.cross(zv, rv, up);
        VectorUtil.cross(zv, up, rv);
        VectorUtil.cross(zv, rv, up);
        this.myUpVector = up;
        this.myScreenDim = new int[]{w, h};
        this.calcMatrix();
    }

    public void trackBallUP(int x, int y) {
    }

    public void trackBallDown(int x, int y) {
        this.mStartx = x;
        this.mStarty = y;
        this.ballToVec(x, y, this.mStartV);
        this.mStartEyePoint = Arrays.copyOf(this.myEyePoint, this.m.length);
        this.mStartUpVector = Arrays.copyOf(this.myUpVector, this.m.length);
        this.mStartMatrix = new Matrix(this);
        this.mStartMatrix.makeRotation();
    }

    public void trackBallMove(int x, int y) {
        this.ballToVec(x, y, this.mMoveToV);
        double angle = Quaternion.calcAngle(this.mStartV, this.mMoveToV);
        double[] axis = Quaternion.calcAxis(this.mStartV, this.mMoveToV);
        axis = this.mStartMatrix.vecmult(axis);
        this.mQ.set(angle, axis);
        VectorUtil.sub(this.myLookPoint, this.mStartEyePoint, this.myEyePoint);
        this.myEyePoint = this.mQ.rotateVec(this.myEyePoint);
        this.myUpVector = this.mQ.rotateVec(this.mStartUpVector);
        VectorUtil.sub(this.myLookPoint, this.myEyePoint, this.myEyePoint);
        this.calcMatrix();
    }

    void ballToVec(int x, int y, double[] v) {
        double cy;
        double dy;
        double cx = (double)this.myScreenDim[0] / 2.0;
        float ballRadius = (float)Math.min(this.myScreenDim[0], this.myScreenDim[1]) * 0.4f;
        double dx = (cx - (double)x) / (double)ballRadius;
        double scale = dx * dx + (dy = ((cy = (double)this.myScreenDim[1] / 2.0) - (double)y) / (double)ballRadius) * dy;
        if (scale > 1.0) {
            scale = Math.sqrt(scale);
            dx /= scale;
            dy /= scale;
        }
        double dz = Math.sqrt(Math.abs(1.0 - (dx * dx + dy * dy)));
        v[0] = dx;
        v[1] = dy;
        v[2] = dz;
        VectorUtil.normalize(v);
    }

    public String getOrientationString(Rectangle rect) {
        String ret2 = "";
        ret2 = ret2 + this.myEyePoint[0] + ",";
        ret2 = ret2 + this.myEyePoint[1] + ",";
        ret2 = ret2 + this.myEyePoint[2] + ",";
        ret2 = ret2 + this.myUpVector[0] + ",";
        ret2 = ret2 + this.myUpVector[1] + ",";
        ret2 = ret2 + this.myUpVector[2] + ",";
        ret2 = ret2 + this.myLookPoint[0] + ",";
        ret2 = ret2 + this.myLookPoint[1] + ",";
        ret2 = ret2 + this.myLookPoint[2] + ",";
        ret2 = ret2 + this.myScreenWidth + ",";
        ret2 = ret2 + this.myScreenDim[0] + ",";
        ret2 = ret2 + this.myScreenDim[1] + ",";
        ret2 = ret2 + rect.x + ",";
        ret2 = ret2 + rect.y + ",";
        ret2 = ret2 + rect.width + ",";
        ret2 = ret2 + rect.height + ",";
        return ret2;
    }

    public Rectangle parseOrientationString(String str) {
        String[] sp = str.split(",");
        int c = 0;
        this.myLookPoint = new double[3];
        this.myEyePoint[0] = Double.parseDouble(sp[c++]);
        this.myEyePoint[1] = Double.parseDouble(sp[c++]);
        this.myEyePoint[2] = Double.parseDouble(sp[c++]);
        this.myUpVector[0] = Double.parseDouble(sp[c++]);
        this.myUpVector[1] = Double.parseDouble(sp[c++]);
        this.myUpVector[2] = Double.parseDouble(sp[c++]);
        this.myLookPoint[0] = Double.parseDouble(sp[c++]);
        this.myLookPoint[1] = Double.parseDouble(sp[c++]);
        this.myLookPoint[2] = Double.parseDouble(sp[c++]);
        this.myScreenWidth = Double.parseDouble(sp[c++]);
        this.myScreenDim[0] = Integer.parseInt(sp[c++]);
        this.myScreenDim[1] = Integer.parseInt(sp[c++]);
        Rectangle rect = new Rectangle();
        rect.x = Integer.parseInt(sp[c++]);
        rect.y = Integer.parseInt(sp[c++]);
        rect.width = Integer.parseInt(sp[c++]);
        rect.height = Integer.parseInt(sp[c++]);
        this.calcMatrix();
        return rect;
    }
}

