/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutResizeBaseTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class MotionLayoutResizeTarget
extends MotionLayoutResizeBaseTarget {
    public MotionLayoutResizeTarget(@NotNull ResizeBaseTarget.Type type) {
        super(type);
    }

    @Override
    public int getPreferenceLevel() {
        if (this.myType == ResizeBaseTarget.Type.LEFT || this.myType == ResizeBaseTarget.Type.RIGHT || this.myType == ResizeBaseTarget.Type.TOP || this.myType == ResizeBaseTarget.Type.BOTTOM) {
            return 50;
        }
        return 60;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        MotionLayoutComponentHelper motionLayout;
        if (this.myType == ResizeBaseTarget.Type.LEFT || this.myType == ResizeBaseTarget.Type.RIGHT || this.myType == ResizeBaseTarget.Type.TOP || this.myType == ResizeBaseTarget.Type.BOTTOM) {
            return;
        }
        NlComponent parent = this.myComponent.getNlComponent().getParent();
        if (parent != null && (motionLayout = MotionLayoutComponentHelper.create(parent)).isInTransition()) {
            return;
        }
        super.render(list, sceneContext);
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    private static void updateWidth(@NotNull NlAttributesHolder attributes, int w) {
        if (w < 0) {
            w = 0;
        }
        String position = String.format(Locale.US, "%ddp", w);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", position);
    }

    private static void updateHeight(@NotNull NlAttributesHolder attributes, int h) {
        if (h < 0) {
            h = 0;
        }
        String position = String.format(Locale.US, "%ddp", h);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", position);
    }

    private static void updatePositionX(@NotNull NlAttributesHolder attributes, int x) {
        String positionX = String.format(Locale.US, "%ddp", x);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
    }

    private static void updatePositionY(@NotNull NlAttributesHolder attributes, int y) {
        String positionY = String.format(Locale.US, "%ddp", y);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        switch (this.myType) {
            case RIGHT_TOP: {
                MotionLayoutResizeTarget.updateWidth(attributes, x - this.myStartX1);
                MotionLayoutResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                MotionLayoutResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case RIGHT_BOTTOM: {
                MotionLayoutResizeTarget.updateWidth(attributes, x - this.myStartX1);
                MotionLayoutResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT_TOP: {
                MotionLayoutResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                MotionLayoutResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                MotionLayoutResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                MotionLayoutResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case LEFT_BOTTOM: {
                MotionLayoutResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                MotionLayoutResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                MotionLayoutResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT: {
                MotionLayoutResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                MotionLayoutResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                break;
            }
            case TOP: {
                MotionLayoutResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                MotionLayoutResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case BOTTOM: {
                MotionLayoutResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case RIGHT: {
                MotionLayoutResizeTarget.updateWidth(attributes, x - this.myStartX1);
            }
        }
    }

    private static void updateWidth(@NotNull MTag.TagWriter attributes, int w) {
        if (w < 0) {
            w = 0;
        }
        String position = String.format(Locale.US, "%ddp", w);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", position);
    }

    private static void updateHeight(@NotNull MTag.TagWriter attributes, int h) {
        if (h < 0) {
            h = 0;
        }
        String position = String.format(Locale.US, "%ddp", h);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", position);
    }

    private static void updatePositionX(@NotNull MTag.TagWriter attributes, int x) {
        String positionX = String.format(Locale.US, "%ddp", x);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
    }

    private static void updatePositionY(@NotNull MTag.TagWriter attributes, int y) {
        String positionY = String.format(Locale.US, "%ddp", y);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
    }

    @Override
    protected void updateAttributes(@NotNull MTag.TagWriter attributes, int x, int y) {
        switch (this.myType) {
            case RIGHT_TOP: {
                MotionLayoutResizeTarget.updateWidth(attributes, x - this.myStartX1);
                MotionLayoutResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                MotionLayoutResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case RIGHT_BOTTOM: {
                MotionLayoutResizeTarget.updateWidth(attributes, x - this.myStartX1);
                MotionLayoutResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT_TOP: {
                MotionLayoutResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                MotionLayoutResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                MotionLayoutResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                MotionLayoutResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case LEFT_BOTTOM: {
                MotionLayoutResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                MotionLayoutResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                MotionLayoutResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case LEFT: {
                MotionLayoutResizeTarget.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                MotionLayoutResizeTarget.updateWidth(attributes, this.myStartX2 - x);
                break;
            }
            case TOP: {
                MotionLayoutResizeTarget.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                MotionLayoutResizeTarget.updateHeight(attributes, this.myStartY2 - y);
                break;
            }
            case BOTTOM: {
                MotionLayoutResizeTarget.updateHeight(attributes, y - this.myStartY1);
                break;
            }
            case RIGHT: {
                MotionLayoutResizeTarget.updateWidth(attributes, x - this.myStartX1);
            }
        }
    }
}

