/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.BaseCreatePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class CreateConstraintSet
extends BaseCreatePanel {
    static String TITLE = "Create ConstraintSet";
    String MOTION_LAYOUT = "MotionLayout";
    JComboBox<String> comboBox = MEUI.makeComboBox(new String[]{this.MOTION_LAYOUT});
    protected JTextField mId;

    public CreateConstraintSet() {
        this.icon = MEIcons.CREATE_CONSTRAINTSET;
        this.comboBox.setEditable(true);
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        CreateConstraintSet.grid(gbc, 0, y++, 1, 1);
        gbc.ipadx = MEUI.scale(40);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogTitleInsets();
        gbc.fill = 2;
        this.add((Component)new JLabel("CREATE CONSTRAINTSET"), gbc);
        CreateConstraintSet.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogSeparatorInsets();
        gbc.anchor = 10;
        this.add((Component)new JSeparator(), gbc);
        CreateConstraintSet.grid(gbc, 0, y++);
        gbc.weighty = 0.0;
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("ID"), gbc);
        CreateConstraintSet.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.mId = this.newTextField("Enter id", 15);
        this.add((Component)this.mId, gbc);
        CreateConstraintSet.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogLabelInsets();
        gbc.anchor = 10;
        this.add((Component)new JLabel("Based On"), gbc);
        CreateConstraintSet.grid(gbc, 0, y++);
        gbc.insets = MEUI.dialogControlInsets();
        gbc.anchor = 10;
        this.add(this.comboBox, gbc);
        gbc.weighty = 1.0;
        CreateConstraintSet.grid(gbc, 0, y++, 2, 1);
        this.add((Component)new JComponent(){}, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = MEUI.dialogBottomButtonInsets();
        gbc.anchor = 14;
        CreateConstraintSet.grid(gbc, 0, y++, 2, 1);
        JButton ok = new JButton("Add");
        this.add((Component)ok, gbc);
        ok.addActionListener(e -> this.create());
    }

    @Override
    protected boolean populateDialog() {
        MeModel model2 = this.mMotionEditor.getMeModel();
        MTag[] mtags = model2.motionScene.getChildTags("ConstraintSet");
        this.comboBox.removeAllItems();
        this.comboBox.addItem(this.MOTION_LAYOUT);
        this.mId.setText(null);
        for (int i2 = 0; i2 < mtags.length; ++i2) {
            String id = mtags[i2].getAttributeValue("id");
            this.comboBox.addItem(Utils.stripID(id));
        }
        return true;
    }

    @Override
    public MTag create() {
        String id = this.mId.getText().trim();
        if (id.isEmpty()) {
            this.showErrorDialog("ConstraintSet must have a valid id");
            return null;
        }
        MeModel model2 = this.mMotionEditor.getMeModel();
        MTag.TagWriter writer = model2.motionScene.getChildTagWriter("ConstraintSet");
        writer.setAttribute("android", "id", this.addIdPrefix(id));
        if (this.comboBox.getSelectedIndex() != 0) {
            String derivesFrom = (String)this.comboBox.getSelectedItem();
            writer.setAttribute("motion", "deriveConstraintsFrom", this.addIdPrefix(derivesFrom));
        }
        MTag ret2 = writer.commit("Create ConstraintSet");
        Track.createConstraintSet(this.mMotionEditor.myTrack);
        this.mMotionEditor.setMTag(model2);
        super.create();
        return ret2;
    }

    @Override
    public String getName() {
        return "ConstraintSet";
    }
}

