/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Arrays;

public class DrawMotionPath
implements DrawCommand {
    private static final boolean WHITE_PATH = true;
    private final float[] mKeyFramesPos;
    private final int[] mKeyFramesType;
    private float[] mPath;
    private GeneralPath ourPath = new GeneralPath();
    private AffineTransform at = new AffineTransform();
    private static final Color myGridColor = JBColor.namedColor((String)"UIDesigner.motion.Grid.lineSeparatorColor", (int)-3487030, (int)-3487030);
    private static final Color myAxisColor = JBColor.namedColor((String)"UIDesigner.motion.Axis.lineSeparatorColor", (int)-6842473, (int)-6842473);
    private static final Color myPointLabelBackground = JBColor.namedColor((String)"UIDesigner.motion.label.background", (int)-526345, (int)-11842227);
    private static final Color myPointLabelShadow = JBColor.namedColor((String)"UIDesigner.motion.label.shadowColor", (int)0x33000000, (int)0x33000000);
    private static final Color myPointLabelText = JBColor.namedColor((String)"UIDesigner.motion.label.textColor", (int)-16777216, (int)-4342339);
    private static BasicStroke ourBasicStroke = new BasicStroke(1.0f);
    private static BasicStroke ourShadowStroke = new BasicStroke(1.0f);
    private static BasicStroke ourAxis = new BasicStroke(2.0f);
    private static BasicStroke ourMajorLines = new BasicStroke(1.0f);
    private float mViewX;
    private float mViewY;
    private float mViewWidth;
    private float mViewHeight;
    int[] xpath = new int[4];
    int[] ypath = new int[4];
    boolean mSelected = false;
    int mSelectedKey;
    private GeneralPath mGridAxis = new GeneralPath();
    private GeneralPath mGridMajor = new GeneralPath();
    public static final int TYPE_SCREEN = 2;
    public static final int TYPE_PATH = 1;
    public static final int TYPE_CARTESIAN = 0;
    private float drawXaxisX;
    private float drawXaxisY;
    private float drawYaxisX;
    private float drawYaxisY;
    String mPercent;
    DecimalFormat myPercentFormat = new DecimalFormat("#.000");
    JBColor myPointBackground = new JBColor(new Color(-2008866049, true), new Color(-2008866049, true));
    private Color myLineColor = new JBColor(-65281, -65281);

    DrawMotionPath(boolean selected, int selected_key, int key_pos_type, float[] path2, int pathSize, int[] keyFramesType, float[] keyFramePos, int keyFramesSize, float vx, float vy, float vw, float vh, float cbx, float cby, float cbw, float cbh, float percentX, float percentY) {
        this.mSelectedKey = selected_key;
        this.mPath = Arrays.copyOf(path2, pathSize);
        this.ourPath.reset();
        this.mViewX = vx;
        this.mViewY = vy;
        this.mViewWidth = vw;
        this.mViewHeight = vh;
        this.mSelected = selected;
        this.mGridAxis.reset();
        this.mGridMajor.reset();
        this.mPercent = !Float.isNaN(percentX) ? "(" + this.myPercentFormat.format(percentX) + "," + this.myPercentFormat.format(percentY) + ")" : "";
        this.drawXaxisX = Float.NaN;
        if (pathSize >= 4 && selected_key >= 0) {
            switch (key_pos_type) {
                default: {
                    this.graphDeltaXY();
                    break;
                }
                case 1: {
                    this.graphPathRelative();
                    break;
                }
                case 2: {
                    this.graphDeltaParent(cbx, cby, cbw, cbh);
                }
            }
        }
        for (int i2 = 0; i2 < pathSize; i2 += 2) {
            float x = this.mPath[i2];
            float y = this.mPath[i2 + 1];
            if ((i2 & 2) == 0) {
                this.ourPath.moveTo(x, y);
                continue;
            }
            this.ourPath.lineTo(x, y);
        }
        if (keyFramesSize > 0) {
            this.mKeyFramesPos = Arrays.copyOf(keyFramePos, keyFramesSize * 2);
            this.mKeyFramesType = Arrays.copyOf(keyFramesType, keyFramesSize);
        } else {
            this.mKeyFramesPos = null;
            this.mKeyFramesType = null;
        }
    }

    private void drawArrow(float tipx, float tipy, float dirX, float dirY) {
        float hyp = (float)(1.0 / Math.hypot(dirX, dirY));
        float arrowSize = 10.0f;
        this.mGridAxis.moveTo(tipx, tipy);
        float px = tipx + arrowSize * ((dirY *= hyp) - (dirX *= hyp));
        float py = tipy + arrowSize * (-dirX - dirY);
        this.mGridAxis.lineTo(px, py);
        this.mGridAxis.moveTo(tipx, tipy);
        px = tipx + arrowSize * (-dirY - dirX);
        py = tipy + arrowSize * (dirX - dirY);
        this.mGridAxis.lineTo(px, py);
    }

    private void graphDeltaXY() {
        float mStartX = this.mPath[0];
        float mStartY = this.mPath[1];
        float mEndX = this.mPath[this.mPath.length - 2];
        float mEndY = this.mPath[this.mPath.length - 1];
        for (int i2 = 0; i2 <= 100; i2 += 10) {
            float x = mStartX + (mEndX - mStartX) * (float)i2 / 100.0f;
            float y = mStartY + (mEndY - mStartY) * (float)i2 / 100.0f;
            if (i2 == 0) {
                this.mGridAxis.moveTo(x, mStartY);
                this.mGridAxis.lineTo(x, mEndY);
                this.mGridAxis.moveTo(mStartX, y);
                this.mGridAxis.lineTo(mEndX, y);
                continue;
            }
            this.mGridMajor.moveTo(x, mStartY);
            this.mGridMajor.lineTo(x, mEndY);
            this.mGridMajor.moveTo(mStartX, y);
            this.mGridMajor.lineTo(mEndX, y);
        }
        this.drawArrow(mStartX, mEndY, 0.0f, mEndY - mStartY);
        this.drawArrow(mEndX, mStartY, mEndX - mStartX, 0.0f);
        float xoffsetY = mStartY > mEndY ? 30.0f : -30.0f;
        float yoffsetX = mStartX > mEndX ? 30.0f : -30.0f;
        float char_width = 10.0f;
        float char_assent = 10.0f;
        this.drawXaxisX = mEndX - char_width;
        this.drawXaxisY = mStartY + xoffsetY;
        this.drawYaxisX = mStartX + yoffsetX;
        this.drawYaxisY = mEndY + char_assent;
    }

    private void graphPathRelative() {
        float yp2;
        float xp2;
        float mStartX = this.mPath[0];
        float mStartY = this.mPath[1];
        float mEndX = this.mPath[this.mPath.length - 2];
        float mEndY = this.mPath[this.mPath.length - 1];
        for (int x = 0; x <= 100; x += 10) {
            float y = 0.0f;
            float xp1 = mStartX + (mEndX - mStartX) * (float)x / 100.0f;
            float yp1 = mStartY + (mEndY - mStartY) * (float)x / 100.0f;
            y = 100.0f;
            xp2 = xp1 + (mEndY - mStartY) * y / 100.0f;
            yp2 = yp1 - (mEndX - mStartX) * y / 100.0f;
            y = -100.0f;
            float xp3 = xp1 + (mEndY - mStartY) * y / 100.0f;
            float yp3 = yp1 - (mEndX - mStartX) * y / 100.0f;
            if (x == 0 || x == 100) {
                this.mGridAxis.moveTo(xp2, yp2);
                this.mGridAxis.lineTo(xp3, yp3);
                continue;
            }
            this.mGridMajor.moveTo(xp2, yp2);
            this.mGridMajor.lineTo(xp3, yp3);
        }
        for (int y = -100; y <= 100; y += 10) {
            float xp1 = mStartX + (mEndY - mStartY) * (float)y / 100.0f;
            float yp1 = mStartY - (mEndX - mStartX) * (float)y / 100.0f;
            float x = 100.0f;
            xp2 = xp1 + (mEndX - mStartX) * x / 100.0f;
            yp2 = yp1 + (mEndY - mStartY) * x / 100.0f;
            if (y == -100 || y == 0 || y == 100) {
                this.mGridAxis.moveTo(xp1, yp1);
                this.mGridAxis.lineTo(xp2, yp2);
                continue;
            }
            this.mGridMajor.moveTo(xp1, yp1);
            this.mGridMajor.lineTo(xp2, yp2);
        }
        float xdir_dx = mEndX - mStartX;
        float xdir_dy = mEndY - mStartY;
        float hypot = (float)(1.0 / Math.hypot(xdir_dx, xdir_dy));
        xdir_dx *= hypot;
        xdir_dy *= hypot;
        float ydir_dx = mEndY - mStartY;
        float ydir_dy = -(mEndX - mStartX);
        hypot = (float)(1.0 / Math.hypot(ydir_dx, ydir_dy));
        ydir_dx *= hypot;
        ydir_dy *= hypot;
        float distanceToCenter = 22.0f;
        float x_centerToDrawX = -10.0f;
        float y_centerToDrawX = -8.0f;
        float centerToDrawY = 2.0f;
        this.drawXaxisX = mEndX + xdir_dx * distanceToCenter + x_centerToDrawX;
        this.drawXaxisY = mEndY + xdir_dy * distanceToCenter + centerToDrawY;
        this.drawArrow(mEndX, mEndY, mEndX - mStartX, mEndY - mStartY);
        float xp1 = mStartX - (mEndY - mStartY) * 100.0f / 100.0f;
        float yp1 = mStartY + (mEndX - mStartX) * 100.0f / 100.0f;
        this.drawYaxisX = xp1 - xdir_dx * distanceToCenter + y_centerToDrawX;
        this.drawYaxisY = yp1 - xdir_dy * distanceToCenter + centerToDrawY;
        this.drawArrow(xp1, yp1, -(mEndY - mStartY), mEndX - mStartX);
    }

    private void graphDeltaParent(float vx, float vy, float vw, float vh) {
        for (int i2 = 0; i2 <= 100; i2 += 10) {
            float x = vx + vw * (float)i2 / 100.0f;
            float y = vy + vh * (float)i2 / 100.0f;
            if (i2 == 0) {
                this.mGridAxis.moveTo(x, vy);
                this.mGridAxis.lineTo(x, vy + vh);
                this.mGridAxis.moveTo(vx, y);
                this.mGridAxis.lineTo(vx + vw, y);
                continue;
            }
            this.mGridMajor.moveTo(x, vy);
            this.mGridMajor.lineTo(x, vy + vh);
            this.mGridMajor.moveTo(vx, y);
            this.mGridMajor.lineTo(vx + vw, y);
        }
        this.drawArrow(vx + vw, vy, 1.0f, 0.0f);
        this.drawArrow(vx, vy + vh, 0.0f, 1.0f);
        float xoffsetY = -10.0f;
        float yoffsetX = -30.0f;
        float char_width = 10.0f;
        float char_assent = 10.0f;
        this.drawXaxisX = vx + vw - char_width;
        this.drawXaxisY = vy + xoffsetY;
        this.drawYaxisX = vx + yoffsetX;
        this.drawYaxisY = vy + vh;
    }

    @Override
    public int getLevel() {
        return 10;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        double scale = sceneContext.getScale();
        double vx = sceneContext.getSwingXDip(this.mViewX);
        double vy = sceneContext.getSwingYDip(this.mViewY);
        Graphics2D g2 = (Graphics2D)g.create();
        this.at.setToIdentity();
        this.at.translate(vx, vy);
        this.at.scale(scale, scale);
        g2.setFont(g2.getFont().deriveFont(12.0f / (float)scale));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float lineWidth = 2.0f / (float)scale;
        g2.transform(this.at);
        if ((double)Math.abs(ourShadowStroke.getLineWidth() - lineWidth) > 0.01) {
            ourShadowStroke = new BasicStroke(lineWidth);
            ourBasicStroke = new BasicStroke(lineWidth / 2.0f);
        }
        g2.setStroke(ourShadowStroke);
        g2.setColor(Color.BLACK);
        g2.draw(this.ourPath);
        g2.setColor(myGridColor);
        g2.setStroke(ourMajorLines);
        g2.draw(this.mGridMajor);
        g2.setColor(myAxisColor);
        g2.setStroke(ourAxis);
        g2.draw(this.mGridAxis);
        if (!Float.isNaN(this.drawXaxisX)) {
            g2.drawString("x", this.drawXaxisX, this.drawXaxisY);
            g2.drawString("y", this.drawYaxisX, this.drawYaxisY);
        }
        g2.setStroke(ourBasicStroke);
        g2.setColor(this.myLineColor);
        g2.draw(this.ourPath);
        int diamond = (int)(1.0 + 5.0 / scale);
        if (this.mKeyFramesPos != null && this.mSelected) {
            for (int i2 = 0; i2 < this.mKeyFramesPos.length; i2 += 2) {
                int type = this.mKeyFramesType[i2 / 2];
                if (type / 1000 != 2) continue;
                int posx = (int)this.mKeyFramesPos[i2];
                int posy = (int)this.mKeyFramesPos[i2 + 1];
                this.xpath[0] = posx;
                this.xpath[1] = posx + diamond + 1;
                this.xpath[2] = posx;
                this.xpath[3] = posx - diamond - 1;
                this.ypath[0] = posy - diamond - 1;
                this.ypath[1] = posy;
                this.ypath[2] = posy + diamond + 1;
                this.ypath[3] = posy;
                int stringOffset = 10;
                g2.setColor(Color.BLACK);
                g2.fillPolygon(this.xpath, this.ypath, 4);
                if (this.mSelectedKey == i2 / 2 && this.mPercent.length() > 0) {
                    FontMetrics fm = g2.getFontMetrics();
                    Rectangle2D bounds2 = fm.getStringBounds(this.mPercent, g2);
                    g2.setColor(myPointLabelShadow);
                    int border = 4;
                    g2.fillRect(stringOffset + posx - border / 2, posy - fm.getAscent() - border / 2, (int)bounds2.getWidth() + border * 2, (int)bounds2.getHeight() + border * 2);
                    g2.setColor(myPointLabelBackground);
                    border = 6;
                    g2.fillRect(stringOffset + posx - border, posy - fm.getAscent() - border, (int)bounds2.getWidth() + border * 2, (int)bounds2.getHeight() + border * 2);
                }
                this.xpath[1] = this.xpath[1] - 1;
                this.ypath[2] = this.ypath[2] - 1;
                this.xpath[3] = this.xpath[3] + 1;
                this.ypath[0] = this.ypath[0] + 1;
                if (this.mSelectedKey == i2 / 2) {
                    g2.setColor(myPointLabelText);
                    g2.drawString(this.mPercent, 10 + posx, posy);
                    g2.setColor(Color.BLUE);
                } else {
                    g2.setColor(Color.WHITE);
                }
                g2.fillPolygon(this.xpath, this.ypath, 4);
            }
        }
    }

    @Override
    public String serialize() {
        return null;
    }

    public static void buildDisplayList(boolean selected, DisplayList list, int selected_key, int key_pos_type, float[] path2, int pathSize, int[] keyFrameType, float[] keyFramePos, int keyFrameSize, float x, float y, float w, float h, float cbx, float cby, float cbw, float cbh, float percentX, float percentY) {
        list.add(new DrawMotionPath(selected, selected_key, key_pos_type, path2, pathSize, keyFrameType, keyFramePos, keyFrameSize, x, y, w, h, cbx, cby, cbw, cbh, percentX, percentY));
    }
}

