/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttrResourceValueImpl;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.actions.ChainStyleViewActions;
import com.android.tools.idea.uibuilder.actions.ToggleAllLiveRenderingAction;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleAutoConnectAction;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.api.actions.ViewActionUtils;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginPopup;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BaseLineToggleViewAction;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonActions {
    private static final String PREFERENCE_KEY_PREFIX = "ConstraintLayoutPreference";
    public static final String SHOW_CONSTRAINTS_PREF_KEY = "ConstraintLayoutPreferenceShowAllConstraints";
    public static final String SHOW_MARGINS_PREF_KEY = "ConstraintLayoutPreferenceShowMargins";
    public static final String FADE_UNSELECTED_VIEWS = "ConstraintLayoutPreferenceFadeUnselected";
    private static final String ADD_VERTICAL_BARRIER = "Add Vertical Barrier";
    private static final String ADD_HORIZONTAL_BARRIER = "Add Horizontal Barrier";
    private static final String ADD_TO_BARRIER = "Add to Barrier";
    private static final String ADD_LAYER = "Add Layer";
    private static final String ADD_GROUP = "Add Group";
    private static final String ADD_CONSTRAINTS_SET = "Add Set of Constraints";
    private static HashMap<String, Boolean> ourVisibilityFlags = new HashMap();

    public static boolean getPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions2) {
        actions2.add(new BaseLineToggleViewAction());
        actions2.add(new DisappearingActionMenu("Constrain", StudioIcons.LayoutEditor.Toolbar.CREATE_CONSTRAINTS, (List)ConstraintViewActions.CONNECT_ACTIONS));
        actions2.add(new DisappearingActionMenu("Organize", StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, (List)ConstraintViewActions.ORGANIZE_ACTIONS));
        actions2.add(new DisappearingActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, (List)ConstraintViewActions.ALIGN_ACTIONS));
        actions2.add(new DisappearingActionMenu("Chains", StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, (List)ConstraintViewActions.CHAIN_ACTIONS));
        actions2.add(new DisappearingActionMenu("Center", StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, (List)ConstraintViewActions.CENTER_ACTIONS));
        actions2.add(new DisappearingActionMenu("Helpers", StudioIcons.LayoutEditor.Toolbar.GUIDELINE_VERTICAL, (List)ConstraintViewActions.HELPER_ACTIONS));
        return true;
    }

    public static void getToolbarActions(@NotNull List<ViewAction> actions2) {
        actions2.add(ViewActionUtils.getViewOptionsAction((List<? extends ViewAction>)ImmutableList.of((Object)new ToggleVisibilityAction(SHOW_CONSTRAINTS_PREF_KEY, "Show All Constraints", false), (Object)new ToggleVisibilityAction(SHOW_MARGINS_PREF_KEY, "Show Margins", true), (Object)new ToggleVisibilityAction(FADE_UNSELECTED_VIEWS, "Fade Unselected Views ", false), (Object)new ToggleAllLiveRenderingAction())));
        actions2.add(new MarginSelector());
        actions2.add(new ViewActionSeparator());
        actions2.add(new NestedViewActionMenu("Pack", StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, (List)Lists.newArrayList((Object[])new List[]{Arrays.asList(new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically"), new ViewActionSeparator(), new AlignAction(Scout.Arrange.DistributeHorizontally, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_HORIZONTAL, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_HORIZONTAL_CONSTRAINT, "Distribute Horizontally"), new AlignAction(Scout.Arrange.DistributeVertically, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_VERTICAL, StudioIcons.LayoutEditor.Toolbar.DISTRIBUTE_VERTICAL_CONSTRAINT, "Distribute Vertically"))})){

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
                super.updatePresentation(presentation, editor2, handler2, component, selectedChildren, modifiersEx);
                presentation.setVisible(CommonActions.isConstraintLayoutChild(selectedChildren));
            }
        });
        actions2.add(new NestedViewActionMenu("Align", StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED_CONSTRAINT, (List)Lists.newArrayList((Object[])new List[]{Stream.of(ConstraintViewActions.ALIGN_HORIZONTALLY_ACTIONS, ConstraintViewActions.ALIGN_VERTICALLY_ACTIONS, ImmutableList.of((Object)new ViewActionSeparator()), ConstraintViewActions.CENTER_ACTIONS).flatMap(list -> list.stream()).collect(Collectors.toList())})){

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
                super.updatePresentation(presentation, editor2, handler2, component, selectedChildren, modifiersEx);
                presentation.setVisible(CommonActions.isConstraintLayoutChild(selectedChildren));
            }
        });
        actions2.add(new NestedViewActionMenu("Guidelines", StudioIcons.LayoutEditor.Toolbar.GUIDELINE_VERTICAL, Lists.newArrayList((Object[])new List[]{ConstraintViewActions.HELPER_ACTIONS})));
        ViewActionSeparator.setupFollowingActions(actions2);
    }

    private static void ensureLayersAreShown(@NotNull ViewEditor editor2, int duration2) {
        NlDesignSurface designSurface = (NlDesignSurface)editor2.getScene().getDesignSurface();
        designSurface.forceLayersPaint(true);
        designSurface.repaint();
        Timer timer2 = new Timer(duration2, actionEvent -> designSurface.forceLayersPaint(false));
        timer2.setRepeats(false);
        timer2.start();
    }

    private static boolean isConstraintLayoutChild(List<NlComponent> children) {
        for (NlComponent child : children) {
            NlComponent parent = child.getParent();
            if (parent == null || !NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static NlAnalyticsManager getAnalyticsManager(@NotNull ViewEditor editor2) {
        return ((NlDesignSurface)editor2.getScene().getDesignSurface()).getAnalyticsManager();
    }

    private static class ClearConstraintsAction
    extends DirectViewAction {
        private static final String MESSAGE_DELETE_CONSTRAINT = "Delete all the constraints in the current layout?";

        private ClearConstraintsAction() {
            super(StudioIcons.LayoutEditor.Toolbar.CLEAR_CONSTRAINTS, "Clear All Constraints");
        }

        @Override
        @Nullable
        public String getConfirmationMessage() {
            return MESSAGE_DELETE_CONSTRAINT;
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            CommonActions.getAnalyticsManager(editor2).trackClearAllConstraints();
            ViewGroupHandler constraintHandler = (ViewGroupHandler)handler2;
            constraintHandler.clearAttributes(component.getChildren());
            editor2.getScene().select(Collections.emptyList());
            CommonActions.ensureLayersAreShown(editor2, 1000);
        }
    }

    static class ControlIcon
    implements Icon {
        public static final Color HIGHLIGHT_COLOR = new Color(240116);
        Icon myIcon;
        boolean myHighlight;

        ControlIcon(Icon icon2) {
            this.myIcon = icon2;
        }

        public void setHighlight(boolean mHighlight) {
            this.myHighlight = mHighlight;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.myIcon.paintIcon(c, g, x, y);
            if (this.myHighlight) {
                g.setColor(HIGHLIGHT_COLOR);
                g.fillRect(x, y + this.getIconHeight() - 2, this.getIconWidth(), 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }

    private static class MarginSelector
    extends DirectViewAction {
        private static final String PICK_A_DIMENSION = "Pick a Dimension";
        private static final float DEFAULT_ICON_FONT_SIZE = 12.0f;
        private static final int DEFAULT_ICON_WIDTH = 36;
        private static final int DEFAULT_ICON_HEIGHT = 16;
        private final ActionListener myResourcePickerIconClickListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (myComponent == null) {
                    return;
                }
                EnumSet<ResourceType> types2 = EnumSet.of(ResourceType.DIMEN);
                XmlTag tag = myComponent.getBackend().getTag();
                ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog(MarginSelector.PICK_A_DIMENSION, String.valueOf(Scout.getMargin()), myComponent.getModel().getFacet(), types2, ResourceType.DIMEN, true, false, true, tag != null ? tag.getContainingFile().getVirtualFile() : null);
                if (myMarginPopup != null) {
                    myMarginPopup.cancel();
                }
                if (dialog2.showAndGet()) {
                    this.resolveResValue(dialog2.getResourceName());
                }
            }

            private void resolveResValue(String resourceRef) {
                ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(myComponent.getModel().getFacet());
                XmlTag tag = myComponent.getBackend().getTag();
                assert (tag != null);
                ResourceResolver resolver = configurationManager.getConfiguration(tag.getContainingFile().getVirtualFile()).getResourceResolver();
                AttrResourceValueImpl unresolved = new AttrResourceValueImpl(ResourceNamespace.RES_AUTO, "dimens", null);
                unresolved.setValue(resourceRef);
                ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)unresolved);
                String marginDp = MarginSelector.getMarginInDp(resolvedValue);
                if (marginDp == null) {
                    Messages.showWarningDialog((String)("\"" + resourceRef + "' cannot be used for default margin. Please choose a resource with \"dp\" type instead."), (String)"Warning");
                    this.setMargin(null, 0);
                    return;
                }
                try {
                    int marginInInt = Integer.parseInt(marginDp);
                    this.setMargin(resourceRef, marginInInt);
                }
                catch (NumberFormatException nfe) {
                    Messages.showWarningDialog((String)("\"" + resourceRef + "' is not a valid dimension. Please choose a resource with correct dimension value instead."), (String)"Warning");
                    this.setMargin(null, 0);
                    Logger.getInstance(MarginPopup.class).warn("Was unable to resolve the resValue from ResourceDialog.");
                }
            }

            private void setMargin(@Nullable String resName, int value2) {
                myMarginPopup = this.createIfNeeded();
                myMarginPopup.getMargin().setValue(value2, resName);
                myMarginPopup.updateText();
                this.updateIcon();
            }
        };
        private MarginPopup myMarginPopup;
        private LookAndFeel myLookAndFeel;
        private String myPreviousDisplay;
        private Icon myMarginIcon;
        @Nullable
        private NlComponent myComponent;
        @Nullable
        private ActionButton myActionButton;

        @Nullable
        private static String getMarginInDp(ResourceValue resourceValue2) {
            if (resourceValue2 == null) {
                return null;
            }
            String value2 = resourceValue2.getValue();
            if (value2 == null) {
                return null;
            }
            String toReturn = null;
            if (value2.endsWith("dp") || value2.endsWith("px") || value2.endsWith("pt") || value2.endsWith("in") || value2.endsWith("mm") || value2.endsWith("sp")) {
                toReturn = value2.substring(0, value2.length() - 2);
            } else if (value2.endsWith("dip")) {
                toReturn = value2.substring(0, value2.length() - 3);
            }
            return toReturn;
        }

        private MarginSelector() {
            super(null, "Default Margins");
        }

        private void updateIcon() {
            this.myMarginPopup = this.createIfNeeded();
            String previousDisplay = this.myMarginPopup.getMargin().getDisplayValue();
            if (!previousDisplay.equals(this.myPreviousDisplay)) {
                this.myPreviousDisplay = previousDisplay;
                this.myMarginIcon = new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        g.setColor(JBColor.foreground());
                        g.setFont(g.getFont().deriveFont(0, JBUI.scaleFontSize((float)12.0f)));
                        String m = myPreviousDisplay;
                        FontMetrics metrics = g.getFontMetrics();
                        int strWidth = metrics.stringWidth(m);
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        int stringY = (this.getIconHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                        g.drawString(m, x + (this.getIconWidth() - strWidth) / 2, y + stringY - 1);
                        g.setColor(JBColor.foreground().darker());
                        int marginRight = 6;
                        g.drawLine(x + 1, y + this.getIconHeight() - 1, x + this.getIconWidth() - 1, y + this.getIconHeight() - 1);
                        g.drawLine(x + 1, y + this.getIconHeight(), x + 1, y + this.getIconHeight() - marginRight);
                        g.drawLine(x + this.getIconWidth() - 1, y + this.getIconHeight(), x + this.getIconWidth() - 1, y + this.getIconHeight() - marginRight);
                    }

                    @Override
                    public int getIconWidth() {
                        return JBUI.scale((int)36);
                    }

                    @Override
                    public int getIconHeight() {
                        return JBUI.scale((int)16);
                    }
                };
            }
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            this.myComponent = component;
            this.myMarginPopup = this.createIfNeeded();
            DesignSurface surface2 = editor2.getScene().getDesignSurface();
            CommonActions.getAnalyticsManager(editor2).trackDefaultMargins();
            RelativePoint relativePoint = new RelativePoint((Component)((Object)surface2), new Point(0, 0));
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myMarginPopup, this.myMarginPopup.getTextField()).setRequestFocus(true).setCancelOnMouseOutCallback(event -> !this.withinComponent(event)).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelCallback(() -> {
                this.myMarginPopup.cancel();
                return Boolean.TRUE;
            }).createPopup();
            this.myMarginPopup.setPopup(popup2);
            Disposer.register((Disposable)popup2, this::popupClosed);
            popup2.show(relativePoint);
        }

        @NotNull
        private MarginPopup createIfNeeded() {
            if (this.myMarginPopup != null && UIManager.getLookAndFeel() == this.myLookAndFeel) {
                return this.myMarginPopup;
            }
            if (this.myMarginPopup != null) {
                this.myMarginPopup.removeResourcePickerActionListener(this.myResourcePickerIconClickListener);
                this.myMarginPopup.setActionListener(null);
            }
            this.myMarginPopup = new MarginPopup();
            this.myLookAndFeel = UIManager.getLookAndFeel();
            this.myMarginPopup.setActionListener(e -> Scout.setMargin(this.myMarginPopup.getMargin().getValue()));
            this.myMarginPopup.addResourcePickerActionListener(this.myResourcePickerIconClickListener);
            return this.myMarginPopup;
        }

        private void popupClosed() {
            if (this.myMarginPopup != null) {
                this.myMarginPopup.setPopup(null);
            }
            this.myActionButton = null;
        }

        public boolean withinComponent(@NotNull MouseEvent event) {
            if (this.myMarginPopup == null || !this.myMarginPopup.isShowing()) {
                return false;
            }
            Point eventLocation = event.getLocationOnScreen();
            Rectangle popupScreenBounds = new Rectangle(this.myMarginPopup.getLocationOnScreen(), this.myMarginPopup.getSize());
            if (popupScreenBounds.contains(eventLocation)) {
                return true;
            }
            if (this.myActionButton == null) {
                this.myActionButton = this.checkIfMouseEventCameFromOurActionButton(event.getSource());
                if (this.myActionButton == null) {
                    return false;
                }
            }
            Rectangle buttonScreenBounds = new Rectangle(this.myActionButton.getLocationOnScreen(), this.myActionButton.getSize());
            int extendedHeight = popupScreenBounds.y + popupScreenBounds.height - buttonScreenBounds.y;
            buttonScreenBounds.height = Math.max(buttonScreenBounds.height, extendedHeight);
            return buttonScreenBounds.contains(eventLocation);
        }

        @Nullable
        private ActionButton checkIfMouseEventCameFromOurActionButton(@Nullable Object source) {
            if (!(source instanceof ActionButton)) {
                return null;
            }
            ActionButton button2 = (ActionButton)source;
            Presentation presentation = button2.getAction().getTemplatePresentation();
            return this.getLabel().equals(presentation.getText()) && Objects.equals(this.getIcon(), presentation.getIcon()) ? button2 : null;
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            this.updateIcon();
            if (this.myMarginIcon instanceof ControlIcon) {
                ((ControlIcon)this.myMarginIcon).setHighlight(ToggleAutoConnectAction.isAutoconnectOn() || (2 & modifiersEx) == 0);
            }
            presentation.setIcon(this.myMarginIcon);
        }
    }

    private static class AddElementAction
    extends DirectViewAction {
        public static final int HORIZONTAL_GUIDELINE = 0;
        public static final int VERTICAL_GUIDELINE = 1;
        public static final int HORIZONTAL_BARRIER = 2;
        public static final int VERTICAL_BARRIER = 3;
        public static final int GROUP = 4;
        public static final int CONSTRAINT_SET = 5;
        public static final int LAYER = 6;
        final int myType;

        private AddElementAction(int type, Icon icon2, String text2) {
            super(icon2, text2);
            this.myType = type;
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            NlComponent parent;
            for (parent = component; parent != null && !NlComponentHelperKt.isOrHasSuperclass(parent, SdkConstants.CONSTRAINT_LAYOUT); parent = parent.getParent()) {
            }
            if (parent != null) {
                boolean useAndroidx = NlComponentHelperKt.isOrHasAndroidxSuperclass(parent);
                CommonActions.ensureLayersAreShown(editor2, 1000);
                switch (this.myType) {
                    case 0: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.newName() : SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.oldName(), null, InsertType.CREATE);
                        assert (guideline != null);
                        guideline.ensureId();
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        CommonActions.getAnalyticsManager(editor2).trackAddHorizontalGuideline();
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "horizontal");
                        break;
                    }
                    case 1: {
                        NlComponent guideline = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.newName() : SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.oldName(), null, InsertType.CREATE);
                        assert (guideline != null);
                        guideline.ensureId();
                        guideline.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", "20dp");
                        CommonActions.getAnalyticsManager(editor2).trackAddVerticalGuideline();
                        guideline.setAttribute("http://schemas.android.com/apk/res/android", "orientation", "vertical");
                        break;
                    }
                    case 4: {
                        NlComponent group2 = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.oldName(), null, InsertType.CREATE);
                        assert (group2 != null);
                        group2.ensureId();
                        break;
                    }
                    case 5: {
                        NlComponent constraints = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS.oldName(), null, InsertType.CREATE);
                        assert (constraints != null);
                        constraints.ensureId();
                        break;
                    }
                    case 6: {
                        NlComponent layer = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.newName() : SdkConstants.CLASS_CONSTRAINT_LAYOUT_LAYER.oldName(), null, InsertType.CREATE);
                        assert (layer != null);
                        layer.ensureId();
                        break;
                    }
                    case 2: {
                        NlComponent barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (!NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) continue;
                                barrier = child;
                                break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_BARRIER.newName() : SdkConstants.CONSTRAINT_LAYOUT_BARRIER.oldName(), null, InsertType.CREATE);
                        assert (barrier != null);
                        barrier.ensureId();
                        barrier.setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "top");
                        break;
                    }
                    case 3: {
                        Object barrier;
                        int barriers = 0;
                        int other = 0;
                        for (NlComponent nlComponent : selectedChildren) {
                            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                                ++barriers;
                            }
                            if (ConstraintComponentUtilities.isLine(nlComponent)) continue;
                            ++other;
                        }
                        if (barriers == 1 && other > 0) {
                            barrier = null;
                            for (NlComponent child : selectedChildren) {
                                if (!NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) continue;
                                barrier = child;
                                break;
                            }
                            return;
                        }
                        barrier = NlComponentHelperKt.createChild(parent, editor2, useAndroidx ? SdkConstants.CONSTRAINT_LAYOUT_BARRIER.newName() : SdkConstants.CONSTRAINT_LAYOUT_BARRIER.oldName(), null, InsertType.CREATE);
                        assert (barrier != null);
                        ((NlComponent)barrier).ensureId();
                        ((NlComponent)barrier).setAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection", "left");
                    }
                }
            }
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            boolean show = true;
            if ((this.myType == 3 || this.myType == 2) && (show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 0))) {
                int barriers = 0;
                int other = 0;
                for (NlComponent child : selectedChildren) {
                    if (NlComponentHelperKt.isOrHasSuperclass(child, SdkConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                        ++barriers;
                    }
                    if (ConstraintComponentUtilities.isLine(child)) continue;
                    ++other;
                }
                if (barriers == 1 && other > 0) {
                    presentation.setLabel(CommonActions.ADD_TO_BARRIER);
                } else {
                    presentation.setLabel(this.myType == 3 ? CommonActions.ADD_VERTICAL_BARRIER : CommonActions.ADD_HORIZONTAL_BARRIER);
                }
            }
            if (this.myType == 4) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 0);
            }
            if (this.myType == 5) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 9);
            }
            if (this.myType == 6) {
                show = ConstraintComponentUtilities.isConstraintModelGreaterThan(editor2, 1, 9);
            }
            presentation.setVisible(show);
            presentation.setEnabled(true);
        }
    }

    static interface EnabledAction {
        public boolean isEnabled(List<NlComponent> var1);
    }

    private static class DisappearingActionMenu
    extends ViewActionMenu
    implements EnabledAction {
        private DisappearingActionMenu(@NotNull String menuName, @Nullable Icon icon2, @NotNull List<ViewAction> actions2) {
            super(menuName, icon2, actions2);
        }

        @Override
        public boolean isEnabled(List<NlComponent> selected) {
            for (ViewAction action2 : this.myActions) {
                if (action2 instanceof EnabledAction) {
                    if (!((EnabledAction)((Object)action2)).isEnabled(selected)) continue;
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    private static class ConstraintViewActions {
        private static final ImmutableList<ViewAction> ALIGN_HORIZONTALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignHorizontallyLeft, StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED, StudioIcons.LayoutEditor.Toolbar.LEFT_ALIGNED_CONSTRAINT, "Left Edges"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyCenter, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_CENTER_ALIGNED, StudioIcons.LayoutEditor.Toolbar.HORIZONTAL_CENTER_ALIGNED_CONSTRAINT, "Horizontal Centers"), (Object)new AlignAction(Scout.Arrange.AlignHorizontallyRight, StudioIcons.LayoutEditor.Toolbar.RIGHT_ALIGNED, StudioIcons.LayoutEditor.Toolbar.RIGHT_ALIGNED_CONSTRAINT, "Right Edges"));
        private static final ImmutableList<ViewAction> ALIGN_VERTICALLY_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.AlignVerticallyTop, StudioIcons.LayoutEditor.Toolbar.TOP_ALIGNED, StudioIcons.LayoutEditor.Toolbar.TOP_ALIGNED_CONSTRAINT, "Top Edges"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyMiddle, StudioIcons.LayoutEditor.Toolbar.VERTICAL_CENTER_ALIGNED, StudioIcons.LayoutEditor.Toolbar.VERTICAL_CENTER_ALIGNED_CONSTRAINT, "Vertical Centers"), (Object)new AlignAction(Scout.Arrange.AlignVerticallyBottom, StudioIcons.LayoutEditor.Toolbar.BOTTOM_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BOTTOM_ALIGNED_CONSTRAINT, "Bottom Edges"), (Object)new AlignAction(Scout.Arrange.AlignBaseline, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT, "Baselines"));
        public static final ImmutableList<ViewAction> ALIGN_ACTIONS = ImmutableList.builder().addAll(ALIGN_HORIZONTALLY_ACTIONS).addAll(ALIGN_VERTICALLY_ACTIONS).build();
        public static final ImmutableList<ViewAction> CHAIN_ACTIONS = ImmutableList.of((Object)new DisappearingActionMenu("Horizontal Chain Style", StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_SPREAD_INLINE, ChainStyleViewActions.HORIZONTAL_CHAIN_STYLES), (Object)new DisappearingActionMenu("Vertical Chain Style", StudioIcons.LayoutEditor.Toolbar.CYCLE_CHAIN_SPREAD_INLINE, ChainStyleViewActions.VERTICAL_CHAIN_STYLES), (Object)new AlignAction(Scout.Arrange.CreateHorizontalChain, StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.CREATE_HORIZ_CHAIN, "Create Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.CreateVerticalChain, StudioIcons.LayoutEditor.Toolbar.CREATE_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.CREATE_VERT_CHAIN, "Create Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertHorizontal, StudioIcons.LayoutEditor.Toolbar.INSERT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.INSERT_HORIZ_CHAIN, "Insert in Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainInsertVertical, StudioIcons.LayoutEditor.Toolbar.INSERT_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.INSERT_VERT_CHAIN, "Insert in Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalRemove, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_VERT_CHAIN, "Remove from Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalRemove, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.REMOVE_FROM_HORIZ_CHAIN, "Remove from Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveUp, StudioIcons.LayoutEditor.Toolbar.MOVE_UP_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_UP_VERT_CHAIN, "Move Up Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainVerticalMoveDown, StudioIcons.LayoutEditor.Toolbar.MOVE_DOWN_VERT_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_DOWN_VERT_CHAIN, "Move Down Vertical Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveLeft, StudioIcons.LayoutEditor.Toolbar.MOVE_LEFT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_LEFT_HORIZ_CHAIN, "Move Left Horizontal Chain"), (Object)new AlignAction(Scout.Arrange.ChainHorizontalMoveRight, StudioIcons.LayoutEditor.Toolbar.MOVE_RIGHT_HORIZ_CHAIN, StudioIcons.LayoutEditor.Toolbar.MOVE_RIGHT_HORIZ_CHAIN, "Move Right Horizontal Chain"), (Object[])new ViewAction[0]);
        private static final ImmutableList<ViewAction> CENTER_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.CenterHorizontally, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_CONSTRAINT, "Horizontally"), (Object)new AlignAction(Scout.Arrange.CenterVertically, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_CONSTRAINT, "Vertically"), (Object)new AlignAction(Scout.Arrange.CenterHorizontallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_PARENT, StudioIcons.LayoutEditor.Toolbar.CENTER_HORIZONTAL_PARENT_CONSTRAINT, "Horizontally in Parent"), (Object)new AlignAction(Scout.Arrange.CenterVerticallyInParent, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_PARENT, StudioIcons.LayoutEditor.Toolbar.CENTER_VERTICAL_PARENT_CONSTRAINT, "Vertically in Parent"));
        public static final ImmutableList<ViewAction> CONNECT_ACTIONS = ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectToParentTop, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_TOP, "parent top"), (Object)new ConnectAction(Scout.Connect.ConnectToParentBottom, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_BOTTOM, "parent bottom"), (Object)new ConnectAction(Scout.Connect.ConnectToParentStart, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_START, "parent start"), (Object)new ConnectAction(Scout.Connect.ConnectToParentEnd, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_END, "parent end"), (Object)new ConnectSource(0, null, (List)ConstraintViewActions.connectFrom(false)), (Object)new ConnectSource(1, null, (List)ConstraintViewActions.connectFrom(true)));
        private static final ImmutableList<ViewAction> ORGANIZE_ACTIONS = ImmutableList.of((Object)new AlignAction(Scout.Arrange.HorizontalPack, StudioIcons.LayoutEditor.Toolbar.PACK_HORIZONTAL, "Pack Horizontally"), (Object)new AlignAction(Scout.Arrange.VerticalPack, StudioIcons.LayoutEditor.Toolbar.PACK_VERTICAL, "Pack Vertically"), (Object)new AlignAction(Scout.Arrange.ExpandHorizontally, StudioIcons.LayoutEditor.Toolbar.EXPAND_HORIZONTAL, "Expand Horizontally"), (Object)new AlignAction(Scout.Arrange.ExpandVertically, StudioIcons.LayoutEditor.Toolbar.EXPAND_VERTICAL, "Expand Vertically"));
        private static final ImmutableList<ViewAction> HELPER_ACTIONS = ImmutableList.of((Object)new AddElementAction(1, StudioIcons.LayoutEditor.Toolbar.GUIDELINE_VERTICAL, "Add Vertical Guideline"), (Object)new AddElementAction(0, StudioIcons.LayoutEditor.Toolbar.GUIDELINE_HORIZONTAL, "Add Horizontal Guideline"), (Object)new AddElementAction(3, StudioIcons.LayoutEditor.Toolbar.BARRIER_VERTICAL, "Add Vertical Barrier"), (Object)new AddElementAction(2, StudioIcons.LayoutEditor.Toolbar.BARRIER_HORIZONTAL, "Add Horizontal Barrier"), (Object)new AddElementAction(4, StudioIcons.LayoutEditor.Toolbar.GROUP, "Add Group"), (Object)new AddElementAction(5, StudioIcons.LayoutEditor.Toolbar.CONSTRAINT_SET, "Add Set of Constraints"), (Object)new AddElementAction(6, StudioIcons.LayoutEditor.Toolbar.LAYER, "Add Layer"));

        private ConstraintViewActions() {
        }

        private static ImmutableList<ViewAction> connectTopVertical(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectTopToTop, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_TOP, "top", reverse), (Object)new ConnectAction(Scout.Connect.ConnectTopToBottom, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_BOTTOM, "bottom", reverse));
        }

        private static ImmutableList<ViewAction> connectStartHorizontal(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectStartToStart, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_START, "start", reverse), (Object)new ConnectAction(Scout.Connect.ConnectStartToEnd, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_END, "end", reverse));
        }

        private static ImmutableList<ViewAction> connectBottomVertical(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectBottomToTop, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_TOP, "top", reverse), (Object)new ConnectAction(Scout.Connect.ConnectBottomToBottom, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_BOTTOM, "bottom", reverse));
        }

        private static ImmutableList<ViewAction> connectEndHorizontal(boolean reverse) {
            return ImmutableList.of((Object)new ConnectAction(Scout.Connect.ConnectEndToStart, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_START, "start", reverse), (Object)new ConnectAction(Scout.Connect.ConnectEndToEnd, StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_END, "end", reverse));
        }

        private static ImmutableList<ViewAction> connectFrom(boolean reverse) {
            return ImmutableList.of((Object)new DisappearingActionMenu("top to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_TOP, (List)ConstraintViewActions.connectTopVertical(reverse)), (Object)new DisappearingActionMenu("bottom to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_BOTTOM, (List)ConstraintViewActions.connectBottomVertical(reverse)), (Object)new DisappearingActionMenu("start to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_START, (List)ConstraintViewActions.connectStartHorizontal(reverse)), (Object)new DisappearingActionMenu("end to", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TO_END, (List)ConstraintViewActions.connectEndHorizontal(reverse)), (Object)new ConnectAction(Scout.Connect.ConnectBaseLineToBaseLine, StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT, "to baseline", reverse));
        }

        private static class ConnectSource
        extends DisappearingActionMenu {
            int mIndex;

            private ConnectSource(int index2, @Nullable Icon icon2, @NotNull List<ViewAction> actions2) {
                super("", icon2, actions2);
                this.mIndex = index2;
            }

            @Override
            public boolean isEnabled(List<NlComponent> selected) {
                if (selected.size() != 2) {
                    return false;
                }
                return super.isEnabled(selected);
            }

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiersEx) {
                String label;
                if (selectedChildren.size() > this.mIndex) {
                    label = selectedChildren.get(this.mIndex).getId();
                    if (label == null) {
                        label = selectedChildren.get(this.mIndex).getTagName();
                    }
                } else {
                    label = this.getLabel();
                }
                presentation.setLabel(label);
                presentation.setVisible(this.isEnabled(selectedChildren));
            }
        }

        private static class ConnectAction
        extends DirectViewAction
        implements EnabledAction {
            private final Scout.Connect myConnectType;
            private final Icon myConnectConstraintIcon;
            private final Icon myConstrainIcon;
            private final String myToolTip;
            private boolean mReverse;
            private boolean mToParent = false;

            ConnectAction(Scout.Connect actionType, Icon connectConstraintIcon, String toolTip, boolean reverse) {
                super(connectConstraintIcon, toolTip);
                this.myConnectType = actionType;
                this.myConnectConstraintIcon = connectConstraintIcon;
                this.myConstrainIcon = null;
                this.myToolTip = toolTip;
                this.mReverse = reverse;
            }

            ConnectAction(Scout.Connect actionType, Icon connectConstraintIcon, String toolTip) {
                super(connectConstraintIcon, toolTip);
                this.myConnectType = actionType;
                this.myConnectConstraintIcon = connectConstraintIcon;
                this.myConstrainIcon = null;
                this.myToolTip = toolTip;
                this.mToParent = true;
            }

            @Override
            public boolean isEnabled(List<NlComponent> selected) {
                int count = selected.size();
                if (count > 2 || count == 0) {
                    return false;
                }
                if (!CommonActions.isConstraintLayoutChild(selected)) {
                    return false;
                }
                return Scout.connectCheck(selected, this.myConnectType, this.mReverse);
            }

            @Override
            public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
                Scout.connect(selectedChildren, this.myConnectType, this.mReverse, true);
                CommonActions.ensureLayersAreShown(editor2, 1000);
                ComponentModification modification = new ComponentModification(component, "Connect Constraint");
                component.startAttributeTransaction().applyToModification(modification);
                modification.commit();
            }

            @Override
            public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
                Icon icon2 = this.myConnectConstraintIcon;
                if (this.myConstrainIcon != null && (ToggleAutoConnectAction.isAutoconnectOn() || (2 & modifiersEx) == 0)) {
                    icon2 = this.myConstrainIcon;
                }
                presentation.setVisible(this.isEnabled(selectedChildren));
                presentation.setEnabled(this.isEnabled(selectedChildren));
                presentation.setIcon(icon2);
                if (this.mToParent) {
                    presentation.setLabel(this.myToolTip);
                } else {
                    String name = selectedChildren.get(this.mReverse ? 0 : 1).getId();
                    if (name == null) {
                        name = "(" + selectedChildren.get(this.mReverse ? 0 : 1).getTagName() + ")";
                    }
                    presentation.setLabel(this.myToolTip + " of " + name);
                }
            }
        }
    }

    private static class AlignAction
    extends DirectViewAction
    implements EnabledAction {
        private final Scout.Arrange myActionType;
        private final Icon myAlignIcon;
        private final Icon myConstrainIcon;
        private final String myToolTip;

        AlignAction(Scout.Arrange actionType, Icon alignIcon, String toolTip) {
            super(alignIcon, toolTip);
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = null;
            this.myToolTip = toolTip;
        }

        AlignAction(Scout.Arrange actionType, Icon alignIcon, Icon constrainIcon, String toolTip) {
            super(alignIcon, toolTip);
            this.myActionType = actionType;
            this.myAlignIcon = alignIcon;
            this.myConstrainIcon = constrainIcon;
            this.myToolTip = toolTip;
        }

        @Override
        public boolean isEnabled(List<NlComponent> selected) {
            int count = selected.size();
            switch (this.myActionType) {
                case AlignVerticallyTop: 
                case AlignVerticallyMiddle: 
                case AlignVerticallyBottom: 
                case AlignHorizontallyLeft: 
                case AlignHorizontallyCenter: 
                case AlignHorizontallyRight: 
                case DistributeVertically: 
                case DistributeHorizontally: 
                case VerticalPack: 
                case HorizontalPack: 
                case AlignBaseline: {
                    return count > 1;
                }
                case CreateHorizontalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case CreateVerticalChain: {
                    return count > 1 && !Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ExpandVertically: 
                case ExpandHorizontally: 
                case CenterHorizontallyInParent: 
                case CenterVerticallyInParent: 
                case CenterVertically: 
                case CenterHorizontally: {
                    return count >= 1;
                }
                case ChainHorizontalMoveLeft: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainVerticalMoveDown: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainVerticalMoveUp: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsTopOfChain);
                }
                case ChainHorizontalMoveRight: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain) && !Scout.chainCheck(selected, Scout.ChainTest.IsBottomOfChain);
                }
                case ChainHorizontalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InHorizontalChain);
                }
                case ChainVerticalRemove: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.InVerticalChain);
                }
                case ChainInsertHorizontal: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearHorizontalChain);
                }
                case ChainInsertVertical: {
                    return count == 1 && Scout.chainCheck(selected, Scout.ChainTest.IsNearVerticalChain);
                }
            }
            return false;
        }

        @Override
        public void perform(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
            CommonActions.getAnalyticsManager(editor2).trackAlign();
            Scout.arrangeWidgetsAndCommit(this.myActionType, selectedChildren, (modifiers &= 2) == 0 || ToggleAutoConnectAction.isAutoconnectOn());
            CommonActions.ensureLayersAreShown(editor2, 1000);
        }

        @Override
        public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiersEx) {
            Icon icon2 = this.myAlignIcon;
            if (this.myConstrainIcon != null && (ToggleAutoConnectAction.isAutoconnectOn() || (2 & modifiersEx) == 0)) {
                icon2 = this.myConstrainIcon;
            }
            presentation.setVisible(this.isEnabled(selectedChildren));
            presentation.setEnabled(this.isEnabled(selectedChildren));
            presentation.setIcon(icon2);
            presentation.setLabel(this.myToolTip);
        }
    }

    private static class ToggleVisibilityAction
    extends ToggleViewAction {
        String mType;

        private ToggleVisibilityAction(String type, String text2, boolean defaultValue2) {
            super(null, LafIconLookup.getIcon((String)"checkmark"), text2, text2);
            this.mType = type;
            ourVisibilityFlags.put(this.mType, PropertiesComponent.getInstance().getBoolean(type, defaultValue2));
        }

        @Override
        public boolean isSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
            return (Boolean)ourVisibilityFlags.get(this.mType);
        }

        @Override
        public void setSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
            ourVisibilityFlags.put(this.mType, selected);
            PropertiesComponent.getInstance().setValue(this.mType, selected);
        }
    }
}

