/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.editor.ActionToolbarUtil;
import com.android.tools.idea.actions.MockupDeleteAction;
import com.android.tools.idea.actions.MockupEditAction;
import com.android.tools.idea.common.actions.GotoComponentAction;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayMenuAction;
import com.android.tools.idea.uibuilder.actions.ConvertToConstraintLayoutAction;
import com.android.tools.idea.uibuilder.actions.DisableToolsVisibilityAndPositionInPreviewAction;
import com.android.tools.idea.uibuilder.actions.MorphComponentAction;
import com.android.tools.idea.uibuilder.actions.SelectAllAction;
import com.android.tools.idea.uibuilder.actions.SelectNextAction;
import com.android.tools.idea.uibuilder.actions.SelectParentAction;
import com.android.tools.idea.uibuilder.actions.SelectPreviousAction;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.DirectViewAction;
import com.android.tools.idea.uibuilder.api.actions.NestedViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewActionGroup;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionMenu;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlActionManager
extends ActionManager<NlDesignSurface> {
    public static final DataKey<NlDesignSurface> LAYOUT_EDITOR = DataKey.create((String)(NlDesignSurface.class.getName() + "_LayoutEditor"));
    private AnAction mySelectAllAction;
    private AnAction mySelectParent;
    private GotoComponentAction myGotoComponentAction;
    private AnAction mySelectNextAction;
    private AnAction mySelectPreviousAction;

    public NlActionManager(@NotNull NlDesignSurface surface2) {
        super(surface2);
    }

    @Override
    public void registerActionsShortcuts(@NotNull JComponent component) {
        if (this.mySelectAllAction == null) {
            this.mySelectAllAction = new SelectAllAction(this.mySurface);
            this.myGotoComponentAction = new GotoComponentAction(this.mySurface);
            this.mySelectParent = new SelectParentAction((NlDesignSurface)this.mySurface);
            this.mySelectNextAction = new SelectNextAction(this.mySurface);
            this.mySelectPreviousAction = new SelectPreviousAction(this.mySurface);
        }
        NlActionManager.registerAction(this.mySelectAllAction, "$SelectAll", component);
        NlActionManager.registerAction((AnAction)this.myGotoComponentAction, "GotoDeclaration", component);
        NlActionManager.registerAction(this.mySelectParent, KeyStroke.getKeyStroke(27, 0), component);
        JComponent focusablePane = ((NlDesignSurface)this.mySurface).getLayeredPane();
        NlActionManager.registerAction(this.mySelectNextAction, KeyStroke.getKeyStroke(39, 0), focusablePane);
        NlActionManager.registerAction(this.mySelectPreviousAction, KeyStroke.getKeyStroke(37, 0), focusablePane);
        NlActionManager.registerAction(this.mySelectNextAction, KeyStroke.getKeyStroke(40, 0), focusablePane);
        NlActionManager.registerAction(this.mySelectPreviousAction, KeyStroke.getKeyStroke(38, 0), focusablePane);
    }

    @NotNull
    private static ActionGroup createRefactoringMenu() {
        DefaultActionGroup group2 = DefaultActionGroup.createPopupGroup(() -> "_Refactor");
        com.intellij.openapi.actionSystem.ActionManager manager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
        AnAction action2 = manager.getAction("AndroidExtractStyleAction");
        group2.add((AnAction)new AndroidRefactoringActionWrapper("_Extract Style...", action2));
        action2 = manager.getAction("AndroidInlineStyleReferenceAction");
        group2.add((AnAction)new AndroidRefactoringActionWrapper("_Inline Style...", action2));
        action2 = manager.getAction("AndroidExtractAsIncludeAction");
        group2.add((AnAction)new AndroidRefactoringActionWrapper("E_xtract Layout...", action2));
        action2 = manager.getAction("AndroidInlineIncludeAction");
        group2.add((AnAction)new AndroidRefactoringActionWrapper("I_nline Layout...", action2));
        return group2;
    }

    @Override
    @NotNull
    public DefaultActionGroup getPopupMenuActions(@Nullable NlComponent leafComponent) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        SceneView screenView = ((NlDesignSurface)this.mySurface).getFocusedSceneView();
        if (screenView != null) {
            if (leafComponent != null) {
                int prevCount = group2.getChildrenCount();
                this.addActions(group2, leafComponent.getParent(), leafComponent, screenView.getSelectionModel().getSelection(), false);
                if (group2.getChildrenCount() > prevCount) {
                    group2.addSeparator();
                }
            }
            group2.addSeparator();
        }
        if (((NlDesignSurface)this.mySurface).getLayoutType() == LayoutFileType.INSTANCE) {
            this.createLayoutOnlyActions(leafComponent, group2);
        }
        group2.add(NlActionManager.getRegisteredActionByName("$Cut"));
        group2.add(NlActionManager.getRegisteredActionByName("$Copy"));
        group2.add(NlActionManager.getRegisteredActionByName("$Paste"));
        group2.addSeparator();
        group2.add(NlActionManager.getRegisteredActionByName("$Delete"));
        group2.addSeparator();
        group2.add((AnAction)this.myGotoComponentAction);
        return group2;
    }

    private void createLayoutOnlyActions(@Nullable NlComponent leafComponent, @NotNull DefaultActionGroup group2) {
        if (leafComponent != null && ((Boolean)StudioFlags.NELE_CONVERT_VIEW.get()).booleanValue()) {
            group2.add((AnAction)new MorphComponentAction(leafComponent));
        }
        group2.add((AnAction)new ConvertToConstraintLayoutAction((NlDesignSurface)this.mySurface));
        group2.add((AnAction)NlActionManager.createRefactoringMenu());
        if (((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue()) {
            group2.add((AnAction)new MockupEditAction((NlDesignSurface)this.mySurface));
        }
        if (leafComponent != null && ((Boolean)StudioFlags.NELE_MOCKUP_EDITOR.get()).booleanValue() && Mockup.hasMockupAttribute(leafComponent)) {
            group2.add((AnAction)new MockupDeleteAction(leafComponent));
        }
        group2.addSeparator();
    }

    @Nullable
    private static NlComponent findSharedParent(@NotNull List<NlComponent> newSelection) {
        NlComponent parent = null;
        for (NlComponent selected : newSelection) {
            if (parent == null) {
                parent = selected.getParent();
                if (newSelection.size() != 1 || !selected.isRoot() || parent != null && !parent.isRoot()) continue;
                return selected;
            }
            if (parent == selected.getParent()) continue;
            parent = null;
            break;
        }
        return parent;
    }

    private void addActions(@NotNull DefaultActionGroup group2, @Nullable NlComponent parent, @Nullable NlComponent leafComponent, @NotNull List<NlComponent> selection, boolean toolbar2) {
        ViewHandler handler2;
        SceneView screenView = ((NlDesignSurface)this.mySurface).getFocusedSceneView();
        if (screenView == null) {
            return;
        }
        Project project = ((NlDesignSurface)this.mySurface).getProject();
        if (project.isDisposed()) {
            return;
        }
        ViewEditorImpl editor2 = new ViewEditorImpl(screenView);
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        if (leafComponent != null && (handler2 = ViewHandlerManager.get(project).getHandler(leafComponent)) != null) {
            actions2.addAll(this.getViewActionsForHandler(leafComponent, selection, editor2, handler2, toolbar2));
        }
        if (parent != null && (handler2 = ViewHandlerManager.get(project).getHandler(parent)) != null) {
            ArrayList selectedChildren = Lists.newArrayListWithCapacity((int)selection.size());
            for (NlComponent selected : selection) {
                if (selected.getParent() != parent) continue;
                selectedChildren.add(selected);
            }
            actions2.addAll(this.getViewActionsForHandler(parent, selectedChildren, editor2, handler2, toolbar2));
        }
        boolean lastWasSeparator = false;
        for (AnAction action2 : actions2) {
            boolean isSeparator = action2 instanceof Separator;
            if (isSeparator && lastWasSeparator) continue;
            group2.add(action2);
            lastWasSeparator = isSeparator;
        }
    }

    @Override
    @NotNull
    public DefaultActionGroup getToolbarActions(@NotNull List<NlComponent> selection) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        NlComponent sharedParent = NlActionManager.findSharedParent(selection);
        this.addActions(group2, sharedParent, null, selection, true);
        return group2;
    }

    @Override
    @Nullable
    public JComponent getSceneViewContextToolbar(@NotNull SceneView sceneView) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)DisableToolsVisibilityAndPositionInPreviewAction.INSTANCE);
        ActionToolbar actionToolbar = com.intellij.openapi.actionSystem.ActionManager.getInstance().createActionToolbar("SceneView", (ActionGroup)group2, true);
        actionToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        return toolbarComponent;
    }

    @Override
    @Nullable
    public JComponent getSceneViewLeftBar(@NotNull SceneView sceneView) {
        if (OverlayConfiguration.EP_NAME.hasAnyExtensions()) {
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add((AnAction)new OverlayMenuAction.ToggleCachedOverlayAction(sceneView.getSurface()));
            group2.add((AnAction)new OverlayMenuAction.UpdateOverlayAction(sceneView.getSurface()));
            group2.add((AnAction)new OverlayMenuAction.CancelOverlayAction(sceneView.getSurface()));
            ActionToolbar actionToolbar = com.intellij.openapi.actionSystem.ActionManager.getInstance().createActionToolbar("SceneView", (ActionGroup)group2, false);
            actionToolbar.setTargetComponent((JComponent)((Object)this.mySurface));
            actionToolbar.setReservePlaceAutoPopupIcon(false);
            JComponent toolbarComponent = actionToolbar.getComponent();
            toolbarComponent.setOpaque(false);
            toolbarComponent.setBorder((Border)JBUI.Borders.empty());
            return toolbarComponent;
        }
        return null;
    }

    @NotNull
    private List<AnAction> getViewActionsForHandler(@NotNull NlComponent component, @NotNull List<NlComponent> newSelection, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, boolean toolbar2) {
        ArrayList<ViewAction> viewActions = new ArrayList<ViewAction>();
        if (toolbar2) {
            viewActions.addAll(ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getToolbarActions(handler2));
        } else {
            SceneComponent sceneComponent = editor2.getScene().getSceneComponent(component);
            if (sceneComponent != null) {
                viewActions.addAll(ViewHandlerManager.get(((NlDesignSurface)this.mySurface).getProject()).getPopupMenuActions(sceneComponent, handler2));
            }
        }
        ArrayList target = Lists.newArrayList();
        for (ViewAction viewAction : viewActions) {
            this.addActions(target, toolbar2, viewAction, editor2, handler2, component, newSelection);
        }
        return target;
    }

    void addActions(@NotNull List<AnAction> target, boolean toolbar2, @NotNull ViewAction viewAction, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> newSelection) {
        if (viewAction instanceof DirectViewAction) {
            target.add(new DirectViewActionWrapper((DirectViewAction)viewAction, editor2, handler2, parent, newSelection));
        } else if (viewAction instanceof ViewActionSeparator) {
            if (((ViewActionSeparator)viewAction).isVisible(editor2, handler2, parent, newSelection)) {
                target.add((AnAction)Separator.getInstance());
            }
        } else if (viewAction instanceof ToggleViewAction) {
            target.add(new ToggleViewActionWrapper((ToggleViewAction)viewAction, editor2, handler2, parent, newSelection));
        } else if (viewAction instanceof ToggleViewActionGroup) {
            ArrayList actions2 = Lists.newArrayList();
            for (ToggleViewAction action2 : ((ToggleViewActionGroup)viewAction).getActions()) {
                actions2.add(new ToggleViewActionWrapper(action2, editor2, handler2, parent, newSelection));
            }
            if (!actions2.isEmpty()) {
                ToggleViewActionWrapper prev = null;
                for (ToggleViewActionWrapper action3 : actions2) {
                    target.add(action3);
                    if (prev != null) {
                        prev.myGroupSibling = action3;
                    }
                    prev = action3;
                }
                if (prev != null) {
                    prev.myGroupSibling = (ToggleViewActionWrapper)actions2.get(0);
                }
            }
        } else if (viewAction instanceof ViewActionMenu) {
            target.add((AnAction)new ViewActionMenuWrapper((ViewActionMenu)viewAction, editor2, handler2, parent, newSelection));
        } else if (viewAction instanceof NestedViewActionMenu) {
            if (toolbar2) {
                target.add((AnAction)new ViewActionToolbarMenuWrapper((NestedViewActionMenu)viewAction, editor2, handler2, parent, newSelection));
            }
        } else {
            throw new UnsupportedOperationException(viewAction.getClass().getName());
        }
    }

    private class ViewActionToolbarMenuWrapper
    extends DropDownAction
    implements ViewActionPresentation {
        private final NestedViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        private ViewActionToolbarMenuWrapper(@NotNull NestedViewActionMenu action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            super(action2.getLabel(), action2.getLabel(), action2.getIcon());
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler2;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action2.getIcon());
            presentation.setDescription(action2.getLabel());
        }

        public void update(@NotNull AnActionEvent e) {
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        protected boolean updateActions(@NotNull DataContext context) {
            this.removeAll();
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                ArrayList actions2 = Lists.newArrayList();
                for (ViewAction viewAction : rows.get(0)) {
                    NlActionManager.this.addActions(actions2, false, viewAction, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                this.addAll(actions2);
            }
            return true;
        }

        protected JPanel createCustomComponentPopup() {
            List<List<ViewAction>> rows = this.myAction.getActions();
            if (rows.size() == 1) {
                return null;
            }
            com.intellij.openapi.actionSystem.ActionManager actionManager = com.intellij.openapi.actionSystem.ActionManager.getInstance();
            JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(0));
            for (List<ViewAction> row : rows) {
                if (row.size() == 1 && row.get(0) instanceof ViewActionSeparator) {
                    if (!((ViewActionSeparator)row.get(0)).isVisible(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren)) continue;
                    panel2.add(new JSeparator());
                    continue;
                }
                ArrayList actions2 = Lists.newArrayList();
                for (ViewAction viewAction : row) {
                    NlActionManager.this.addActions(actions2, false, viewAction, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                }
                DefaultActionGroup group2 = new DefaultActionGroup((List)actions2);
                ActionToolbar toolbar2 = actionManager.createActionToolbar("DynamicToolbar", (ActionGroup)group2, true);
                ActionToolbarUtil.makeToolbarNavigable(toolbar2);
                panel2.add(toolbar2.getComponent());
            }
            return panel2;
        }

        @Override
        public void setLabel(@NotNull String label) {
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }
    }

    private class ViewActionMenuWrapper
    extends ActionGroup
    implements ViewActionPresentation {
        private final ViewActionMenu myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        private ViewActionMenuWrapper(@NotNull ViewActionMenu action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            super(action2.getLabel(), true);
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler2;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action2.getIcon());
            presentation.setText(action2.getLabel());
        }

        public void update(@NotNull AnActionEvent e) {
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList actions2 = Lists.newArrayList();
            for (ViewAction viewAction : this.myAction.getActions()) {
                NlActionManager.this.addActions(actions2, false, viewAction, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
            }
            return actions2.toArray(AnAction.EMPTY_ARRAY);
        }
    }

    private class ToggleViewActionWrapper
    extends AnAction
    implements ViewActionPresentation {
        private final ToggleViewAction myAction;
        private final ViewEditor myEditor;
        private final ViewHandler myHandler;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;
        private ToggleViewActionWrapper myGroupSibling;

        private ToggleViewActionWrapper(@NotNull ToggleViewAction action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler2;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(action2.getUnselectedLabel());
            presentation.setIcon(action2.getUnselectedIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean newState;
            boolean bl = newState = !this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
            if (this.myAction.affectsUndo()) {
                NlWriteCommandActionUtil.run(this.myComponent, Strings.nullToEmpty((String)e.getPresentation().getText()), () -> this.applySelection(newState));
            } else {
                try {
                    this.applySelection(newState);
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
        }

        private void applySelection(boolean state) {
            this.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, state);
            if (state) {
                ToggleViewActionWrapper groupSibling = this.myGroupSibling;
                while (groupSibling != null && groupSibling != this) {
                    groupSibling.myAction.setSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, false);
                    groupSibling = groupSibling.myGroupSibling;
                }
            }
            ((NlDesignSurface)NlActionManager.this.mySurface).repaint();
        }

        public void update(@NotNull AnActionEvent e) {
            this.myCurrentPresentation = e.getPresentation();
            try {
                boolean selected = this.myAction.isSelected(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren);
                if (this.myAction.getSelectedLabel() != null) {
                    this.myCurrentPresentation.setText(selected ? this.myAction.getSelectedLabel() : this.myAction.getUnselectedLabel());
                }
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers(), selected);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }
    }

    private class DirectViewActionWrapper
    extends AnAction
    implements ViewActionPresentation {
        private final DirectViewAction myAction;
        private final ViewHandler myHandler;
        private final ViewEditor myEditor;
        private final NlComponent myComponent;
        private final List<NlComponent> mySelectedChildren;
        private Presentation myCurrentPresentation;

        private DirectViewActionWrapper(@NotNull DirectViewAction action2, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, List<NlComponent> selectedChildren) {
            this.myAction = action2;
            this.myEditor = editor2;
            this.myHandler = handler2;
            this.myComponent = component;
            this.mySelectedChildren = selectedChildren;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(action2.getIcon());
            presentation.setText(action2.getLabel());
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            String confirmationMessage = this.myAction.getConfirmationMessage();
            if (confirmationMessage != null && Messages.showYesNoDialog((Component)((Object)NlActionManager.this.mySurface), (String)confirmationMessage, (String)this.myAction.getLabel(), (Icon)this.myAction.getIcon()) != 0) {
                return;
            }
            if (this.myAction.affectsUndo()) {
                NlWriteCommandActionUtil.run(this.myComponent, Strings.nullToEmpty((String)e.getPresentation().getText()), () -> this.myAction.perform(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers()));
            } else {
                try {
                    this.myAction.perform(this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, e.getModifiers());
                }
                catch (Throwable t) {
                    throw new IncorrectOperationException("View Action required write lock: should not specify affectsUndo=false");
                }
            }
            ((NlDesignSurface)NlActionManager.this.mySurface).repaint();
        }

        public void update(@NotNull AnActionEvent e) {
            int modifiersEx = ((NlDesignSurface)NlActionManager.this.mySurface).getInteractionManager().getLastModifiersEx();
            this.myCurrentPresentation = e.getPresentation();
            try {
                this.myAction.updatePresentation(this, this.myEditor, this.myHandler, this.myComponent, this.mySelectedChildren, modifiersEx);
            }
            finally {
                this.myCurrentPresentation = null;
            }
        }

        @Override
        public void setLabel(@NotNull String label) {
            this.myCurrentPresentation.setText(label);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myCurrentPresentation.setEnabled(enabled);
        }

        @Override
        public void setVisible(boolean visible) {
            this.myCurrentPresentation.setVisible(visible);
        }

        @Override
        public void setIcon(@Nullable Icon icon2) {
            this.myCurrentPresentation.setIcon(icon2);
        }
    }

    private static class AndroidRefactoringActionWrapper
    extends AnAction {
        private final AnAction myRefactoringAction;

        private AndroidRefactoringActionWrapper(@NotNull String text2, @NotNull AnAction refactoringAction) {
            super(text2, null, null);
            this.myRefactoringAction = refactoringAction;
            this.getTemplatePresentation().setDescription(refactoringAction.getTemplatePresentation().getDescription());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myRefactoringAction.actionPerformed(e);
        }

        public void update(@NotNull AnActionEvent e) {
            this.myRefactoringAction.update(e);
            Presentation p = e.getPresentation();
            if (!p.isVisible()) {
                p.setEnabled(false);
                p.setVisible(true);
            }
        }
    }
}

