/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.SetScreenViewProviderAction;
import com.android.tools.idea.common.actions.IssueNotificationAction;
import com.android.tools.idea.common.actions.NextDeviceAction;
import com.android.tools.idea.common.actions.RefreshRenderAction;
import com.android.tools.idea.common.actions.ToggleDeviceNightModeAction;
import com.android.tools.idea.common.actions.ToggleDeviceOrientationAction;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.configurations.NightModeMenuAction;
import com.android.tools.idea.configurations.OrientationMenuAction;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.android.tools.idea.configurations.ThemeMenuAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayMenuAction;
import com.android.tools.idea.uibuilder.actions.SwitchToNextScreenViewProviderAction;
import com.android.tools.idea.uibuilder.surface.LayoutScannerAction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;

public final class DefaultNlToolbarActionGroups
extends ToolbarActionGroups {
    public DefaultNlToolbarActionGroups(@NotNull NlDesignSurface surface2) {
        super(surface2);
    }

    @Override
    @NotNull
    protected ActionGroup getEastGroup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add(ActionManager.getInstance().getAction("LayoutEditor.HelpAssistant"));
        return group2;
    }

    @Override
    @NotNull
    protected ActionGroup getNorthGroup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        if (this.isInVisualizationTool()) {
            return group2;
        }
        DropDownAction designModeAction = this.createDesignModeAction();
        this.appendShortcutText((AnAction)designModeAction, SwitchToNextScreenViewProviderAction.getInstance());
        group2.add((AnAction)designModeAction);
        group2.addSeparator();
        OrientationMenuAction orientationMenuAction = new OrientationMenuAction(this.mySurface::getConfiguration, this.mySurface);
        this.appendShortcutText((AnAction)orientationMenuAction, ToggleDeviceOrientationAction.getInstance());
        group2.add((AnAction)orientationMenuAction);
        if (((Boolean)StudioFlags.NELE_OVERLAY_PROVIDER.get()).booleanValue() && OverlayConfiguration.EP_NAME.hasAnyExtensions()) {
            group2.addSeparator();
            OverlayMenuAction overlayAction = new OverlayMenuAction(this.mySurface);
            group2.add((AnAction)overlayAction);
        }
        group2.addSeparator();
        NightModeMenuAction nightModeAction = new NightModeMenuAction(this.mySurface::getConfiguration);
        this.appendShortcutText((AnAction)nightModeAction, ToggleDeviceNightModeAction.getInstance());
        group2.add((AnAction)nightModeAction);
        group2.addSeparator();
        DeviceMenuAction menuAction = new DeviceMenuAction(this.mySurface::getConfiguration);
        this.appendShortcutText((AnAction)menuAction, NextDeviceAction.getInstance());
        group2.add((AnAction)menuAction);
        group2.add((AnAction)new TargetMenuAction(this.mySurface::getConfiguration));
        group2.add((AnAction)new ThemeMenuAction(this.mySurface::getConfiguration));
        group2.addSeparator();
        group2.add((AnAction)new LocaleMenuAction(this.mySurface::getConfiguration));
        group2.addSeparator();
        return group2;
    }

    private void appendShortcutText(@NotNull AnAction targetAction, @NotNull AnAction action2) {
        String shortcutsText = KeymapUtil.getPreferredShortcutText((Shortcut[])action2.getShortcutSet().getShortcuts());
        Presentation presentation = targetAction.getTemplatePresentation();
        if (!shortcutsText.isEmpty()) {
            presentation.setDescription(String.format("%s (%s)", presentation.getDescription(), shortcutsText));
        }
    }

    @NotNull
    private DropDownAction createDesignModeAction() {
        DropDownAction designSurfaceMenu = new DropDownAction("Select Design Surface", "Select Design Surface", StudioIcons.LayoutEditor.Toolbar.VIEW_MODE);
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.RENDER, (NlDesignSurface)this.mySurface));
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.BLUEPRINT, (NlDesignSurface)this.mySurface));
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.RENDER_AND_BLUEPRINT, (NlDesignSurface)this.mySurface));
        designSurfaceMenu.addSeparator();
        designSurfaceMenu.addAction((AnAction)RefreshRenderAction.getInstance());
        return designSurfaceMenu;
    }

    @Override
    @NotNull
    protected ActionGroup getNorthEastGroup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        if (this.isInVisualizationTool()) {
            return group2;
        }
        group2.add((AnAction)LayoutScannerAction.getInstance());
        group2.add((AnAction)IssueNotificationAction.getInstance());
        return group2;
    }

    private boolean isInVisualizationTool() {
        return (Boolean)StudioFlags.NELE_VISUALIZATION.get() != false && ((NlDesignSurface)this.mySurface).getScreenViewProvider() == NlScreenViewProvider.VISUALIZATION;
    }
}

