/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.ui.DesignSurfaceToolbarUI;
import com.android.tools.idea.uibuilder.editor.AnimationToolbarSliderUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.PanelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationToolbar
extends JPanel
implements Disposable {
    private static final int TICKER_STEP = 33;
    private static final Font BUTTON_FONT = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI);
    @NotNull
    private final AnimationListener myListener;
    private final JButton myPlayButton;
    private final JButton myPauseButton;
    private final JButton myStopButton;
    private final JButton myFrameFwdButton;
    private final JButton myFrameBckButton;
    private final long myTickStepMs;
    private final long myMinTimeMs;
    private final JSlider myFrameControl;
    @Nullable
    private final DefaultBoundedRangeModel myTimeSliderModel;
    private final ChangeListener myTimeSliderChangeModel;
    private long myMaxTimeMs;
    private boolean myLoopEnabled = true;
    private ScheduledFuture<?> myTicker;
    private long myFramePositionMs;
    private long myLastTickMs = 0L;

    private AnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener2, long tickStepMs, long minTimeMs, long initialMaxTimeMs) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myListener = listener2;
        this.myTickStepMs = tickStepMs;
        this.myMinTimeMs = minTimeMs;
        this.myMaxTimeMs = initialMaxTimeMs;
        Box buttonsPanel = Box.createHorizontalBox();
        this.myPlayButton = AnimationToolbar.newControlButton(StudioIcons.LayoutEditor.Motion.PLAY, "Play", this::onPlay);
        this.myPlayButton.setEnabled(true);
        this.myPauseButton = AnimationToolbar.newControlButton(StudioIcons.LayoutEditor.Motion.PAUSE, "Pause", this::onPause);
        this.myPauseButton.setEnabled(true);
        this.myStopButton = AnimationToolbar.newControlButton(StudioIcons.LayoutEditor.Motion.END_CONSTRAINT, "Stop", this::onStop);
        this.myFrameFwdButton = AnimationToolbar.newControlButton(StudioIcons.LayoutEditor.Motion.GO_TO_END, "Step forward", this::onFrameFwd);
        this.myFrameBckButton = AnimationToolbar.newControlButton(StudioIcons.LayoutEditor.Motion.GO_TO_START, "Step backwards", this::onFrameBck);
        JPanel controlBar = new JPanel(new FlowLayout()){

            @Override
            public void updateUI() {
                this.setUI((PanelUI)new DesignSurfaceToolbarUI());
            }
        };
        buttonsPanel.add(this.myStopButton);
        buttonsPanel.add(this.myFrameBckButton);
        buttonsPanel.add(this.myPlayButton);
        buttonsPanel.add(this.myPauseButton);
        buttonsPanel.add(this.myFrameFwdButton);
        controlBar.add(buttonsPanel);
        if (this.isUnlimitedAnimationToolbar()) {
            this.myTimeSliderModel = null;
            this.myTimeSliderChangeModel = null;
        } else {
            this.myTimeSliderModel = new DefaultBoundedRangeModel(0, 0, 0, 100);
            this.myTimeSliderChangeModel = e -> {
                long newPositionMs = (long)((float)(this.myMaxTimeMs - this.myMinTimeMs) * ((float)this.myTimeSliderModel.getValue() / 100.0f));
                this.seek(newPositionMs);
            };
            JSlider timeSlider = new JSlider(0, 100, 0){

                @Override
                public void updateUI() {
                    this.setUI(new AnimationToolbarSliderUI(this));
                    this.updateLabelUIs();
                }
            };
            timeSlider.setOpaque(false);
            timeSlider.setBorder((Border)JBUI.Borders.empty());
            this.myTimeSliderModel.addChangeListener(this.myTimeSliderChangeModel);
            timeSlider.setModel(this.myTimeSliderModel);
            buttonsPanel.add(new JSeparator(1));
            controlBar.add(timeSlider);
        }
        this.myFrameControl = new JSlider(-5, 5, 0);
        this.myFrameControl.setSnapToTicks(true);
        this.add(controlBar);
        this.myFrameControl.addChangeListener(e -> {
            this.stopFrameTicker();
            int value2 = this.myFrameControl.getValue();
            if (value2 == 0) {
                this.stopFrameTicker();
                return;
            }
            long frameChange = this.myTickStepMs * (long)value2;
            this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> this.onTick(frameChange), 0L, 33L, TimeUnit.MILLISECONDS);
        });
        this.myFrameControl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!AnimationToolbar.this.myFrameControl.isEnabled()) {
                    return;
                }
                AnimationToolbar.this.stopFrameTicker();
                AnimationToolbar.this.myFrameControl.setValue(0);
            }
        });
        this.onStop();
    }

    @NotNull
    public static AnimationToolbar createUnlimitedAnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener2, long tickStepMs, long minTimeMs) {
        return new AnimationToolbar(parentDisposable, listener2, tickStepMs, minTimeMs, -1L);
    }

    @NotNull
    public static AnimationToolbar createAnimationToolbar(@NotNull Disposable parentDisposable, @NotNull AnimationListener listener2, long tickStepMs, long minTimeMs, long initialMaxTimeMs) {
        return new AnimationToolbar(parentDisposable, listener2, tickStepMs, minTimeMs, initialMaxTimeMs);
    }

    @NotNull
    private static JButton newControlButton(@NotNull Icon baseIcon, @NotNull String label, @NotNull Runnable callback2) {
        CommonButton button2 = new CommonButton();
        button2.setName(label);
        button2.setIcon(baseIcon);
        button2.addActionListener(e -> callback2.run());
        button2.setMinimumSize((Dimension)JBUI.size((int)22, (int)22));
        button2.setBorderPainted(false);
        button2.setFont(BUTTON_FONT);
        button2.setEnabled(false);
        return button2;
    }

    private void setEnabledState(boolean play, boolean pause, boolean stop2, boolean frame) {
        this.myPlayButton.setVisible(play);
        this.myPauseButton.setVisible(pause);
        this.myStopButton.setEnabled(stop2);
        this.myFrameFwdButton.setEnabled(frame);
        this.myFrameBckButton.setEnabled(frame);
        this.myFrameControl.setEnabled(frame);
    }

    private void onPlay() {
        this.stopFrameTicker();
        this.setEnabledState(false, true, true, false);
        this.myLastTickMs = System.currentTimeMillis();
        this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> {
            long now = System.currentTimeMillis();
            long elapsed = now - this.myLastTickMs;
            this.myLastTickMs = now;
            this.onTick(elapsed);
        }, 0L, 33L, TimeUnit.MILLISECONDS);
    }

    private void onPause() {
        this.setEnabledState(true, false, true, true);
        this.stopFrameTicker();
    }

    private void stopFrameTicker() {
        if (this.myTicker != null) {
            this.myTicker.cancel(false);
            this.myTicker = null;
        }
    }

    private void onStop() {
        this.stopFrameTicker();
        this.setEnabledState(true, false, false, true);
        this.setFramePosition(this.myMinTimeMs, false);
    }

    private void doFrame() {
        this.myListener.animateTo(this.myFramePositionMs);
    }

    private void onFrameFwd() {
        this.onTick(this.myTickStepMs);
    }

    private void onFrameBck() {
        this.onTick(-this.myTickStepMs);
    }

    private void onNewFramePosition(boolean setByUser) {
        if (this.isUnlimitedAnimationToolbar()) {
            return;
        }
        if (this.myFramePositionMs >= this.myMaxTimeMs && !setByUser && !this.myLoopEnabled) {
            this.onPause();
        }
        this.myStopButton.setEnabled(this.myFramePositionMs - this.myTickStepMs >= this.myMinTimeMs);
        this.myFrameFwdButton.setEnabled(this.myFramePositionMs + this.myTickStepMs <= this.myMaxTimeMs);
        this.myFrameBckButton.setEnabled(this.myFramePositionMs - this.myTickStepMs >= this.myMinTimeMs);
        if (this.myTimeSliderModel != null) {
            this.myTimeSliderModel.removeChangeListener(this.myTimeSliderChangeModel);
            this.myTimeSliderModel.setValue((int)((float)(this.myFramePositionMs - this.myMinTimeMs) / (float)(this.myMaxTimeMs - this.myMinTimeMs) * 100.0f));
            this.myTimeSliderModel.addChangeListener(this.myTimeSliderChangeModel);
        }
    }

    private void setFramePosition(long newPositionMs, boolean setByUser) {
        this.myFramePositionMs = newPositionMs;
        if (this.myFramePositionMs < this.myMinTimeMs) {
            this.myFramePositionMs = this.myLoopEnabled ? this.myMaxTimeMs : this.myMinTimeMs;
        } else if (!this.isUnlimitedAnimationToolbar() && this.myFramePositionMs > this.myMaxTimeMs) {
            this.myFramePositionMs = this.myLoopEnabled ? this.myMinTimeMs : this.myMaxTimeMs;
        }
        this.onNewFramePosition(setByUser);
        this.doFrame();
    }

    private void seek(long newPositionMs) {
        this.setFramePosition(this.myMinTimeMs + newPositionMs, true);
    }

    private void onTick(long elapsed) {
        this.setFramePosition(this.myFramePositionMs + elapsed, false);
    }

    public void setMaxtimeMs(long maxTimeMs) {
        assert (this.isUnlimitedAnimationToolbar()) : "Max time can not be set for unlimited animations";
        this.myMaxTimeMs = maxTimeMs;
    }

    public void stop() {
        this.onStop();
    }

    private boolean isUnlimitedAnimationToolbar() {
        return this.myMaxTimeMs == -1L;
    }

    public void dispose() {
        this.stopFrameTicker();
    }

    public static interface AnimationListener {
        public void animateTo(long var1);
    }
}

