/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class WrappedFlowLayout
extends FlowLayout {
    public WrappedFlowLayout() {
    }

    public WrappedFlowLayout(int align) {
        super(align);
    }

    public WrappedFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container target) {
        return this.getWrappedSize(target, Component::getPreferredSize);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container target) {
        return this.getWrappedSize(target, Component::getMinimumSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Dimension getWrappedSize(@NotNull Container target, @NotNull Function<Component, Dimension> sizeGetter) {
        int maxWidth = WrappedFlowLayout.getParentMaxWidth(target);
        Insets insets = target.getInsets();
        int height = insets.top + insets.bottom;
        int width = insets.left + insets.right;
        int rowHeight = 0;
        int rowWidth = insets.left + insets.right;
        boolean isVisible = false;
        boolean start2 = true;
        Object object = target.getTreeLock();
        synchronized (object) {
            for (int i2 = 0; i2 < target.getComponentCount(); ++i2) {
                Component component = target.getComponent(i2);
                if (!component.isVisible()) continue;
                isVisible = true;
                Dimension size = sizeGetter.apply(component);
                if (rowWidth + this.getHgap() + size.width > maxWidth && !start2) {
                    height += this.getVgap() + rowHeight;
                    width = Math.max(width, rowWidth);
                    rowWidth = insets.left + insets.right;
                    rowHeight = 0;
                }
                rowWidth += this.getHgap() + size.width;
                rowHeight = Math.max(rowHeight, size.height);
                start2 = false;
            }
            height += this.getVgap() + rowHeight;
            width = Math.max(width, rowWidth);
            if (!isVisible) {
                return super.preferredLayoutSize(target);
            }
            return new Dimension(width, height);
        }
    }

    private static int getParentMaxWidth(@NotNull Container target) {
        Container parent = SwingUtilities.getUnwrappedParent(target);
        if (parent == null) {
            return 0;
        }
        return parent.getWidth() - (parent.getInsets().left + parent.getInsets().right);
    }
}

