/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.idea.diagnostics.crash.exception.NoPiiException;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.idea.transport.IntellijLogService;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.profiler.proto.Common;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class TransportService
implements Disposable {
    private static final String DATASTORE_NAME = "DataStoreService";
    public static final String CHANNEL_NAME = "DataStoreService";
    @NotNull
    private final LogService myLogService;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final DataStoreService myDataStoreService;
    @NotNull
    private final TransportDeviceManager myDeviceManager;
    @NotNull
    private final AtomicInteger myCustomStreamId = new AtomicInteger();
    @NotNull
    private final Map<Long, EventStreamServer> myStreamIdToServerMap = new HashMap<Long, EventStreamServer>();

    public static TransportService getInstance() {
        return (TransportService)ServiceManager.getService(TransportService.class);
    }

    private static Logger getLogger() {
        return Logger.getInstance(TransportService.class);
    }

    @VisibleForTesting
    TransportService() {
        String datastoreDirectory = Paths.get(PathManager.getSystemPath(), ".android").toString() + File.separator;
        this.myLogService = new IntellijLogService();
        this.myDataStoreService = new DataStoreService("DataStoreService", datastoreDirectory, arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0), this.myLogService);
        this.myDataStoreService.setNoPiiExceptionHandler(t -> TransportService.getLogger().error((Throwable)new NoPiiException((Throwable)t)));
        this.myMessageBus = ApplicationManager.getApplication().getMessageBus();
        this.myDeviceManager = new TransportDeviceManager(this.myDataStoreService, this.myMessageBus, this);
    }

    public void dispose() {
        this.myStreamIdToServerMap.forEach((id, server) -> server.stop());
        this.myStreamIdToServerMap.clear();
        this.myDataStoreService.shutdown();
    }

    @NotNull
    public LogService getLogService() {
        return this.myLogService;
    }

    @NotNull
    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    @NotNull
    public Common.Stream registerStreamServer(Common.Stream.Type streamType, @NotNull EventStreamServer streamServer) {
        Common.Stream stream = Common.Stream.newBuilder().setStreamId((long)this.myCustomStreamId.incrementAndGet()).setType(streamType).build();
        ManagedChannel channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)streamServer.getServerName()).usePlaintext().directExecutor()).build();
        this.myDataStoreService.connect(stream, channel);
        this.myStreamIdToServerMap.put(stream.getStreamId(), streamServer);
        return stream;
    }

    public void unregisterStreamServer(long streamId) {
        if (this.myStreamIdToServerMap.containsKey(streamId)) {
            this.myStreamIdToServerMap.get(streamId).stop();
            this.myDataStoreService.disconnect(streamId);
            this.myStreamIdToServerMap.remove(streamId);
        }
    }
}

