/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.IntellijProjectSizeStats;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/stats/ReportProjectSizeTask;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "fileCount", "", "fileType", "Lcom/android/tools/idea/stats/ReportProjectSizeTask$FileType;", "searchScope", "Lcom/android/tools/idea/stats/ReportProjectSizeTask$SearchScope;", "run", "", "FileType", "SearchScope", "intellij.android.core"})
public final class ReportProjectSizeTask
implements Runnable {
    @NotNull
    private final Project project;

    @Override
    public void run() {
        AndroidStudioEvent.Builder builder2 = UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.INTELLIJ_PROJECT_SIZE_STATS), this.project);
        for (SearchScope searchScope : SearchScope.values()) {
            for (FileType fileType : FileType.values()) {
                int n;
                try {
                    n = this.fileCount(fileType, searchScope);
                }
                catch (Exception e) {
                    n = -1;
                }
                int fileCount2 = n;
                builder2.addIntellijProjectSizeStats(IntellijProjectSizeStats.newBuilder().setScope(searchScope.statsSearchScope()).setType(fileType.statsFileType()).setCount(fileCount2));
            }
        }
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
    }

    private final int fileCount(FileType fileType, SearchScope searchScope) {
        if (fileType.languageFileType() instanceof PlainTextFileType) {
            return 0;
        }
        return ((Number)DumbService.getInstance((Project)this.project).runReadActionInSmartMode((Computable)new Computable<Integer>(this, fileType, searchScope){
            final /* synthetic */ ReportProjectSizeTask this$0;
            final /* synthetic */ FileType $fileType;
            final /* synthetic */ SearchScope $searchScope;

            /*
             * WARNING - void declaration
             */
            public final Integer compute() {
                void numFiles;
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = 0;
                FileTypeIndex.processFiles((com.intellij.openapi.fileTypes.FileType)this.$fileType.languageFileType(), (Processor)((Processor)new Processor<VirtualFile>((Ref.IntRef)numFiles){
                    final /* synthetic */ Ref.IntRef $numFiles;

                    public final boolean process(VirtualFile it) {
                        int n = this.$numFiles.element;
                        this.$numFiles.element = n + 1;
                        return true;
                    }
                    {
                        this.$numFiles = intRef;
                    }
                }), (GlobalSearchScope)this.$searchScope.globalSearchScope(this.this$0.getProject()));
                return numFiles.element;
            }
            {
                this.this$0 = reportProjectSizeTask;
                this.$fileType = fileType;
                this.$searchScope = searchScope;
            }
        })).intValue();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ReportProjectSizeTask(@NotNull Project project) {
        this.project = project;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/stats/ReportProjectSizeTask$FileType;", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "statsFileType", "Lcom/google/wireless/android/sdk/stats/IntellijProjectSizeStats$FileType;", "(Ljava/lang/String;ILcom/intellij/openapi/fileTypes/FileType;Lcom/google/wireless/android/sdk/stats/IntellijProjectSizeStats$FileType;)V", "languageFileType", "JAVA", "XML", "JAVA_CLASS", "KOTLIN", "NATIVE", "intellij.android.core"})
    private static final class FileType
    extends Enum<FileType> {
        public static final /* enum */ FileType JAVA;
        public static final /* enum */ FileType XML;
        public static final /* enum */ FileType JAVA_CLASS;
        public static final /* enum */ FileType KOTLIN;
        public static final /* enum */ FileType NATIVE;
        private static final /* synthetic */ FileType[] $VALUES;
        private final com.intellij.openapi.fileTypes.FileType fileType;
        private final IntellijProjectSizeStats.FileType statsFileType;

        static {
            FileType[] fileTypeArray = new FileType[5];
            FileType[] fileTypeArray2 = fileTypeArray;
            fileTypeArray[0] = JAVA = new FileType((com.intellij.openapi.fileTypes.FileType)JavaFileType.INSTANCE, IntellijProjectSizeStats.FileType.JAVA);
            fileTypeArray[1] = XML = new FileType((com.intellij.openapi.fileTypes.FileType)XmlFileType.INSTANCE, IntellijProjectSizeStats.FileType.XML);
            fileTypeArray[2] = JAVA_CLASS = new FileType((com.intellij.openapi.fileTypes.FileType)JavaClassFileType.INSTANCE, IntellijProjectSizeStats.FileType.DOT_CLASS);
            com.intellij.openapi.fileTypes.FileType fileType = FileTypeRegistry.getInstance().findFileTypeByName("Kotlin");
            if (fileType == null) {
                fileType = (com.intellij.openapi.fileTypes.FileType)PlainTextFileType.INSTANCE;
            }
            fileTypeArray[3] = KOTLIN = new FileType(fileType, IntellijProjectSizeStats.FileType.KOTLIN);
            com.intellij.openapi.fileTypes.FileType fileType2 = FileTypeRegistry.getInstance().findFileTypeByName("ObjectiveC");
            if (fileType2 == null) {
                fileType2 = (com.intellij.openapi.fileTypes.FileType)PlainTextFileType.INSTANCE;
            }
            fileTypeArray[4] = NATIVE = new FileType(fileType2, IntellijProjectSizeStats.FileType.NATIVE);
            $VALUES = fileTypeArray;
        }

        @NotNull
        public final com.intellij.openapi.fileTypes.FileType languageFileType() {
            return this.fileType;
        }

        @NotNull
        public final IntellijProjectSizeStats.FileType statsFileType() {
            return this.statsFileType;
        }

        private FileType(com.intellij.openapi.fileTypes.FileType fileType, IntellijProjectSizeStats.FileType statsFileType) {
            this.fileType = fileType;
            this.statsFileType = statsFileType;
        }

        public static FileType[] values() {
            return (FileType[])$VALUES.clone();
        }

        public static FileType valueOf(String string) {
            return Enum.valueOf(FileType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B2\b\u0002\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\nR)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/stats/ReportProjectSizeTask$SearchScope;", "", "globalSearchScopeFunc", "Lkotlin/Function1;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ParameterName;", "name", "project", "Lcom/intellij/psi/search/GlobalSearchScope;", "statsSearchScope", "Lcom/google/wireless/android/sdk/stats/IntellijProjectSizeStats$Scope;", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;Lcom/google/wireless/android/sdk/stats/IntellijProjectSizeStats$Scope;)V", "globalSearchScope", "All", "LIBRARY", "intellij.android.core"})
    private static final class SearchScope
    extends Enum<SearchScope> {
        public static final /* enum */ SearchScope All;
        public static final /* enum */ SearchScope LIBRARY;
        private static final /* synthetic */ SearchScope[] $VALUES;
        private final Function1<Project, GlobalSearchScope> globalSearchScopeFunc;
        private final IntellijProjectSizeStats.Scope statsSearchScope;

        static {
            SearchScope[] searchScopeArray = new SearchScope[2];
            SearchScope[] searchScopeArray2 = searchScopeArray;
            searchScopeArray[0] = All = new SearchScope((Function1<? super Project, ? extends GlobalSearchScope>)((Function1)1.INSTANCE), IntellijProjectSizeStats.Scope.ALL);
            searchScopeArray[1] = LIBRARY = new SearchScope((Function1<? super Project, ? extends GlobalSearchScope>)((Function1)2.INSTANCE), IntellijProjectSizeStats.Scope.LIBRARY);
            $VALUES = searchScopeArray;
        }

        @NotNull
        public final GlobalSearchScope globalSearchScope(@NotNull Project project) {
            return (GlobalSearchScope)this.globalSearchScopeFunc.invoke((Object)project);
        }

        @NotNull
        public final IntellijProjectSizeStats.Scope statsSearchScope() {
            return this.statsSearchScope;
        }

        private SearchScope(Function1<? super Project, ? extends GlobalSearchScope> globalSearchScopeFunc, IntellijProjectSizeStats.Scope statsSearchScope) {
            this.globalSearchScopeFunc = globalSearchScopeFunc;
            this.statsSearchScope = statsSearchScope;
        }

        public static SearchScope[] values() {
            return (SearchScope[])$VALUES.clone();
        }

        public static SearchScope valueOf(String string) {
            return Enum.valueOf(SearchScope.class, string);
        }
    }
}

