/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.sqliteEvaluator;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.Chunk;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.EmptyStatePanel;
import com.android.tools.adtui.stdui.LabelData;
import com.android.tools.adtui.stdui.NewLineChunk;
import com.android.tools.adtui.stdui.TextChunk;
import com.android.tools.idea.lang.androidSql.AndroidSqlLanguage;
import com.android.tools.idea.sqlite.SchemaProvider;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.sqlLanguage.SqliteSchemaContext;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.QueryHistoryView;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorViewImpl;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0019H\u0016J\b\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0019H\u0016J\u001a\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0010\u00100\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020\u0011H\u0016J \u00103\u001a\u00020'2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u0011052\b\u00106\u001a\u0004\u0018\u00010\u0011H\u0016J\u0016\u00107\u001a\u00020'2\f\u00108\u001a\b\u0012\u0004\u0012\u00020-05H\u0016J\u0010\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020\u0016H\u0016J\b\u0010;\u001a\u00020'H\u0002J\u0010\u0010<\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020-H\u0016J\b\u0010?\u001a\u00020'H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;", "project", "Lcom/intellij/openapi/project/Project;", "tableView", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "schemaProvider", "Lcom/android/tools/idea/sqlite/SchemaProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/ui/tableView/TableView;Lcom/android/tools/idea/sqlite/SchemaProvider;)V", "bottomPanel", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "databaseComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "editorTextField", "Lcom/intellij/ui/EditorTextField;", "Lorg/jetbrains/annotations/NotNull;", "evaluateSqliteStatementEnabled", "", "listeners", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "queryHistoryButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "queryHistoryView", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/QueryHistoryView;", "runButton", "Ljavax/swing/JButton;", "getTableView", "()Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "threeComponentsSplitter", "Lcom/intellij/openapi/ui/ThreeComponentsSplitter;", "addListener", "", "listener", "evaluateSqliteExpression", "removeListener", "reportError", "message", "", "t", "", "resetBottomPanelAndAddView", "schemaChanged", "databaseId", "setDatabases", "databaseIds", "", "selected", "setQueryHistory", "queries", "setRunSqliteStatementEnabled", "enabled", "setSchemaFromSelectedItem", "showMessagePanel", "showSqliteStatement", "sqliteStatement", "showTableView", "intellij.android.debuggers"})
public final class SqliteEvaluatorViewImpl
implements SqliteEvaluatorView {
    private final ThreeComponentsSplitter threeComponentsSplitter;
    private final JPanel bottomPanel;
    @NotNull
    private final JComponent component;
    private final ComboBox<SqliteDatabaseId> databaseComboBox;
    private final EditorTextField editorTextField;
    private final ArrayList<SqliteEvaluatorView.Listener> listeners;
    private final CommonButton queryHistoryButton;
    private final JButton runButton;
    private boolean evaluateSqliteStatementEnabled;
    private final QueryHistoryView queryHistoryView;
    @NotNull
    private final Project project;
    @NotNull
    private final TableView tableView;
    private final SchemaProvider schemaProvider;

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void schemaChanged(@NotNull SqliteDatabaseId databaseId) {
        Object object = this.databaseComboBox.getSelectedItem();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteDatabaseId");
        }
        if (Intrinsics.areEqual((Object)((SqliteDatabaseId)object), (Object)databaseId)) {
            this.setSchemaFromSelectedItem();
        }
    }

    @Override
    public void setRunSqliteStatementEnabled(boolean enabled) {
        this.evaluateSqliteStatementEnabled = enabled;
        this.runButton.setEnabled(enabled);
    }

    private final void evaluateSqliteExpression() {
        if (!this.evaluateSqliteStatementEnabled) {
            return;
        }
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteEvaluatorView.Listener it = (SqliteEvaluatorView.Listener)element$iv;
            boolean bl = false;
            it.evaluateCurrentStatement();
        }
    }

    private final void setSchemaFromSelectedItem() {
        if (this.databaseComboBox.getSelectedIndex() < 0) {
            return;
        }
        Object object = this.databaseComboBox.getSelectedItem();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteDatabaseId");
        }
        SqliteDatabaseId database = (SqliteDatabaseId)object;
        SqliteSchema schema = this.schemaProvider.getSchema(database);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile = fileDocumentManager.getFile(this.editorTextField.getDocument());
        if (virtualFile != null) {
            virtualFile.putUserData(SqliteSchemaContext.Companion.getSQLITE_SCHEMA_KEY(), (Object)schema);
        }
        ApplicationManager.getApplication().invokeLaterOnWriteThread(new Runnable(this){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;

            public final void run() {
                PsiManager.getInstance((Project)this.this$0.getProject()).dropPsiCaches();
            }
            {
                this.this$0 = sqliteEvaluatorViewImpl;
            }
        });
    }

    @Override
    public void setDatabases(@NotNull List<? extends SqliteDatabaseId> databaseIds, @Nullable SqliteDatabaseId selected) {
        this.databaseComboBox.removeAllItems();
        Collection collection2 = databaseIds;
        boolean bl = false;
        this.databaseComboBox.setEnabled(!collection2.isEmpty());
        for (SqliteDatabaseId sqliteDatabaseId : databaseIds) {
            this.databaseComboBox.addItem((Object)sqliteDatabaseId);
        }
        if (Intrinsics.areEqual((Object)this.databaseComboBox.getSelectedItem(), (Object)selected) ^ true) {
            this.databaseComboBox.setSelectedItem((Object)selected);
        }
    }

    @Override
    public void addListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        this.listeners.remove(listener2);
    }

    @Override
    public void showSqliteStatement(@NotNull String sqliteStatement) {
        this.editorTextField.setText(sqliteStatement);
    }

    @Override
    public void reportError(@NotNull String message2, @Nullable Throwable t) {
        UtilsKt.notifyError(message2, t);
    }

    @Override
    public void setQueryHistory(@NotNull List<String> queries) {
        this.queryHistoryView.setQueryHistory(queries);
    }

    @Override
    public void showMessagePanel(@NotNull String message2) {
        boolean bl = false;
        List chunks = new ArrayList();
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)message2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            chunks.add(new TextChunk(it));
            chunks.add(NewLineChunk.INSTANCE);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.dropLast((List)chunks, (int)1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Chunk[] chunkArray = thisCollection$iv.toArray(new Chunk[0]);
        if (chunkArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        EmptyStatePanel enterOfflineModePanel2 = new EmptyStatePanel(new LabelData(Arrays.copyOf(chunkArray, chunkArray.length)), null, null, 6, null);
        enterOfflineModePanel2.setName("message-panel");
        this.resetBottomPanelAndAddView((JComponent)enterOfflineModePanel2);
    }

    @Override
    public void showTableView() {
        this.resetBottomPanelAndAddView(this.getTableView().getComponent());
    }

    private final void resetBottomPanelAndAddView(JComponent component) {
        this.bottomPanel.removeAll();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)component, "Center");
        this.bottomPanel.revalidate();
        this.bottomPanel.repaint();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public TableView getTableView() {
        return this.tableView;
    }

    public SqliteEvaluatorViewImpl(@NotNull Project project, @NotNull TableView tableView, @NotNull SchemaProvider schemaProvider) {
        this.project = project;
        this.tableView = tableView;
        this.schemaProvider = schemaProvider;
        this.threeComponentsSplitter = new ThreeComponentsSplitter((Disposable)this.getProject());
        this.bottomPanel = new JPanel(new BorderLayout());
        this.component = (JComponent)this.threeComponentsSplitter;
        this.databaseComboBox = new ComboBox();
        this.editorTextField = EditorTextFieldProvider.getInstance().getEditorField((Language)AndroidSqlLanguage.INSTANCE, this.getProject(), (Iterable)CollectionsKt.listOf((Object)editorTextField.1.INSTANCE));
        this.listeners = new ArrayList();
        this.queryHistoryButton = new CommonButton(AllIcons.Vcs.History);
        this.runButton = new JButton("Run");
        this.queryHistoryView = new QueryHistoryView(this.editorTextField);
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel controlsPanel = new JPanel(new BorderLayout());
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 2));
        topPanel.add((Component)this.editorTextField, "Center");
        topPanel.add((Component)controlsPanel, "South");
        CommonButton commonButton = this.threeComponentsSplitter;
        boolean bl = false;
        boolean bl2 = false;
        CommonButton $this$apply = commonButton;
        boolean bl3 = false;
        $this$apply.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        $this$apply.setFocusCycleRoot(false);
        $this$apply.setDividerWidth(0);
        $this$apply.setFirstSize(JBUI.scale((int)100));
        $this$apply.setOrientation(true);
        $this$apply.setFirstComponent((JComponent)topPanel);
        $this$apply.setLastComponent((JComponent)this.bottomPanel);
        topPanel.setBorder(JBUI.Borders.empty((int)6));
        controlsPanel.setBorder((Border)JBUI.Borders.empty((int)6, (int)0, (int)0, (int)0));
        this.bottomPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        topPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        controlsPanel.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        controlsPanel.add((Component)this.databaseComboBox);
        controlsPanel.add(Box.createRigidArea((Dimension)JBUI.size((Dimension)new Dimension(5, 0))));
        controlsPanel.add((Component)this.queryHistoryButton);
        controlsPanel.add(Box.createHorizontalGlue());
        controlsPanel.add(this.runButton);
        commonButton = this.databaseComboBox;
        bl = false;
        bl2 = false;
        $this$apply = commonButton;
        boolean bl4 = false;
        $this$apply.addActionListener(new ActionListener(this){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            {
                this.this$0 = sqliteEvaluatorViewImpl;
            }

            public final void actionPerformed(ActionEvent it) {
                SqliteEvaluatorViewImpl.access$setSchemaFromSelectedItem(this.this$0);
                Object object = SqliteEvaluatorViewImpl.access$getDatabaseComboBox$p(this.this$0).getSelectedItem();
                if (!(object instanceof SqliteDatabaseId)) {
                    object = null;
                }
                SqliteDatabaseId sqliteDatabaseId = (SqliteDatabaseId)object;
                if (sqliteDatabaseId == null) {
                    return;
                }
                SqliteDatabaseId sqliteDatabaseId2 = sqliteDatabaseId;
                Iterable $this$forEach$iv = SqliteEvaluatorViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqliteEvaluatorView.Listener it2 = (SqliteEvaluatorView.Listener)element$iv;
                    boolean bl = false;
                    it2.onDatabaseSelected(sqliteDatabaseId2);
                }
            }
        });
        $this$apply.setMinimumAndPreferredWidth(JBUI.scale((int)300));
        $this$apply.setMaximumSize((Dimension)JBUI.size((int)300, (int)this.databaseComboBox.getPreferredSize().height));
        $this$apply.setRenderer((ListCellRenderer)new ColoredListCellRenderer<SqliteDatabaseId>(){

            protected void customizeCellRenderer(@NotNull JList<? extends SqliteDatabaseId> list, @Nullable SqliteDatabaseId sqliteDatabase, int index2, boolean selected, boolean hasFocus) {
                if (sqliteDatabase != null) {
                    Icon icon2;
                    SqliteDatabaseId sqliteDatabaseId = sqliteDatabase;
                    if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
                        icon2 = StudioIcons.DatabaseInspector.DATABASE;
                    } else if (sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
                        icon2 = StudioIcons.DatabaseInspector.DATABASE_OFFLINE;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    this.setIcon(icon2);
                    this.append(sqliteDatabase.getName());
                } else {
                    this.setIcon(null);
                    this.append(DatabaseInspectorBundle.INSTANCE.message("no.databases.available", new String[0]));
                }
            }
        });
        commonButton = this.queryHistoryButton;
        bl = false;
        bl2 = false;
        $this$apply = commonButton;
        boolean bl5 = false;
        $this$apply.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Vcs.History));
        $this$apply.setToolTipText("Show query history");
        $this$apply.addActionListener(new ActionListener(this, topPanel, controlsPanel){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            final /* synthetic */ JPanel $topPanel$inlined;
            final /* synthetic */ JPanel $controlsPanel$inlined;
            {
                this.this$0 = sqliteEvaluatorViewImpl;
                this.$topPanel$inlined = jPanel;
                this.$controlsPanel$inlined = jPanel2;
            }

            public final void actionPerformed(ActionEvent it) {
                SqliteEvaluatorViewImpl.access$getQueryHistoryView$p(this.this$0).show(this.this$0.getComponent(), SqliteEvaluatorViewImpl.access$getQueryHistoryButton$p(this.this$0).getX() + SqliteEvaluatorViewImpl.access$getQueryHistoryButton$p(this.this$0).getWidth() / 2, this.$topPanel$inlined.getHeight() - this.$topPanel$inlined.getBorder().getBorderInsets((Component)((Component)this.$controlsPanel$inlined)).bottom);
            }
        });
        Keymap active = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutsMultiline = active.getShortcuts("Console.Execute.Multiline");
        KeyStroke keyStroke = KeymapUtil.getKeyStroke((ShortcutSet)((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcutsMultiline, shortcutsMultiline.length))));
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        KeyStroke keyStrokeMultiline = keyStroke;
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)((ShortcutSet)new CustomShortcutSet(keyStrokeMultiline)));
        JButton jButton = this.runButton;
        boolean bl6 = false;
        boolean bl7 = false;
        JButton $this$apply2 = jButton;
        boolean bl8 = false;
        $this$apply2.setToolTipText("Run SQLite expression (" + shortcutText + ')');
        $this$apply2.setEnabled(false);
        $this$apply2.addActionListener(new ActionListener(this, shortcutText){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            final /* synthetic */ String $shortcutText$inlined;
            {
                this.this$0 = sqliteEvaluatorViewImpl;
                this.$shortcutText$inlined = string;
            }

            public final void actionPerformed(ActionEvent it) {
                SqliteEvaluatorViewImpl.access$evaluateSqliteExpression(this.this$0);
            }
        });
        $this$apply2.setName("run-button");
        $this$apply2.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        jButton = this.editorTextField;
        bl6 = false;
        bl7 = false;
        $this$apply2 = jButton;
        boolean bl9 = false;
        $this$apply2.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        $this$apply2.setName("editor");
        $this$apply2.setPlaceholder("Enter query...");
        DumbAwareAction.create((Consumer)((Consumer)new Consumer<AnActionEvent>(this, keyStrokeMultiline){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            final /* synthetic */ KeyStroke $keyStrokeMultiline$inlined;
            {
                this.this$0 = sqliteEvaluatorViewImpl;
                this.$keyStrokeMultiline$inlined = keyStroke;
            }

            public final void consume(AnActionEvent it) {
                SqliteEvaluatorViewImpl.access$evaluateSqliteExpression(this.this$0);
            }
        })).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStrokeMultiline), (JComponent)this.editorTextField);
        $this$apply2.getDocument().addDocumentListener(new DocumentListener(this, keyStrokeMultiline){
            final /* synthetic */ SqliteEvaluatorViewImpl this$0;
            final /* synthetic */ KeyStroke $keyStrokeMultiline$inlined;
            {
                this.this$0 = sqliteEvaluatorViewImpl;
                this.$keyStrokeMultiline$inlined = keyStroke;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Iterable $this$forEach$iv = SqliteEvaluatorViewImpl.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SqliteEvaluatorView.Listener it = (SqliteEvaluatorView.Listener)element$iv;
                    boolean bl = false;
                    it.sqliteStatementTextChangedInvoked(event.getDocument().getText());
                }
            }
        });
    }

    public static final /* synthetic */ void access$setSchemaFromSelectedItem(SqliteEvaluatorViewImpl $this) {
        $this.setSchemaFromSelectedItem();
    }

    public static final /* synthetic */ ComboBox access$getDatabaseComboBox$p(SqliteEvaluatorViewImpl $this) {
        return $this.databaseComboBox;
    }

    public static final /* synthetic */ ArrayList access$getListeners$p(SqliteEvaluatorViewImpl $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ QueryHistoryView access$getQueryHistoryView$p(SqliteEvaluatorViewImpl $this) {
        return $this.queryHistoryView;
    }

    public static final /* synthetic */ CommonButton access$getQueryHistoryButton$p(SqliteEvaluatorViewImpl $this) {
        return $this.queryHistoryButton;
    }

    public static final /* synthetic */ void access$evaluateSqliteExpression(SqliteEvaluatorViewImpl $this) {
        $this.evaluateSqliteExpression();
    }
}

