/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.progress;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProgressRunner
implements ProgressRunner {
    private boolean myModal;
    private final boolean myCancellable;
    private final Project myProject;
    private final String myProgressTitle;

    public StudioProgressRunner(boolean modal, boolean cancellable, String progressTitle, @Nullable Project project) {
        this.myModal = modal;
        this.myCancellable = cancellable;
        this.myProject = project;
        this.myProgressTitle = progressTitle;
    }

    public void runAsyncWithProgress(@NotNull ProgressRunner.ProgressRunnable r) {
        this.runAsyncWithProgress(r, false);
    }

    @VisibleForTesting
    public void runAsyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable r, final boolean overrideTestMode) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean hasOpenProjects;
                Task.Backgroundable task2 = new Task.Backgroundable(StudioProgressRunner.this.myProject, StudioProgressRunner.this.myProgressTitle, StudioProgressRunner.this.myCancellable, new PerformInBackgroundOption(){

                    public boolean shouldStartInBackground() {
                        return !StudioProgressRunner.this.myModal;
                    }
                }){

                    public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                        ApplicationManager.getApplication().executeOnPooledThread(() -> r.run((ProgressIndicator)new RepoProgressIndicatorAdapter(indicator), (ProgressRunner)StudioProgressRunner.this));
                    }

                    public boolean isConditionalModal() {
                        return true;
                    }

                    public boolean isHeadless() {
                        return overrideTestMode ? false : super.isHeadless();
                    }
                };
                boolean bl = hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
                if (hasOpenProjects) {
                    ProgressManager.getInstance().run((Task)task2);
                } else {
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (com.intellij.openapi.progress.ProgressIndicator)new EmptyProgressIndicator());
                }
            }
        });
    }

    public void runSyncWithProgress(final @NotNull ProgressRunner.ProgressRunnable progressRunnable) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            Task.Modal task2 = new Task.Modal(this.myProject, this.myProgressTitle, this.myCancellable){

                public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                    StudioProgressRunner.this.doRunSync(indicator, progressRunnable);
                }
            };
            ProgressManager.getInstance().run((Task)task2);
        });
    }

    private void doRunSync(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator, @NotNull ProgressRunner.ProgressRunnable progressRunnable) {
        RepoProgressIndicatorAdapter repoProgress = new RepoProgressIndicatorAdapter(indicator);
        try {
            ApplicationManager.getApplication().executeOnPooledThread(() -> progressRunnable.run((ProgressIndicator)repoProgress, (ProgressRunner)this)).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    public void runSyncWithoutProgress(@NotNull Runnable r) {
        r.run();
    }
}

