/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.sdklib.devices.Storage;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioProgressIndicatorAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.NetUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class StudioDownloader
implements Downloader {
    @VisibleForTesting
    static final String DOWNLOAD_SUFFIX_FN = ".asdownload";
    File mDownloadIntermediatesLocation;
    @NotNull
    private final SettingsController mySettingsController;

    public StudioDownloader() {
        this(StudioSettingsController.getInstance());
    }

    @VisibleForTesting
    StudioDownloader(@NotNull SettingsController settingsController) {
        this.mySettingsController = settingsController;
    }

    public InputStream downloadAndStream(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        Path file2 = this.downloadFully(url, indicator);
        if (file2 == null) {
            return null;
        }
        return Files.newInputStream(file2, StandardOpenOption.DELETE_ON_CLOSE);
    }

    public void downloadFully(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        this.doDownloadFully(url, target, checksum, false, indicator);
    }

    public void downloadFullyWithCaching(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        this.doDownloadFully(url, target, checksum, true, indicator);
    }

    public void setDownloadIntermediatesLocation(File downloadIntermediatesLocation) {
        this.mDownloadIntermediatesLocation = downloadIntermediatesLocation;
    }

    private void doDownloadFully(@NotNull URL url, @NotNull File target, String checksum, boolean allowNetworkCaches, @NotNull ProgressIndicator indicator) throws IOException {
        if (target.exists() && checksum != null && checksum.equals(Downloader.hash((InputStream)new BufferedInputStream(new FileInputStream(target)), (long)target.length(), (ProgressIndicator)indicator))) {
            return;
        }
        String preparedUrl = this.prepareUrl(url);
        indicator.logInfo("Downloading " + preparedUrl);
        indicator.setText("Starting download...");
        indicator.setSecondaryText(preparedUrl);
        RequestBuilder rb = HttpRequests.request((String)preparedUrl).productNameAsUserAgent();
        if (this.mySettingsController.getForceHttp()) {
            rb.forceHttps(false);
        }
        rb.tuner(c -> c.setUseCaches(allowNetworkCaches));
        File interimDownload = this.getInterimDownloadLocationForTarget(target);
        if (interimDownload.exists()) {
            if (allowNetworkCaches) {
                String rangeHeader = String.format("bytes=%1$s-", interimDownload.length());
                rb.tuner(c -> c.setRequestProperty("Range", rangeHeader));
            } else {
                FileUtil.delete((File)interimDownload);
            }
        }
        rb.connect(request -> {
            long startOffset = interimDownload.length();
            long contentLength = startOffset + (long)request.getConnection().getContentLength();
            DownloadProgressIndicator downloadProgressIndicator = new DownloadProgressIndicator(indicator, target.getName(), contentLength, startOffset);
            FileUtilRt.createParentDirs((File)interimDownload);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(interimDownload, true));){
                NetUtils.copyStreamContent((com.intellij.openapi.progress.ProgressIndicator)downloadProgressIndicator, (InputStream)request.getInputStream(), (OutputStream)out, (int)request.getConnection().getContentLength());
            }
            try {
                if (target.exists()) {
                    FileUtil.delete((File)target);
                }
                FileUtilRt.createParentDirs((File)target);
                Files.move(interimDownload.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (target.exists() && checksum != null && !checksum.equals(Downloader.hash((InputStream)new BufferedInputStream(new FileInputStream(target)), (long)target.length(), (ProgressIndicator)indicator))) {
                    throw new IllegalStateException("Checksum of the downloaded result didn't match the expected value.");
                }
            }
            catch (Throwable e) {
                if (allowNetworkCaches) {
                    indicator.logWarning("This download could not be finalized from the interim state. Retrying without caching.");
                    this.doDownloadFully(url, target, checksum, false, indicator);
                    return null;
                }
                throw e;
            }
            return target;
        });
    }

    private File getInterimDownloadLocationForTarget(File target) {
        if (this.mDownloadIntermediatesLocation != null) {
            return new File(this.mDownloadIntermediatesLocation, target.getName() + DOWNLOAD_SUFFIX_FN);
        }
        return new File(target + DOWNLOAD_SUFFIX_FN);
    }

    public Path downloadFully(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        String suffix = url.getPath();
        suffix = suffix.substring(suffix.lastIndexOf(47) + 1);
        File tempFile = FileUtil.createTempFile((String)"StudioDownloader", (String)suffix, (boolean)true);
        tempFile.deleteOnExit();
        this.downloadFully(url, tempFile, null, indicator);
        return tempFile.toPath();
    }

    @VisibleForTesting
    @NotNull
    String prepareUrl(@NotNull URL url) {
        String prepared = url.toExternalForm();
        if (this.mySettingsController.getForceHttp() && StringUtil.startsWith((CharSequence)prepared, (CharSequence)"https:")) {
            prepared = "http:" + prepared.substring(6);
        }
        return prepared;
    }

    @VisibleForTesting
    static class DownloadProgressIndicator
    extends StudioProgressIndicatorAdapter {
        private final String mTargetName;
        private final long mContentLength;
        private final String mTotalDisplaySize;
        private int mCurrentPercentage;
        private long mStartOffset;
        private Storage.Unit mReasonableUnit;

        DownloadProgressIndicator(@NotNull ProgressIndicator wrapped, @NotNull String targetName, long contentLength, long startOffset) {
            super(wrapped);
            this.mTargetName = targetName;
            if (contentLength > 0L) {
                this.mCurrentPercentage = (int)((double)this.mStartOffset / (double)contentLength);
                this.mContentLength = contentLength;
                this.mStartOffset = startOffset;
                Storage storage = new Storage(this.mContentLength);
                this.mReasonableUnit = storage.getLargestReasonableUnits();
                this.mTotalDisplaySize = storage.toUiString(1);
                this.setIndeterminate(false);
            } else {
                this.mCurrentPercentage = 0;
                this.mContentLength = 0L;
                this.mStartOffset = 0L;
                this.mTotalDisplaySize = null;
                this.setText(String.format("Downloading $1%s...", this.mTargetName));
                this.setIndeterminate(true);
            }
        }

        @Override
        public void setFraction(double fraction) {
            if (this.isIndeterminate()) {
                return;
            }
            double adjustedFraction = ((double)this.mStartOffset + fraction * (double)(this.mContentLength - this.mStartOffset)) / (double)this.mContentLength;
            super.setFraction(adjustedFraction);
            this.checkCanceled();
            int percentage = (int)(adjustedFraction * 100.0);
            if (percentage == this.mCurrentPercentage) {
                return;
            }
            this.mCurrentPercentage = percentage;
            long downloadedSize = (long)(adjustedFraction * (double)this.mContentLength);
            double downloadedSizeInReasonableUnits = new Storage(downloadedSize).getPreciseSizeAsUnit(this.mReasonableUnit);
            this.setText(String.format(Locale.US, "Downloading %1$s (%2$d%%): %3$.1f / %4$s ...", this.mTargetName, this.mCurrentPercentage, downloadedSizeInReasonableUnits, this.mTotalDisplaySize));
        }
    }
}

