/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApplicationLogListener;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestSuiteConstantsKt;
import com.google.common.base.Preconditions;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ConnectJavaDebuggerTask
extends ConnectDebuggerTask {
    public ConnectJavaDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean attachToRunningProcess) {
        super(applicationIds, debugger, project, attachToRunningProcess);
    }

    @Override
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        RunProfile runProfile;
        RunContentDescriptor debugDescriptor;
        AndroidDebugState debugState;
        String debugPort = Integer.toString(client.getDebuggerListenPort());
        final int pid = client.getClientData().getPid();
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format(Locale.US, "Attempting to connect debugger to port %1$s [client %2$d]", debugPort, pid));
        ProcessHandler processHandler = launchStatus.getProcessHandler();
        RunContentDescriptor descriptor2 = ((AndroidSessionInfo)Preconditions.checkNotNull((Object)processHandler.getUserData(AndroidSessionInfo.KEY))).getDescriptor();
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        final AndroidRemoteDebugProcessHandler debugProcessHandler = new AndroidRemoteDebugProcessHandler(this.myProject);
        launchStatus.setProcessHandler(debugProcessHandler);
        printer.setProcessHandler(debugProcessHandler);
        processHandler.detachProcess();
        Object androidTestResultListener = processHandler.getCopyableUserData(AndroidTestSuiteConstantsKt.ANDROID_TEST_RESULT_LISTENER_KEY);
        if (androidTestResultListener instanceof ConsoleView) {
            ConsoleView consoleViewToReuse = (ConsoleView)androidTestResultListener;
            debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, (parent, handler2, executor) -> {
                consoleViewToReuse.attachToProcess(handler2);
                return consoleViewToReuse;
            });
        } else {
            debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, currentLaunchInfo.consoleProvider);
        }
        try {
            ExecutionEnvironment debugEnv = new ExecutionEnvironmentBuilder(currentLaunchInfo.env).executor(currentLaunchInfo.executor).runner(currentLaunchInfo.runner).contentToReuse(descriptor2).build();
            debugDescriptor = DebuggerPanelsManager.getInstance((Project)this.myProject).attachVirtualMachine(debugEnv, (RunProfileState)debugState, connection, false);
        }
        catch (ExecutionException e) {
            processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
            return null;
        }
        if (debugDescriptor == null) {
            processHandler.notifyTextAvailable("Unable to connect debugger to Android application", ProcessOutputTypes.STDERR);
            return null;
        }
        AndroidProcessText oldText = AndroidProcessText.get(processHandler);
        if (oldText != null) {
            oldText.printTo(debugProcessHandler);
        }
        RunConfiguration runConfiguration = (runProfile = currentLaunchInfo.env.getRunProfile()) instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        AndroidSessionInfo.create(debugProcessHandler, debugDescriptor, runConfiguration, currentLaunchInfo.executor.getId(), currentLaunchInfo.executor.getActionName(), currentLaunchInfo.env.getExecutionTarget());
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT, client);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, client.getDevice().getVersion());
        final String pkgName = client.getClientData().getClientDescription();
        final IDevice device = client.getDevice();
        ConnectJavaDebuggerTask.captureLogcatOutput(client, debugProcessHandler);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private int myTerminationCount = 0;
            private boolean myWillBeDestroyed = true;

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processWillTerminate: " + pkgName + ", willBeDestroyed=" + willBeDestroyed);
                this.myWillBeDestroyed = willBeDestroyed;
                this.processTerminationCallback();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processTerminated: " + pkgName);
                this.processTerminationCallback();
            }

            private void processTerminationCallback() {
                ++this.myTerminationCount;
                if (this.myTerminationCount != 2) {
                    return;
                }
                debugProcessHandler.removeProcessListener((ProcessListener)this);
                Client currentClient = device.getClient(pkgName);
                if (currentClient != null && currentClient.getClientData().getPid() != pid) {
                    return;
                }
                if (this.myWillBeDestroyed) {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger terminating, so terminating process: " + pkgName);
                    ProgressManager.getInstance().run((Task)new Task.Backgroundable(ConnectJavaDebuggerTask.this.myProject, "Stopping Application..."){

                        public void run(@NotNull ProgressIndicator indicator) {
                            try {
                                device.executeShellCommand("am force-stop " + pkgName, (IShellOutputReceiver)new NullOutputReceiver());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger detaching, leaving process alive: " + pkgName);
                }
            }
        });
        return debugProcessHandler;
    }

    private static void captureLogcatOutput(@NotNull Client client, @NotNull ProcessHandler debugProcessHandler) {
        if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!LogcatOutputSettings.getInstance().isDebugOutputEnabled()) {
            return;
        }
        final IDevice device = client.getDevice();
        final MyLogcatListener logListener = new MyLogcatListener(client, debugProcessHandler);
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\")", device.getName()));
        AndroidLogcatService.getInstance().addListener(device, logListener, true);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\"): remove listener", device.getName()));
                AndroidLogcatService.getInstance().removeListener(device, logListener);
            }
        });
    }

    private static final class MyLogcatListener
    extends ApplicationLogListener {
        private static final String SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
        private final AndroidLogcatFormatter myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
        private final AtomicBoolean myIsFirstMessage = new AtomicBoolean(true);
        private final ProcessHandler myDebugProcessHandler;

        private MyLogcatListener(@NotNull Client client, @NotNull ProcessHandler debugProcessHandler) {
            super(client.getClientData().getClientDescription(), client.getClientData().getPid());
            this.myDebugProcessHandler = debugProcessHandler;
        }

        @Override
        @NotNull
        protected String formatLogLine(@NotNull LogCatMessage line2) {
            return this.myFormatter.formatMessage(SIMPLE_FORMAT, line2.getHeader(), line2.getMessage());
        }

        @Override
        protected void notifyTextAvailable(@NotNull String message2, @NotNull Key key) {
            if (this.myIsFirstMessage.compareAndSet(true, false)) {
                this.myDebugProcessHandler.notifyTextAvailable("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
            }
            this.myDebugProcessHandler.notifyTextAvailable(message2, key);
        }
    }
}

