/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.profiler;

import com.android.utils.HashCodes;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerConfig {
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    @NotNull
    private String myName;
    @NotNull
    private Technology myTechnology;
    private int mySamplingIntervalUs = 1000;
    private int myBufferSizeMb = 8;
    private boolean myDisableLiveAllocation = true;

    public CpuProfilerConfig() {
        this.myName = Technology.SAMPLED_JAVA.getName();
        this.myTechnology = Technology.SAMPLED_JAVA;
    }

    public CpuProfilerConfig(@NotNull String name, @NotNull Technology technology) {
        this.myName = name;
        this.myTechnology = technology;
    }

    CpuProfilerConfig(@NotNull Technology technology) {
        this(technology.getName(), technology);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public CpuProfilerConfig setName(@NotNull String name) {
        this.myName = name;
        return this;
    }

    @NotNull
    public Technology getTechnology() {
        return this.myTechnology;
    }

    @NotNull
    public CpuProfilerConfig setTechnology(@NotNull Technology technology) {
        this.myTechnology = technology;
        return this;
    }

    public int getSamplingIntervalUs() {
        return this.mySamplingIntervalUs;
    }

    @NotNull
    public CpuProfilerConfig setSamplingIntervalUs(int samplingIntervalUs) {
        this.mySamplingIntervalUs = samplingIntervalUs;
        return this;
    }

    public int getBufferSizeMb() {
        return this.myBufferSizeMb;
    }

    @NotNull
    public CpuProfilerConfig setBufferSizeMb(int bufferSize) {
        this.myBufferSizeMb = bufferSize;
        return this;
    }

    public boolean isDisableLiveAllocation() {
        return this.myDisableLiveAllocation;
    }

    @NotNull
    public CpuProfilerConfig setDisableLiveAllocation(boolean disableLiveAllocation) {
        this.myDisableLiveAllocation = disableLiveAllocation;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpuProfilerConfig config = (CpuProfilerConfig)o;
        return this.mySamplingIntervalUs == config.mySamplingIntervalUs && this.myBufferSizeMb == config.myBufferSizeMb && Objects.equals(this.myName, config.myName) && this.myTechnology == config.myTechnology && this.myDisableLiveAllocation == config.myDisableLiveAllocation;
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myName.hashCode(), (int)this.myTechnology.hashCode(), (int)this.mySamplingIntervalUs, (int)this.myBufferSizeMb, (int)Boolean.hashCode(this.myDisableLiveAllocation));
    }

    public static enum Technology {
        SAMPLED_JAVA{

            @Override
            @NotNull
            public String getName() {
                return "Sample Java Methods";
            }
        }
        ,
        INSTRUMENTED_JAVA{

            @Override
            @NotNull
            public String getName() {
                return "Trace Java Methods";
            }
        }
        ,
        SAMPLED_NATIVE{

            @Override
            @NotNull
            public String getName() {
                return "Sample C/C++ Functions";
            }
        }
        ,
        SYSTEM_TRACE{

            @Override
            @NotNull
            public String getName() {
                return "Trace System Calls";
            }
        };


        @NotNull
        public abstract String getName();
    }
}

