/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class RunOnMultipleDevicesAction
extends AnAction {
    public static final String ID = "RunOnMultipleDevices";
    @NotNull
    private final @NotNull Function<@NotNull Project, @NotNull RunManager> myRunManagerGetInstance;
    @NotNull
    private final @NotNull Function<@NotNull Project, @NotNull AsyncDevicesGetter> myAsyncDevicesGetterGetInstance;
    @NotNull
    private final BooleanSupplier myRunningInstrumentedTestsOnMultipleDevicesEnabledGet;

    private RunOnMultipleDevicesAction() {
        this(RunManager::getInstance, AsyncDevicesGetter::getInstance, StudioFlags.MULTIDEVICE_INSTRUMENTATION_TESTS::get);
    }

    @NonInjectable
    @VisibleForTesting
    RunOnMultipleDevicesAction(@NotNull @NotNull Function<@NotNull Project, @NotNull RunManager> runManagerGetInstance, @NotNull @NotNull Function<@NotNull Project, @NotNull AsyncDevicesGetter> asyncDevicesGetterGetInstance, @NotNull BooleanSupplier runningInstrumentedTestsOnMultipleDevicesEnabledGet) {
        this.myRunManagerGetInstance = runManagerGetInstance;
        this.myAsyncDevicesGetterGetInstance = asyncDevicesGetterGetInstance;
        this.myRunningInstrumentedTestsOnMultipleDevicesEnabledGet = runningInstrumentedTestsOnMultipleDevicesEnabledGet;
    }

    public void update(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        Presentation presentation = event.getPresentation();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        RunnerAndConfigurationSettings configurationAndSettings = this.myRunManagerGetInstance.apply(project).getSelectedConfiguration();
        if (configurationAndSettings == null) {
            presentation.setEnabled(false);
            return;
        }
        if (!this.supports(configurationAndSettings)) {
            presentation.setEnabled(false);
            return;
        }
        if (this.myAsyncDevicesGetterGetInstance.apply(project).get().orElse(Collections.emptyList()).isEmpty()) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    private boolean supports(@NotNull RunnerAndConfigurationSettings configurationAndSettings) {
        switch (configurationAndSettings.getType().getId()) {
            case "AndroidRunConfigurationType": {
                return true;
            }
            case "AndroidTestRunConfigurationType": {
                return this.myRunningInstrumentedTestsOnMultipleDevicesEnabledGet.getAsBoolean();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        RunnerAndConfigurationSettings configurationAndSettings = this.myRunManagerGetInstance.apply(project).getSelectedConfiguration();
        if (configurationAndSettings == null) {
            return;
        }
        try {
            project.putUserData(DeviceAndSnapshotComboBoxTargetProvider.MULTIPLE_DEPLOY_TARGETS, (Object)true);
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)configurationAndSettings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
        }
        finally {
            project.putUserData(DeviceAndSnapshotComboBoxTargetProvider.MULTIPLE_DEPLOY_TARGETS, (Object)false);
        }
    }
}

