/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhysicalDevice
extends Device {
    private static final Icon ourValidIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
    private static final Icon ourInvalidIcon = ExecutionUtil.getLiveIndicator((Icon)AllIcons.General.Error);

    @NotNull
    static PhysicalDevice newDevice(@NotNull ConnectedDevice device, @NotNull Function<ConnectedDevice, String> getName, @NotNull KeyToConnectionTimeMap map2) {
        Key key = device.getKey();
        return new Builder().setName(getName.apply(device)).setValid(device.isValid()).setValidityReason(device.getValidityReason()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(device.getAndroidDevice()).build();
    }

    private PhysicalDevice(@NotNull Builder builder2) {
        super(builder2);
    }

    @Override
    @NotNull
    Icon getIcon() {
        return this.isValid() ? ourValidIcon : ourInvalidIcon;
    }

    @Override
    boolean isConnected() {
        return true;
    }

    @Override
    @Nullable
    Snapshot getSnapshot() {
        return null;
    }

    @Override
    boolean matches(@NotNull Key key) {
        return this.getKey().matches(key);
    }

    @Override
    boolean hasKeyContainedBy(@NotNull @NotNull Collection<@NotNull Key> keys) {
        return keys.contains(this.getKey()) || keys.contains(this.getKey().asNonprefixedKey());
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        IDevice device = this.getDdmlibDevice();
        assert (device != null);
        return DeploymentApplicationService.getInstance().getVersion(device);
    }

    @Override
    void addTo(@NotNull DeviceFutures futures2, @NotNull Project project) {
        futures2.getDevices().add(this.getAndroidDevice());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof PhysicalDevice)) {
            return false;
        }
        Device device = (Device)object;
        return this.getName().equals(device.getName()) && this.isValid() == device.isValid() && Objects.equals(this.getValidityReason(), device.getValidityReason()) && this.getKey().equals(device.getKey()) && Objects.equals(this.getConnectionTime(), device.getConnectionTime()) && this.getAndroidDevice().equals(device.getAndroidDevice());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isValid(), this.getValidityReason(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice());
    }

    @VisibleForTesting
    static final class Builder
    extends Device.Builder {
        Builder() {
        }

        @NotNull
        @VisibleForTesting
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        private Builder setValid(boolean valid2) {
            this.myValid = valid2;
            return this;
        }

        @NotNull
        private Builder setValidityReason(@Nullable String validityReason) {
            this.myValidityReason = validityReason;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            this.myConnectionTime = connectionTime;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @Override
        @NotNull
        PhysicalDevice build() {
            return new PhysicalDevice(this);
        }
    }
}

