/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.SwapInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibilityCheckerImpl
implements LaunchCompatibilityChecker {
    @NotNull
    @VisibleForTesting
    final AndroidVersion myMinSdkVersion;
    @NotNull
    private final IAndroidTarget myProjectTarget;
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final ExecutionEnvironment myEnvironment;
    @Nullable
    private final AndroidRunConfigurationBase myAndroidRunConfigurationBase;
    @NotNull
    private final Set<String> mySupportedAbis;

    public LaunchCompatibilityCheckerImpl(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget target, @NotNull AndroidFacet facet2, @Nullable ExecutionEnvironment environment, @Nullable AndroidRunConfigurationBase androidRunConfigurationBase, @NotNull Set<String> supportedAbis) {
        assert (environment == null && androidRunConfigurationBase == null || environment != null && androidRunConfigurationBase != null);
        this.myMinSdkVersion = minSdkVersion2;
        this.myProjectTarget = target;
        this.myEnvironment = environment;
        this.myAndroidRunConfigurationBase = androidRunConfigurationBase;
        this.myFacet = facet2;
        this.mySupportedAbis = supportedAbis;
    }

    @Override
    @Slow
    @NotNull
    public LaunchCompatibility validate(@NotNull AndroidDevice device) {
        SwapInfo swapInfo;
        LaunchCompatibility launchCompatibility = LaunchCompatibility.YES;
        if (this.myEnvironment != null && this.myAndroidRunConfigurationBase != null && (swapInfo = (SwapInfo)this.myEnvironment.getUserData(SwapInfo.SWAP_INFO_KEY)) != null) {
            if (device.getVersion().compareTo(26, null) < 0) {
                launchCompatibility = new LaunchCompatibility(ThreeState.NO, "The device needs to be running Oreo or newer.");
            } else if (!device.isRunning()) {
                launchCompatibility = new LaunchCompatibility(ThreeState.NO, "Please ensure the target device/emulator is running.");
            } else {
                try {
                    ApplicationIdProvider applicationIdProvider = this.myAndroidRunConfigurationBase.getApplicationIdProvider();
                    if (applicationIdProvider == null) {
                        return new LaunchCompatibility(ThreeState.NO, "Cannot get applicationId.");
                    }
                    Client client = ((IDevice)device.getLaunchedDevice().get()).getClient(applicationIdProvider.getPackageName());
                    if (client == null) {
                        launchCompatibility = new LaunchCompatibility(ThreeState.NO, "App not running on device. Please first install/run the app on the target device/emulator.");
                    }
                }
                catch (ApkProvisionException | InterruptedException | ExecutionException e) {
                    launchCompatibility = new LaunchCompatibility(ThreeState.NO, "Could not determine if device is compatible.");
                }
            }
        }
        return launchCompatibility.combine(device.canRun(this.myMinSdkVersion, this.myProjectTarget, this.myFacet, (Function<AndroidFacet, EnumSet<IDevice.HardwareFeature>>)((Function)LaunchCompatibilityCheckerImpl::getRequiredHardwareFeatures), this.mySupportedAbis));
    }

    @NotNull
    static EnumSet<IDevice.HardwareFeature> getRequiredHardwareFeatures(@NotNull AndroidFacet facet2) {
        if (LaunchUtils.isWatchFeatureRequired(facet2)) {
            return EnumSet.of(IDevice.HardwareFeature.WATCH);
        }
        return EnumSet.noneOf(IDevice.HardwareFeature.class);
    }

    @Nullable
    public static LaunchCompatibilityChecker create(@NotNull AndroidFacet facet2, @Nullable ExecutionEnvironment env, @Nullable AndroidRunConfigurationBase androidRunConfigurationBase) {
        AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
        if (platform == null) {
            return null;
        }
        AndroidModel androidModel = AndroidModel.get(facet2);
        if (androidModel == null) {
            return null;
        }
        AndroidVersion minSdkVersion2 = LaunchCompatibilityCheckerImpl.getMinSdkVersion(facet2);
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet2);
        Set supportedAbis = androidModuleModel != null ? androidModuleModel.getSelectedVariant().getMainArtifact().getAbiFilters() : Collections.emptySet();
        return new LaunchCompatibilityCheckerImpl(minSdkVersion2, platform.getTarget(), facet2, env, androidRunConfigurationBase, supportedAbis);
    }

    private static AndroidVersion getMinSdkVersion(@NotNull AndroidFacet facet2) {
        ListenableFuture<AndroidVersion> minSdkVersionFuture = AndroidModuleInfo.getInstance(facet2).getRuntimeMinSdkVersion();
        if (minSdkVersionFuture.isDone()) {
            try {
                return (AndroidVersion)minSdkVersionFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return AndroidVersion.DEFAULT;
    }
}

