/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.annotations.NotNull;

public class FileSystemApkProvider
implements ApkProvider {
    private final Module myModule;
    private final File myApkPath;

    public FileSystemApkProvider(@NotNull Module module2, @NotNull File apkFile) {
        this.myModule = module2;
        this.myApkPath = apkFile;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        String id = AndroidManifestUtils.getPackageName(this.myModule);
        if (id == null) {
            throw new ApkProvisionException("Invalid manifest, no package name specified");
        }
        ArrayList apkList = Lists.newArrayList();
        apkList.add(new ApkInfo(this.myApkPath, id));
        return apkList;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        return ImmutableList.of();
    }
}

