/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<Client> ANDROID_DEBUG_CLIENT = new Key("ANDROID_DEBUG_CLIENT");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final ProcessHandler myProcessHandler;
    private final RunContentDescriptor myDescriptor;
    @NotNull
    private final String myExecutorId;
    @NotNull
    private final String myExecutorActionName;
    @Nullable
    private final RunConfiguration myRunConfiguration;
    @NotNull
    private final ExecutionTarget myExecutionTarget;

    @NotNull
    public static AndroidSessionInfo create(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull String executorActionName, @NotNull ExecutionTarget executionTarget) {
        AndroidSessionInfo result2 = new AndroidSessionInfo(processHandler, descriptor2, runConfiguration, executorId, executorActionName, executionTarget);
        processHandler.putUserData(KEY, (Object)result2);
        return result2;
    }

    private AndroidSessionInfo(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull String executorActionName, @NotNull ExecutionTarget executionTarget) {
        this.myProcessHandler = processHandler;
        this.myDescriptor = descriptor2;
        this.myRunConfiguration = runConfiguration;
        this.myExecutorId = executorId;
        this.myExecutorActionName = executorActionName;
        this.myExecutionTarget = executionTarget;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public RunContentDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    public String getExecutorId() {
        return this.myExecutorId;
    }

    @Nullable
    public Executor getExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById(this.getExecutorId());
    }

    @NotNull
    public String getExecutorActionName() {
        return this.myExecutorActionName;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        return this.myExecutionTarget;
    }

    @Nullable
    public RunConfiguration getRunConfiguration() {
        return this.myRunConfiguration;
    }

    @Nullable
    public static AndroidSessionInfo findOldSession(@NotNull Project project, @Nullable Executor executor, @NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        List infos = Arrays.stream(ExecutionManager.getInstance((Project)project).getRunningProcesses()).filter(handler2 -> !handler2.isProcessTerminating() && !handler2.isProcessTerminated()).map(handler2 -> (AndroidSessionInfo)handler2.getUserData(KEY)).filter(info2 -> info2 != null && runConfiguration == info2.getRunConfiguration() && (executor == null || executor.getId().equals(info2.getExecutorId()))).collect(Collectors.toList());
        if (executionTarget instanceof AndroidExecutionTarget) {
            for (AndroidSessionInfo info3 : infos) {
                ExecutionTarget sessionExecutionTarget = info3.getExecutionTarget();
                if (!(sessionExecutionTarget instanceof AndroidExecutionTarget ? sessionExecutionTarget.getId().equals(executionTarget.getId()) : AndroidSessionInfo.checkIfIDeviceRunningInProcessHandler(runConfiguration, (AndroidExecutionTarget)executionTarget, info3.getProcessHandler()))) continue;
                return info3;
            }
            return null;
        }
        for (AndroidSessionInfo info4 : infos) {
            ExecutionTarget sessionExecutionTarget = info4.getExecutionTarget();
            if (sessionExecutionTarget instanceof AndroidExecutionTarget) {
                assert (info4.myRunConfiguration != null);
                if (!AndroidSessionInfo.checkIfIDeviceRunningInProcessHandler(info4.myRunConfiguration, (AndroidExecutionTarget)sessionExecutionTarget, info4.getProcessHandler())) continue;
                return info4;
            }
            return info4;
        }
        return null;
    }

    private static boolean checkIfIDeviceRunningInProcessHandler(@NotNull RunConfiguration runConfiguration, @NotNull AndroidExecutionTarget executionTarget, @NotNull ProcessHandler processHandler) {
        if (processHandler instanceof SwappableProcessHandler) {
            return ((SwappableProcessHandler)processHandler).isRunningWith(runConfiguration, executionTarget);
        }
        return false;
    }
}

