/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.resources.base.CommentTrackingXmlPullParser;
import com.android.tools.idea.resources.base.NamespaceResolver;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class ValueResourceXmlParser
extends CommentTrackingXmlPullParser {
    @NotNull
    final Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
    @NotNull
    final Deque<NamespaceResolver> resolverStack = new ArrayDeque<NamespaceResolver>(4);

    ValueResourceXmlParser() {
    }

    @NotNull
    public ResourceNamespace.Resolver getNamespaceResolver() throws XmlPullParserException {
        Preconditions.checkState((this.getEventType() == 2 ? 1 : 0) != 0);
        if (this.resolverStack.isEmpty()) {
            return ResourceNamespace.Resolver.EMPTY_RESOLVER;
        }
        NamespaceResolver resolver = this.resolverStack.getLast();
        return resolver.getNamespaceCount() == 0 ? ResourceNamespace.Resolver.EMPTY_RESOLVER : resolver;
    }

    @Override
    public void setInput(@NotNull Reader reader) throws XmlPullParserException {
        super.setInput(reader);
        this.resolverStack.clear();
    }

    @Override
    public void setInput(@NotNull InputStream inputStream, @Nullable String encoding) throws XmlPullParserException {
        super.setInput(inputStream, encoding);
        this.resolverStack.clear();
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        int token = super.nextToken();
        this.processToken(token);
        return token;
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        int token = super.next();
        this.processToken(token);
        return token;
    }

    private void processToken(int token) throws XmlPullParserException {
        switch (token) {
            case 2: {
                int namespaceCount = this.getNamespaceCount(this.getDepth());
                NamespaceResolver parent = this.resolverStack.isEmpty() ? null : this.resolverStack.getLast();
                NamespaceResolver current = parent != null && parent.getNamespaceCount() == namespaceCount ? parent : this.getOrCreateResolver();
                this.resolverStack.add(current);
                assert (this.resolverStack.size() == this.getDepth());
                break;
            }
            case 3: {
                this.resolverStack.removeLast();
            }
        }
    }

    private NamespaceResolver getOrCreateResolver() throws XmlPullParserException {
        return this.namespaceResolverCache.computeIfAbsent(new NamespaceResolver((XmlPullParser)this), Function.identity());
    }
}

