/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicTextValueResourceItem;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.android.utils.HashCodes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicValueResourceItem
extends BasicValueResourceItemBase {
    @Nullable
    private final String myValue;

    public BasicValueResourceItem(@NotNull ResourceType type, @NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @Nullable String value2) {
        super(type, name, sourceFile, visibility);
        this.myValue = value2;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myValue;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicValueResourceItem other = (BasicValueResourceItem)obj;
        return Objects.equals(this.myValue, other.myValue);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix((int)super.hashCode(), (int)Objects.hashCode(this.myValue));
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myValue);
        String rawXmlValue = this.getRawXmlValue();
        stream.writeString(Objects.equals(rawXmlValue, this.myValue) ? null : rawXmlValue);
    }

    @NotNull
    static BasicValueResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull ResourceType resourceType, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        String value2 = stream.readString();
        String rawXmlValue = stream.readString();
        BasicValueResourceItem item = rawXmlValue == null ? new BasicValueResourceItem(resourceType, name, sourceFile, visibility, value2) : new BasicTextValueResourceItem(resourceType, name, sourceFile, visibility, value2, rawXmlValue);
        item.setNamespaceResolver(resolver);
        return item;
    }
}

