/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicAttrResourceItem;
import com.android.tools.idea.resources.base.BasicResourceItemBase;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.LoadableResourceRepository;
import com.android.tools.idea.resources.base.RepositoryConfiguration;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicStyleableResourceItem
extends BasicValueResourceItemBase
implements StyleableResourceValue {
    @NotNull
    private final List<AttrResourceValue> myAttrs;

    public BasicStyleableResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull List<AttrResourceValue> attrs) {
        super(ResourceType.STYLEABLE, name, sourceFile, visibility);
        this.myAttrs = ImmutableList.copyOf(attrs);
    }

    @NotNull
    public List<AttrResourceValue> getAllAttributes() {
        return this.myAttrs;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicStyleableResourceItem other = (BasicStyleableResourceItem)obj;
        return this.myAttrs.equals(other.myAttrs);
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeInt(this.myAttrs.size());
        for (AttrResourceValue attr2 : this.myAttrs) {
            if (attr2 instanceof BasicAttrResourceItem && !attr2.getFormats().isEmpty()) {
                attr2 = ((BasicAttrResourceItem)attr2).createReference();
            }
            ((BasicValueResourceItemBase)attr2).serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        }
    }

    @NotNull
    static BasicStyleableResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver, @NotNull List<RepositoryConfiguration> configurations, @NotNull List<ResourceSourceFile> sourceFiles, @NotNull List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        LoadableResourceRepository repository = sourceFile.getRepository();
        int n = stream.readInt();
        ArrayList<AttrResourceValue> attrs = n == 0 ? Collections.emptyList() : new ArrayList<AttrResourceValue>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            BasicResourceItemBase attrItem = BasicStyleableResourceItem.deserialize(stream, configurations, sourceFiles, namespaceResolvers);
            if (!(attrItem instanceof AttrResourceValue)) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            AttrResourceValue attr2 = BasicStyleableResourceItem.getCanonicalAttr((AttrResourceValue)attrItem, (ResourceRepository)repository);
            attrs.add(attr2);
        }
        BasicStyleableResourceItem item = new BasicStyleableResourceItem(name, sourceFile, visibility, attrs);
        item.setNamespaceResolver(resolver);
        return item;
    }

    @NotNull
    public static AttrResourceValue getCanonicalAttr(@NotNull AttrResourceValue attr2, @NotNull ResourceRepository repository) {
        if (attr2.getFormats().isEmpty()) {
            List items2 = repository.getResources(attr2.getNamespace(), ResourceType.ATTR, attr2.getName());
            for (ResourceItem item : items2) {
                if (!(item instanceof AttrResourceValue) || !Objects.equals(((AttrResourceValue)item).getDescription(), attr2.getDescription()) || !Objects.equals(((AttrResourceValue)item).getGroupName(), attr2.getGroupName())) continue;
                return (AttrResourceValue)item;
            }
        }
        return attr2;
    }
}

