/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Base128InputStream
extends BufferedInputStream {
    @Nullable
    private Map<String, String> myStringCache;

    public Base128InputStream(@NotNull InputStream stream) {
        super(stream);
    }

    public Base128InputStream(@NotNull Path file2) throws IOException {
        super(Files.newInputStream(file2, new OpenOption[0]));
    }

    public void setStringCache(@Nullable Map<String, String> stringCache) {
        this.myStringCache = stringCache;
    }

    public int readInt() throws IOException {
        int b = super.read();
        if (b < 0) {
            throw StreamFormatException.prematureEndOfFile();
        }
        int value2 = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = super.read();
            if (b < 0) {
                throw StreamFormatException.prematureEndOfFile();
            }
            if (shift == 28 && (b & 0x70) != 0) {
                throw StreamFormatException.invalidFormat();
            }
            value2 |= (b & 0x7F) << shift;
            shift += 7;
        }
        return value2;
    }

    public long readLong() throws IOException, StreamFormatException {
        int b = super.read();
        if (b < 0) {
            throw StreamFormatException.prematureEndOfFile();
        }
        long value2 = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = super.read();
            if (b < 0) {
                throw StreamFormatException.prematureEndOfFile();
            }
            if (shift == 63 && (b & 0x7E) != 0) {
                throw StreamFormatException.invalidFormat();
            }
            value2 |= (long)(b & 0x7F) << shift;
            shift += 7;
        }
        return value2;
    }

    @Nullable
    public String readString() throws IOException, StreamFormatException {
        int len = this.readInt();
        if (len < 0) {
            throw StreamFormatException.invalidFormat();
        }
        if (len == 0) {
            return null;
        }
        if (--len == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(len);
        for (int i2 = 0; i2 < len; ++i2) {
            buf.append(this.readChar());
        }
        String str = buf.toString();
        return this.myStringCache == null ? str : this.myStringCache.computeIfAbsent(str, Function.identity());
    }

    public char readChar() throws IOException, StreamFormatException {
        int c = this.readInt();
        if ((c & 0xFFFF0000) != 0) {
            throw StreamFormatException.invalidFormat();
        }
        return (char)c;
    }

    public byte readByte() throws IOException {
        int b = super.read();
        if (b < 0) {
            throw StreamFormatException.prematureEndOfFile();
        }
        return (byte)b;
    }

    public final boolean readBoolean() throws IOException, StreamFormatException {
        int c = this.readInt();
        if ((c & 0xFFFFFFFE) != 0) {
            throw StreamFormatException.invalidFormat();
        }
        return c != 0;
    }

    @Override
    @Deprecated
    public int read() {
        throw new UnsupportedOperationException("This method is disabled to prevent unintended accidental use. Please use readByte or readInt instead.");
    }

    public boolean validateContents(@NotNull byte[] expected2) throws IOException {
        boolean result2 = true;
        for (byte b : expected2) {
            if (b == this.readByte()) continue;
            result2 = false;
        }
        return result2;
    }

    public static class StreamFormatException
    extends IOException {
        public StreamFormatException(@NotNull String message2) {
            super(message2);
        }

        public static StreamFormatException prematureEndOfFile() {
            return new StreamFormatException("Premature end of file");
        }

        public static StreamFormatException invalidFormat() {
            return new StreamFormatException("Invalid file format");
        }
    }
}

