/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.ModuleBasedClassFileFinder;
import com.android.tools.idea.projectsystem.ClassFileFinderUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class GradleClassFileFinder
extends ModuleBasedClassFileFinder {
    @NotNull
    private static final String CLASSES_FOLDER_NAME = "classes";
    @NotNull
    private static final String RESOURCES_FOLDER_NAME = "resources";
    @NotNull
    private static final String MAIN_FOLDER_NAME = "main";
    @NotNull
    private static final String TEST_FOLDER_NAME = "test";
    @NotNull
    private static final String KOTLIN_FOLDER_NAME = "kotlin";

    public GradleClassFileFinder(@NotNull Module module2) {
        super(module2);
    }

    @Override
    @Nullable
    protected VirtualFile findClassFileInModule(@NotNull Module module2, @NotNull String className2) {
        VirtualFile file2 = super.findClassFileInModule(module2, className2);
        if (file2 != null) {
            return file2;
        }
        for (VirtualFile outputDir : GradleClassFileFinder.getModuleCompileOutputs(module2)) {
            file2 = ClassFileFinderUtil.findClassFileInOutputRoot(outputDir, className2);
            if (file2 == null) continue;
            return file2;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getCompilerOutputRoots(@NotNull AndroidModuleModel model2) {
        VirtualFile file2;
        File outFolder;
        File file3;
        IdeVariant variant2 = model2.getSelectedVariant();
        String variantName = variant2.getName();
        IdeAndroidArtifact mainArtifactInfo = model2.getMainArtifact();
        File classesFolder = mainArtifactInfo.getClassesFolder();
        ImmutableList.Builder compilerOutputs = new ImmutableList.Builder();
        if (classesFolder == null && (file3 = GradleUtil.getOutputFile(model2)) != null) {
            File buildFolder = file3.getParentFile().getParentFile();
            classesFolder = new File(buildFolder, CLASSES_FOLDER_NAME);
        }
        if (classesFolder != null && (outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (file2 = VfsUtil.findFileByIoFile((File)outFolder, (boolean)true)) != null) {
            compilerOutputs.add((Object)file2);
        }
        for (File additionalFolder : mainArtifactInfo.getAdditionalClassesFolders()) {
            VirtualFile file4 = VfsUtil.findFileByIoFile((File)additionalFolder, (boolean)true);
            if (file4 == null) continue;
            compilerOutputs.add((Object)file4);
        }
        return compilerOutputs.build();
    }

    @NotNull
    private static Collection<File> getJavaAndKotlinCompilerOutputFolders(@NotNull JavaModuleModel javaModel, boolean includeProduction, boolean includeTests) {
        LinkedList<File> toAdd = new LinkedList<File>();
        File mainClassesFolderPath = null;
        File mainResourcesFolderPath = null;
        File testClassesFolderPath = null;
        File testResourcesFolderPath = null;
        File mainKotlinClassesFolderPath = null;
        File testKotlinClassesFolderPath = null;
        ExtIdeaCompilerOutput compilerOutput = javaModel.getCompilerOutput();
        if (compilerOutput != null) {
            mainClassesFolderPath = compilerOutput.getMainClassesDir();
            mainResourcesFolderPath = compilerOutput.getMainResourcesDir();
            testClassesFolderPath = compilerOutput.getTestClassesDir();
            testResourcesFolderPath = compilerOutput.getTestResourcesDir();
        }
        File buildFolderPath = javaModel.getBuildFolderPath();
        if (javaModel.isBuildable()) {
            if (mainClassesFolderPath == null) {
                mainClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (mainResourcesFolderPath == null) {
                mainResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, MAIN_FOLDER_NAME}));
            }
            if (testClassesFolderPath == null) {
                testClassesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
            if (testResourcesFolderPath == null) {
                testResourcesFolderPath = new File(buildFolderPath, FileUtil.join((String[])new String[]{RESOURCES_FOLDER_NAME, TEST_FOLDER_NAME}));
            }
        }
        if (buildFolderPath != null) {
            File kotlinClasses = buildFolderPath.toPath().resolve(CLASSES_FOLDER_NAME).resolve(KOTLIN_FOLDER_NAME).toFile();
            if (includeTests) {
                testKotlinClassesFolderPath = new File(kotlinClasses, TEST_FOLDER_NAME);
            }
            if (includeProduction) {
                mainKotlinClassesFolderPath = new File(kotlinClasses, MAIN_FOLDER_NAME);
            }
        }
        if (includeTests) {
            if (testClassesFolderPath != null) {
                toAdd.add(testClassesFolderPath);
            }
            if (testKotlinClassesFolderPath != null) {
                toAdd.add(testKotlinClassesFolderPath);
            }
            if (testResourcesFolderPath != null) {
                toAdd.add(testResourcesFolderPath);
            }
        }
        if (includeProduction) {
            if (mainClassesFolderPath != null) {
                toAdd.add(mainClassesFolderPath);
            }
            if (mainKotlinClassesFolderPath != null) {
                toAdd.add(mainKotlinClassesFolderPath);
            }
            if (mainResourcesFolderPath != null) {
                toAdd.add(mainResourcesFolderPath);
            }
        }
        return toAdd;
    }

    @NotNull
    private static Collection<VirtualFile> getModuleCompileOutputs(@NotNull Module module2) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel != null) {
            return GradleClassFileFinder.getCompilerOutputRoots(androidModel);
        }
        JavaModuleModel javaModel = JavaModuleModel.get(module2);
        if (javaModel != null) {
            return GradleClassFileFinder.getJavaAndKotlinCompilerOutputFolders(javaModel, true, false).stream().map(path2 -> VfsUtil.findFileByIoFile((File)path2, (boolean)true)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }
}

