/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.utils.SdkUtils;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class FileCaptureType
extends CaptureType {
    @NotNull
    private String myName;
    @NotNull
    private Icon myIcon;
    @NotNull
    private String myFileNameExtension;

    protected FileCaptureType(@NotNull String name, @NotNull Icon icon2, @NotNull String fileNameExtension) {
        this.myName = name;
        this.myIcon = icon2;
        this.myFileNameExtension = fileNameExtension;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @NotNull
    public String getCaptureExtension() {
        return this.myFileNameExtension;
    }

    @Override
    public boolean isValidCapture(@NotNull VirtualFile file2) {
        return this.isValidCapture(file2.getPath());
    }

    public boolean isValidCapture(@NotNull String filePath) {
        return SdkUtils.endsWithIgnoreCase((String)filePath, (String)this.myFileNameExtension);
    }

    @Override
    @NotNull
    protected Capture createCapture(@NotNull VirtualFile file2) {
        return new Capture(file2, this);
    }
}

