/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.StudioLegacyAllocationTracker;
import com.android.tools.idea.profilers.StudioLegacyCpuTraceProfiler;
import com.android.tools.idea.profilers.commands.GcCommandHandler;
import com.android.tools.idea.profilers.commands.LegacyAllocationCommandHandler;
import com.android.tools.idea.profilers.commands.LegacyCpuTraceCommandHandler;
import com.android.tools.idea.profilers.perfd.CpuServiceProxy;
import com.android.tools.idea.profilers.perfd.EnergyServiceProxy;
import com.android.tools.idea.profilers.perfd.EventServiceProxy;
import com.android.tools.idea.profilers.perfd.MemoryServiceProxy;
import com.android.tools.idea.profilers.perfd.NetworkServiceProxy;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxy;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class ProfilerServiceProxyManager {
    @NotNull
    private static final String MEMORY_PROXY_EXECUTOR_NAME = "MemoryAllocationDataFetchExecutor";

    public static void registerProxies(TransportProxy transportProxy) {
        IDevice device = transportProxy.getDevice();
        ManagedChannel transportChannel = transportProxy.getTransportChannel();
        transportProxy.registerProxyService(new ProfilerServiceProxy(transportChannel));
        transportProxy.registerProxyService(new EventServiceProxy(device, transportChannel));
        transportProxy.registerProxyService(new CpuServiceProxy(device, transportChannel, new StudioLegacyCpuTraceProfiler(device, CpuServiceGrpc.newBlockingStub((Channel)transportChannel), TransportServiceGrpc.newBlockingStub((Channel)transportChannel), transportProxy.getBytesCache())));
        transportProxy.registerProxyService(new MemoryServiceProxy(device, transportChannel, Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(MEMORY_PROXY_EXECUTOR_NAME).build()), (d, p) -> new StudioLegacyAllocationTracker((IDevice)d, (int)p), transportProxy.getBytesCache()));
        transportProxy.registerProxyService(new NetworkServiceProxy(transportChannel));
        transportProxy.registerProxyService(new EnergyServiceProxy(transportChannel));
    }

    public static void registerCommandHandlers(TransportProxy transportProxy) {
        IDevice device = transportProxy.getDevice();
        ManagedChannel transportChannel = transportProxy.getTransportChannel();
        GcCommandHandler gcCommandHandler = new GcCommandHandler(device);
        transportProxy.registerProxyCommandHandler(Commands.Command.CommandType.GC, gcCommandHandler);
        if (!((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue() || device.getVersion().getFeatureLevel() < 26) {
            LegacyAllocationCommandHandler trackAllocationHandler = new LegacyAllocationCommandHandler(device, transportProxy.getEventQueue(), transportProxy.getBytesCache(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(MEMORY_PROXY_EXECUTOR_NAME).build()), (d, p) -> new StudioLegacyAllocationTracker((IDevice)d, (int)p));
            transportProxy.registerProxyCommandHandler(Commands.Command.CommandType.START_ALLOC_TRACKING, trackAllocationHandler);
            transportProxy.registerProxyCommandHandler(Commands.Command.CommandType.STOP_ALLOC_TRACKING, trackAllocationHandler);
        }
        if (device.getVersion().getFeatureLevel() < 26) {
            LegacyCpuTraceCommandHandler cpuTraceHandler = new LegacyCpuTraceCommandHandler(device, TransportServiceGrpc.newBlockingStub((Channel)transportChannel), transportProxy.getEventQueue(), transportProxy.getBytesCache());
            transportProxy.registerProxyCommandHandler(Commands.Command.CommandType.START_CPU_TRACE, cpuTraceHandler);
            transportProxy.registerProxyCommandHandler(Commands.Command.CommandType.STOP_CPU_TRACE, cpuTraceHandler);
        }
    }
}

