/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.dataviewer;

import com.android.tools.idea.profilers.ResizableImage;
import com.android.tools.profilers.dataviewer.ImageDataViewer;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijImageDataViewer
implements ImageDataViewer {
    @NotNull
    private final BufferedImage myImage;
    @NotNull
    private final JComponent myComponent;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static IntellijImageDataViewer createImageViewer(@NotNull byte[] content2) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content2);){
            BufferedImage image = ImageIO.read(inputStream);
            if (image == null) {
                IntellijImageDataViewer intellijImageDataViewer2 = null;
                return intellijImageDataViewer2;
            }
            IntellijImageDataViewer intellijImageDataViewer = new IntellijImageDataViewer(image);
            return intellijImageDataViewer;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IntellijImageDataViewer(@NotNull BufferedImage image) {
        this.myImage = image;
        this.myComponent = new ResizableImage(image);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public BufferedImage getImage() {
        return this.myImage;
    }
}

