/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.capture;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.capture.AndroidProfilerCaptureEditor;
import com.google.common.base.Strings;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class AndroidProfilerCaptureEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        String extension = file2.getExtension();
        return !Strings.isNullOrEmpty((String)extension) && (extension.equals("trace") || extension.equals("alloc") || extension.equals("hprof") || (Boolean)StudioFlags.PROFILER_ENABLE_NATIVE_SAMPLE.get() != false && extension.equals("heapprofd"));
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        return new AndroidProfilerCaptureEditor(project, file2);
    }

    @NotNull
    public String getEditorTypeId() {
        return "AndroidProfilerCaptureEditorProvider";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

