/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.google.common.collect.ImmutableMap;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceSignatureConverter {
    private static final Map<PsiType, Character> PRIMITIVE_TYPES = new ImmutableMap.Builder().put((Object)PsiType.BYTE, (Object)Character.valueOf('B')).put((Object)PsiType.CHAR, (Object)Character.valueOf('C')).put((Object)PsiType.DOUBLE, (Object)Character.valueOf('D')).put((Object)PsiType.FLOAT, (Object)Character.valueOf('F')).put((Object)PsiType.INT, (Object)Character.valueOf('I')).put((Object)PsiType.LONG, (Object)Character.valueOf('J')).put((Object)PsiType.SHORT, (Object)Character.valueOf('S')).put((Object)PsiType.BOOLEAN, (Object)Character.valueOf('Z')).put((Object)PsiType.VOID, (Object)Character.valueOf('V')).build();

    @Nullable
    private static String convertToString(@NotNull PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            return '[' + TraceSignatureConverter.convertToString(((PsiArrayType)psiType).getComponentType());
        }
        if (psiType instanceof PsiPrimitiveType) {
            return String.valueOf(PRIMITIVE_TYPES.get(psiType));
        }
        if (psiType instanceof PsiClassType) {
            return "L" + psiType.getCanonicalText().replaceAll("\\.", "/") + ";";
        }
        return null;
    }

    @NotNull
    public static String getTraceSignature(@NotNull PsiMethod method2) {
        StringBuilder signature = new StringBuilder("(");
        for (PsiType type : method2.getSignature(PsiSubstitutor.EMPTY).getParameterTypes()) {
            String converted = TraceSignatureConverter.convertToString(TypeConversionUtil.erasure((PsiType)type));
            signature.append(converted);
        }
        signature.append(")");
        PsiType returnType = method2.getReturnType();
        if (returnType != null) {
            String converted = TraceSignatureConverter.convertToString(TypeConversionUtil.erasure((PsiType)returnType));
            signature.append(converted);
        }
        return signature.toString();
    }
}

