/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.profilers.ExportDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class IntellijExportDialog
implements ExportDialog {
    private final Project myProject;

    public IntellijExportDialog(@NotNull Project project) {
        this.myProject = project;
    }

    public void open(@NotNull Supplier<String> dialogTitleSupplier, @NotNull Supplier<String> fileNameSupplier, @NotNull Supplier<String> extensionSupplier, @NotNull Consumer<File> saveToFile) {
        ApplicationManager.getApplication().invokeLater(() -> {
            String extension = (String)extensionSupplier.get();
            if (extension != null) {
                String fileName;
                VirtualFile outputDir = this.myProject.getBaseDir();
                if (outputDir == null || !outputDir.exists()) {
                    outputDir = VfsUtil.getUserHomeDir();
                }
                FileSaverDescriptor descriptor2 = new FileSaverDescriptor((String)dialogTitleSupplier.get(), "Save as *." + extension, new String[]{extension});
                FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProject);
                VirtualFileWrapper result2 = saveFileDialog.save(outputDir, fileName = (String)fileNameSupplier.get() + (SystemInfo.isMac ? "." + extension : ""));
                if (result2 == null) {
                    return;
                }
                saveToFile.accept(result2.getFile());
            }
        });
    }
}

