/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.PreferredProcessInfo;
import com.android.tools.idea.profilers.analytics.StudioFeatureTracker;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import io.grpc.StatusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidProfilerLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    private static final String STARTUP_AGENT_CONFIG_NAME = "startupagent.config";

    private static Logger getLogger() {
        return Logger.getInstance(AndroidProfilerLaunchTaskContributor.class);
    }

    @Override
    @NotNull
    public LaunchTask getTask(@NotNull Module module2, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions) {
        return new AndroidProfilerToolWindowLaunchTask(module2.getProject(), launchOptions, AndroidProfilerToolWindow.getModuleName(module2));
    }

    @NotNull
    public static String getAmStartOptions(@NotNull Project project, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions, @NotNull IDevice device) {
        Common.Device profilerDevice;
        if (!AndroidProfilerLaunchTaskContributor.isProfilerLaunch(launchOptions)) {
            return "";
        }
        ProfilerState profilerState = AndroidProfilerLaunchTaskContributor.getProfilerStateFromCurrentRun(launchOptions, project);
        if (profilerState == null) {
            return "";
        }
        TransportService transportService = TransportService.getInstance();
        if (transportService == null) {
            return "";
        }
        ProfilerClient client = new ProfilerClient("DataStoreService");
        try {
            profilerDevice = AndroidProfilerLaunchTaskContributor.waitForDaemon(device, client);
        }
        catch (TimeoutException | InterruptedException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
            return "";
        }
        TransportFileManager fileManager = new TransportFileManager(device, transportService.getMessageBus());
        AndroidProfilerLaunchTaskContributor.pushStartupAgentConfig(fileManager, project);
        String agentArgs = fileManager.configureStartupAgent(applicationId2, STARTUP_AGENT_CONFIG_NAME);
        String startupProfilingResult = AndroidProfilerLaunchTaskContributor.startStartupProfiling(profilerState, applicationId2, project, client, device, profilerDevice);
        return String.format("%s %s", agentArgs, startupProfilingResult);
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull Module module2, @NotNull String applicationId2, @NotNull LaunchOptions launchOptions, @NotNull IDevice device) {
        return AndroidProfilerLaunchTaskContributor.getAmStartOptions(module2.getProject(), applicationId2, launchOptions, device);
    }

    private static void pushStartupAgentConfig(@NotNull TransportFileManager fileManager, @NotNull Project project) {
        try {
            fileManager.pushAgentConfig(STARTUP_AGENT_CONFIG_NAME, AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(project));
        }
        catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (AdbCommandRejectedException | IOException e) {
            AndroidProfilerLaunchTaskContributor.getLogger().warn("Error when trying to push AgentConfig:", e);
        }
    }

    @NotNull
    private static String startStartupProfiling(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device, @NotNull Common.Device profilerDevice) {
        if (profilerState.isCpuStartupProfilingEnabled()) {
            return AndroidProfilerLaunchTaskContributor.triggerCpuStartupProfilingAndReturnArtParams(profilerState, appPackageName, project, client, device, profilerDevice);
        }
        if (profilerState.isNativeMemoryStartupProfilingEnabled()) {
            AndroidProfilerLaunchTaskContributor.triggerMemoryStartupProfiling(profilerState, appPackageName, project, client, device, profilerDevice);
        }
        return "";
    }

    private static void triggerMemoryStartupProfiling(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device, @NotNull Common.Device profilerDevice) {
        if (!AndroidProfilerLaunchTaskContributor.isAtLeast(device, 29)) {
            AndroidNotification.getInstance(project).showBalloon("Startup Native Memory Profiling", "Starting a native memory sampling trace recording on startup is only supported on devices with API levels 28 and higher.", NotificationType.WARNING);
            return;
        }
        if (device.getAbis().isEmpty()) {
            AndroidNotification.getInstance(project).showBalloon("Startup Native Memory Profiling", "Unable to detect device abi for startup memory profiling.", NotificationType.WARNING);
            return;
        }
        if (device.getAbis().contains("x86") || device.getAbis().contains("x86_64")) {
            AndroidNotification.getInstance(project).showBalloon("Startup Native Memory Profiling", "Native memory profiling not supported on x86 and x86_64 devices.", NotificationType.WARNING);
            return;
        }
        String abi = (String)device.getAbis().get(0);
        StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
        featureTracker.trackRecordAllocations();
        String traceFilePath = String.format(Locale.US, "%s/%s.trace", "/data/local/tmp/perfd", appPackageName);
        Commands.Command sampleCommand = Commands.Command.newBuilder().setStreamId(profilerDevice.getDeviceId()).setType(Commands.Command.CommandType.START_NATIVE_HEAP_SAMPLE).setStartNativeSample(Memory.StartNativeSample.newBuilder().setSamplingIntervalBytes(profilerState.NATIVE_MEMORY_SAMPLE_RATE_BYTES).setSharedMemoryBufferBytes(0x4000000).setAbiCpuArch(abi).setTempPath(traceFilePath).setAppName(appPackageName)).build();
        Transport.ExecuteResponse response = client.getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(sampleCommand).build());
    }

    private static String triggerCpuStartupProfilingAndReturnArtParams(@NotNull ProfilerState profilerState, @NotNull String appPackageName, @NotNull Project project, @NotNull ProfilerClient client, @NotNull IDevice device, @NotNull Common.Device profilerDevice) {
        String configName = profilerState.STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        if (configName == null) {
            return "";
        }
        CpuProfilerConfig startupConfig = CpuProfilerConfigsState.getInstance(project).getConfigByName(configName);
        if (startupConfig == null) {
            return "";
        }
        if (!AndroidProfilerLaunchTaskContributor.isAtLeast(device, 26)) {
            AndroidNotification.getInstance(project).showBalloon("Startup CPU Profiling", "Starting a method trace recording on startup is only supported on devices with API levels 26 and higher.", NotificationType.WARNING);
            return "";
        }
        String cpuAbi = "";
        switch (startupConfig.getTechnology()) {
            case SAMPLED_NATIVE: {
                cpuAbi = AndroidProfilerLaunchTaskContributor.getAbiDependentLibraryName("simpleperf", "simpleperf", device);
                break;
            }
            case SYSTEM_TRACE: {
                cpuAbi = AndroidProfilerLaunchTaskContributor.getAbiDependentLibraryName("perfetto", "perfetto", device);
                break;
            }
        }
        String traceFilePath = String.format(Locale.US, "%s/%s-%d.trace", "/data/local/tmp/perfd", appPackageName, System.nanoTime());
        Cpu.CpuTraceConfiguration.UserOptions traceOptions = CpuProfilerConfigConverter.toProto(startupConfig, device.getVersion().getFeatureLevel());
        Cpu.CpuTraceConfiguration configuration = Cpu.CpuTraceConfiguration.newBuilder().setAppName(appPackageName).setInitiationType(Cpu.TraceInitiationType.INITIATED_BY_STARTUP).setAbiCpuArch(cpuAbi).setTempPath(traceFilePath).setUserOptions(traceOptions).build();
        try {
            CpuProfiler.StartupProfilingResponse startupProfilingResponse;
            if (((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()).booleanValue()) {
                Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(profilerDevice.getDeviceId()).setType(Commands.Command.CommandType.START_CPU_TRACE).setStartCpuTrace(Cpu.StartCpuTrace.newBuilder().setConfiguration(configuration).build()).build();
                startupProfilingResponse = client.getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(startCommand).build());
            } else {
                CpuProfiler.StartupProfilingRequest.Builder requestBuilder = CpuProfiler.StartupProfilingRequest.newBuilder().setDeviceId(profilerDevice.getDeviceId()).setConfiguration(configuration);
                startupProfilingResponse = client.getCpuClient().startStartupProfiling(requestBuilder.build());
            }
        }
        catch (StatusRuntimeException exception) {
            AndroidProfilerLaunchTaskContributor.getLogger().error((Throwable)exception);
        }
        StudioFeatureTracker featureTracker = new StudioFeatureTracker(project);
        featureTracker.trackCpuStartupProfiling(profilerDevice, ProfilingConfiguration.fromProto((Cpu.CpuTraceConfiguration.UserOptions)traceOptions));
        if (traceOptions.getTraceType() != Cpu.CpuTraceType.ART) {
            return "";
        }
        StringBuilder argsBuilder = new StringBuilder("--start-profiler ").append(traceFilePath);
        if (startupConfig.getTechnology() == CpuProfilerConfig.Technology.SAMPLED_JAVA) {
            argsBuilder.append(" --sampling ").append(startupConfig.getSamplingIntervalUs());
        }
        argsBuilder.append(" --streaming");
        return argsBuilder.toString();
    }

    private static boolean isAtLeast(@NotNull IDevice device, int version2) {
        return device.getVersion().getFeatureLevel() >= version2;
    }

    @Nullable
    private static ProfilerState getProfilerStateFromCurrentRun(@NotNull LaunchOptions launchOptions, Project project) {
        AndroidRunConfigurationBase runConfig = AndroidProfilerLaunchTaskContributor.getSelectedRunConfiguration(project);
        if (runConfig != null) {
            return runConfig.getProfilerState();
        }
        Object stateFromExtraOptions = launchOptions.getExtraOption("android.profilers.state");
        if (stateFromExtraOptions instanceof ProfilerState) {
            return (ProfilerState)stateFromExtraOptions;
        }
        return null;
    }

    @Nullable
    private static AndroidRunConfigurationBase getSelectedRunConfiguration(@NotNull Project project) {
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings != null && settings.getConfiguration() instanceof AndroidRunConfigurationBase) {
            return (AndroidRunConfigurationBase)settings.getConfiguration();
        }
        return null;
    }

    @NotNull
    private static Common.Device waitForDaemon(@NotNull IDevice device, @NotNull ProfilerClient client) throws InterruptedException, TimeoutException {
        for (int i2 = 0; i2 < 60; ++i2) {
            Common.Device profilerDevice = AndroidProfilerLaunchTaskContributor.getProfilerDevice(device, client);
            if (!Common.Device.getDefaultInstance().equals((Object)profilerDevice)) {
                return profilerDevice;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        throw new TimeoutException("Timeout waiting for daemon");
    }

    @NotNull
    private static Common.Device getProfilerDevice(@NotNull IDevice device, @NotNull ProfilerClient client) {
        List devices2 = StudioProfilers.getUpToDateDevices((boolean)((Boolean)StudioFlags.PROFILER_UNIFIED_PIPELINE.get()), (ProfilerClient)client, null, null);
        for (Common.Device profilerDevice : devices2) {
            if (!profilerDevice.getSerial().equals(device.getSerialNumber()) || profilerDevice.getState() != Common.Device.State.ONLINE) continue;
            return profilerDevice;
        }
        return Common.Device.getDefaultInstance();
    }

    @NotNull
    private static String getAbiDependentLibraryName(String dir, String fileName, IDevice device) {
        return AndroidProfilerLaunchTaskContributor.getBestAbiCpuArch(device, "plugins/android/resources/" + dir, "../../prebuilts/tools/common/" + dir, fileName);
    }

    @NotNull
    private static String getBestAbiCpuArch(@NotNull IDevice device, @NotNull String releaseDir, @NotNull String devDir, @NotNull String fileName) {
        File dir = new File(PathManager.getHomePath(), releaseDir);
        if (!dir.exists()) {
            dir = new File(PathManager.getHomePath(), devDir);
        }
        for (String abi : device.getAbis()) {
            File candidate = new File(dir, abi + "/" + fileName);
            if (!candidate.exists()) continue;
            return Abi.getEnum((String)abi).getCpuArch();
        }
        return "";
    }

    public static boolean isProfilerLaunch(@NotNull LaunchOptions options2) {
        Object launchValue = options2.getExtraOption("isProfiling");
        return launchValue instanceof Boolean && (Boolean)launchValue != false;
    }

    public static final class AndroidProfilerToolWindowLaunchTask
    implements LaunchTask {
        private static final String ID = "PROFILER_TOOLWINDOW";
        @NotNull
        private final Project myProject;
        @NotNull
        private final LaunchOptions myLaunchOptions;
        @Nullable
        private final String myTargetProcessName;

        public AndroidProfilerToolWindowLaunchTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @Nullable String targetProcessName) {
            this.myProject = project;
            this.myLaunchOptions = launchOptions;
            this.myTargetProcessName = targetProcessName;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Launching the Profiler Tool Window";
        }

        @Override
        public int getDuration() {
            return 2;
        }

        @Override
        public LaunchResult run(@NotNull LaunchContext launchContext) {
            IDevice device = launchContext.getDevice();
            long currentDeviceTimeNs = AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions) ? this.getCurrentDeviceTime(device) : Long.MIN_VALUE;
            ApplicationManager.getApplication().invokeLater(() -> {
                ToolWindow window2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Android Profiler");
                if (window2 != null) {
                    AndroidProfilerToolWindow profilerToolWindow;
                    window2.setShowStripeButton(true);
                    String deviceName = AndroidProfilerToolWindow.getDeviceDisplayName(device);
                    PreferredProcessInfo preferredProcessInfo = new PreferredProcessInfo(deviceName, this.myTargetProcessName, (Function1<? super Common.Process, Boolean>)((Function1)p -> p.getStartTimestampNs() >= currentDeviceTimeNs));
                    boolean profileStarted = false;
                    if (window2.isVisible() && (profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(this.myProject)) != null) {
                        profilerToolWindow.profile(preferredProcessInfo);
                        profileStarted = true;
                    }
                    if (!profileStarted) {
                        this.myProject.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, (Object)preferredProcessInfo);
                    }
                }
            });
            LaunchStatus launchStatus = launchContext.getLaunchStatus();
            if (launchStatus instanceof ProcessHandlerLaunchStatus) {
                final ProcessHandler processHandler = ((ProcessHandlerLaunchStatus)launchStatus).getProcessHandler();
                ProcessAdapter adapter = new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        myProject.putUserData(AndroidProfilerToolWindow.LAST_RUN_APP_INFO, null);
                        processHandler.removeProcessListener((ProcessListener)this);
                    }
                };
                processHandler.addProcessListener((ProcessListener)adapter);
            }
            return LaunchResult.success();
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        private long getCurrentDeviceTime(@NotNull IDevice device) {
            assert (AndroidProfilerLaunchTaskContributor.isProfilerLaunch(this.myLaunchOptions));
            long startTimeNs = Long.MIN_VALUE;
            TransportService transportService = TransportService.getInstance();
            if (transportService == null) {
                return startTimeNs;
            }
            ProfilerClient client = new ProfilerClient("DataStoreService");
            long deviceId = -1L;
            try {
                deviceId = AndroidProfilerLaunchTaskContributor.waitForDaemon(device, client).getDeviceId();
            }
            catch (TimeoutException | InterruptedException e) {
                AndroidProfilerLaunchTaskContributor.getLogger().debug(e);
            }
            try {
                Transport.TimeResponse timeResponse = client.getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(deviceId).build());
                if (!Transport.TimeResponse.getDefaultInstance().equals((Object)timeResponse)) {
                    startTimeNs = timeResponse.getTimestampNs();
                }
            }
            catch (StatusRuntimeException exception) {
                AndroidProfilerLaunchTaskContributor.getLogger().error((Throwable)exception);
            }
            return startTimeNs;
        }
    }
}

