/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateIconsModel
extends WizardModel {
    @Nullable
    private IconGenerator myIconGenerator;
    @NotNull
    private AndroidModulePaths myPaths;
    @NotNull
    private List<File> myFilesToDelete = ImmutableList.of();
    @NotNull
    private final StateStorage myStateStorage;
    @NotNull
    private final String myWizardId;

    public GenerateIconsModel(@NotNull AndroidFacet androidFacet, @NotNull String wizardId, @NotNull AndroidModulePaths paths) {
        this.myPaths = paths;
        Project project = androidFacet.getModule().getProject();
        this.myStateStorage = (StateStorage)ServiceManager.getService((Project)project, StateStorage.class);
        assert (this.myStateStorage != null);
        this.myWizardId = wizardId;
    }

    public void setIconGenerator(@NotNull IconGenerator iconGenerator) {
        this.myIconGenerator = iconGenerator;
    }

    @Nullable
    public IconGenerator getIconGenerator() {
        return this.myIconGenerator;
    }

    public void setPaths(@NotNull AndroidModulePaths paths) {
        this.myPaths = paths;
    }

    public void setFilesToDelete(@NotNull List<File> files2) {
        this.myFilesToDelete = ImmutableList.copyOf(files2);
    }

    @NotNull
    public AndroidModulePaths getPaths() {
        return this.myPaths;
    }

    @Override
    protected void handleFinished() {
        if (this.myIconGenerator == null) {
            GenerateIconsModel.getLog().error("GenerateIconsModel did not collect expected information and will not complete. Please report this error.");
            return;
        }
        this.myIconGenerator.generateIconsToDisk(this.myPaths);
        for (File file2 : this.myFilesToDelete) {
            file2.delete();
        }
    }

    @NotNull
    public PersistentState getPersistentState() {
        return this.myStateStorage.getState().getOrCreateChild(this.myWizardId);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(GenerateIconsModel.class);
    }

    @State(name="WizardSettings", storages={@Storage(value="assetWizardSettings.xml")})
    public static class StateStorage
    implements PersistentStateComponent<PersistentState> {
        private PersistentState myState;

        @NotNull
        public PersistentState getState() {
            if (this.myState == null) {
                this.myState = new PersistentState();
            }
            return this.myState;
        }

        public void loadState(@NotNull PersistentState state) {
            this.myState = state;
        }

        @NotNull
        public static StateStorage getInstance(@NotNull Project project) {
            return (StateStorage)ServiceManager.getService((Project)project, StateStorage.class);
        }
    }
}

