/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationIconGenerator
extends IconGenerator {
    private static final Dimension ICON_SIZE = new Dimension(24, 24);

    public NotificationIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer2));
    }

    @Override
    @NotNull
    public IconGenerator.IconOptions createOptions(boolean forPreview) {
        IconGenerator.IconOptions options2 = new IconGenerator.IconOptions(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            double paddingFactor = (double)((Integer)asset.paddingPercent().get()).intValue() / 100.0 + 1.0 / (double)(NotificationIconGenerator.ICON_SIZE.width - 1);
            double scaleFactor = 1.0 / (1.0 + paddingFactor * 2.0);
            options2.image = new TransformedImageAsset(asset, ICON_SIZE, scaleFactor, Color.WHITE, this.getGraphicGeneratorContext(), this.myLineSeparator);
        }
        return options2;
    }

    @Override
    @NotNull
    public AnnotatedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.IconOptions options2) {
        return this.generateRasterImage(ICON_SIZE, options2);
    }

    @Override
    protected int calculateMinRequiredApiLevel(@NotNull String xmlDrawableText, int minSdk) {
        if (minSdk < 24) {
            return 24;
        }
        return 0;
    }
}

