/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkClass;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.smali.SmaliIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassNode
extends ProjectViewNode<ApkClass> {
    @NotNull
    private final ApkClass myClass;
    @NotNull
    private final DexSourceFiles myDexSourceFiles;

    ClassNode(@NotNull Project project, @NotNull ApkClass apkClass, @NotNull ViewSettings settings, @NotNull DexSourceFiles dexSourceFiles) {
        super(project, (Object)apkClass, settings);
        this.myClass = apkClass;
        this.myDexSourceFiles = dexSourceFiles;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        return Collections.emptyList();
    }

    protected void update(@NotNull PresentationData presentation) {
        Icon icon2 = SmaliIcons.SmaliFile;
        if (this.myDexSourceFiles.findJavaPsiClass(this.myClass.getFqn()) != null) {
            icon2 = PlatformIcons.CLASS_ICON;
        }
        presentation.setIcon(icon2);
        presentation.setPresentableText(this.getText());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getText();
    }

    @NotNull
    private String getText() {
        return this.myClass.getName();
    }

    public void navigate(boolean requestFocus) {
        if (this.canNavigate()) {
            assert (this.myProject != null);
            String fqn = this.myClass.getFqn();
            if (this.myDexSourceFiles.navigateToJavaFile(fqn)) {
                return;
            }
            VirtualFile smaliFile = this.myDexSourceFiles.findSmaliFile(fqn);
            if (smaliFile != null) {
                FileEditorManager.getInstance((Project)this.myProject).openFile(smaliFile, requestFocus);
            }
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canRepresent(Object element2) {
        VirtualFile file2;
        if (element2 instanceof VirtualFile) {
            return this.contains((VirtualFile)element2);
        }
        if (element2 instanceof PsiClass) {
            return this.canRepresent((PsiClass)element2);
        }
        if (element2 instanceof PsiMethod) {
            PsiClass containingClass = ((PsiMethod)element2).getContainingClass();
            if (containingClass != null) {
                return this.canRepresent(containingClass);
            }
        } else if (element2 instanceof PsiElement && (file2 = ClassNode.getContainingFile((PsiElement)element2)) != null) {
            return this.contains(file2);
        }
        return false;
    }

    private boolean canRepresent(@NotNull PsiClass psiClass) {
        return this.myClass.getFqn().equals(psiClass.getQualifiedName());
    }

    @Nullable
    private static VirtualFile getContainingFile(@NotNull PsiElement element2) {
        PsiFile containingFile = element2.getContainingFile();
        return containingFile != null ? containingFile.getVirtualFile() : null;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        String fqn = this.myClass.getFqn();
        if (this.myDexSourceFiles.isJavaFile(file2)) {
            assert (this.myProject != null);
            List<String> classes2 = this.myDexSourceFiles.findJavaClassesIn(file2);
            if (classes2.contains(fqn)) {
                return true;
            }
        } else if (this.myDexSourceFiles.isSmaliFile(file2)) {
            File filePath = this.myDexSourceFiles.findSmaliFilePathForClass(fqn);
            return FileUtil.filesEqual((File)filePath, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file2));
        }
        return false;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }
}

