/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderTypeNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.google.common.collect.HashMultimap;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;

public class AndroidResFolderNode
extends AndroidSourceTypeNode {
    AndroidResFolderNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull AndroidSourceType sourceType, @NotNull ViewSettings settings, @NotNull Set<VirtualFile> sourceRoots, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, androidFacet, settings, sourceType, sourceRoots, projectViewPane);
    }

    @Override
    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        ArrayList<PsiDirectory> resFolders = new ArrayList<PsiDirectory>();
        for (PsiDirectory psiDirectory : this.getSourceFolders()) {
            resFolders.addAll(Arrays.asList(psiDirectory.getSubdirectories()));
        }
        HashMultimap foldersByResourceType = HashMultimap.create();
        for (PsiDirectory resFolder : resFolders) {
            ResourceFolderType type = ResourceFolderType.getFolderType((String)resFolder.getName());
            if (type == null) continue;
            foldersByResourceType.put((Object)type, (Object)resFolder);
        }
        ArrayList<AndroidResFolderTypeNode> arrayList = new ArrayList<AndroidResFolderTypeNode>(foldersByResourceType.size());
        for (ResourceFolderType type : foldersByResourceType.keySet()) {
            Set folders = foldersByResourceType.get((Object)type);
            assert (this.myProject != null);
            AndroidResFolderTypeNode node2 = new AndroidResFolderTypeNode(this.myProject, this.getAndroidFacet(), new ArrayList<PsiDirectory>(folders), this.getSettings(), type);
            arrayList.add(node2);
        }
        return arrayList;
    }

    @NotNull
    private AndroidFacet getAndroidFacet() {
        AndroidFacet facet2 = (AndroidFacet)this.getValue();
        assert (facet2 != null);
        return facet2;
    }
}

