/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.nav.safeargs.psi.java;

import com.android.tools.idea.nav.safeargs.index.NavArgumentData;
import com.android.tools.idea.nav.safeargs.psi.java.SafeArgsLightClassUtilsKt;
import com.android.tools.idea.psi.NullabilityUtils;
import com.android.tools.idea.psi.light.NullabilityLightFieldBuilder;
import com.android.utils.StringHelper;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u001a$\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002\u001a,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001e\u0010\u001b\u001a\u00020\u0018*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0000\u001a-\u0010 \u001a\u00020!*\u00020\u001c2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001a2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u00a2\u0006\u0002\u0010$\u001a&\u0010%\u001a\u00020&*\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010)\u001a\u0004\u0018\u00010*H\u0000\u001a?\u0010+\u001a\u00020!*\u00020\u001c2\u0006\u0010,\u001a\u00020\u00012\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001a2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010-\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\u0010.\u001a\u000e\u0010/\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0002\u001a\u000e\u00100\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0002\u001a\u000e\u00101\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0002\u001a\u000e\u00102\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0002\u001a\u000e\u00103\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0002\u001a\u000e\u00104\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0002\u001a\f\u00105\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u00106\u001a\u00020\u0001*\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\"\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006\"\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000b\u0010\u0006\"\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"FALLBACK_TYPE", "", "INT_ARRAY", "MODIFIERS_PUBLIC_CONSTRUCTOR", "", "getMODIFIERS_PUBLIC_CONSTRUCTOR", "()[Ljava/lang/String;", "[Ljava/lang/String;", "MODIFIERS_PUBLIC_METHOD", "getMODIFIERS_PUBLIC_METHOD", "MODIFIERS_STATIC_PUBLIC_METHOD", "getMODIFIERS_STATIC_PUBLIC_METHOD", "NAV_TO_JAVA_TYPE_MAP", "", "RESOURCE_REGEX", "Lkotlin/text/Regex;", "STRING_FQCN", "STRING_FQCN_ARRAY", "getPsiTypeStr", "modulePackage", "typeStr", "defaultValue", "guessFromDefaultValue", "parsePsiType", "Lcom/intellij/psi/PsiType;", "context", "Lcom/intellij/psi/PsiElement;", "annotateNullability", "Lcom/intellij/psi/PsiClass;", "psiType", "isNonNull", "", "createConstructor", "Lcom/intellij/psi/impl/light/LightMethodBuilder;", "navigationElement", "modifiers", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/psi/PsiElement;[Ljava/lang/String;)Lcom/intellij/psi/impl/light/LightMethodBuilder;", "createField", "Lcom/intellij/psi/impl/light/LightFieldBuilder;", "arg", "Lcom/android/tools/idea/nav/safeargs/index/NavArgumentData;", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "createMethod", "name", "returnType", "(Lcom/intellij/psi/PsiClass;Ljava/lang/String;Lcom/intellij/psi/PsiElement;[Ljava/lang/String;Lcom/intellij/psi/PsiType;)Lcom/intellij/psi/impl/light/LightMethodBuilder;", "parseBoolean", "parseFloat", "parseInt", "parseLong", "parseReference", "parseUnsignedInt", "toCamelCase", "toUpperCamelCase", "intellij.android.nav.safeargs"})
public final class SafeArgsLightClassUtilsKt {
    @NotNull
    private static final String[] MODIFIERS_PUBLIC_CONSTRUCTOR = new String[]{"public"};
    @NotNull
    private static final String[] MODIFIERS_PUBLIC_METHOD = new String[]{"public"};
    @NotNull
    private static final String[] MODIFIERS_STATIC_PUBLIC_METHOD = (String[])ArraysKt.plus((Object[])MODIFIERS_PUBLIC_METHOD, (Object[])new String[]{"static"});
    private static final String STRING_FQCN = "java.lang.String";
    private static final String STRING_FQCN_ARRAY = "java.lang.String[]";
    private static final String INT_ARRAY = "int[]";
    private static final String FALLBACK_TYPE = "java.lang.String";
    private static final Map<String, String> NAV_TO_JAVA_TYPE_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"string", (Object)"java.lang.String"), TuplesKt.to((Object)"string[]", (Object)"java.lang.String[]"), TuplesKt.to((Object)"integer", (Object)PsiType.INT.getName()), TuplesKt.to((Object)"integer[]", (Object)"int[]"), TuplesKt.to((Object)"reference", (Object)PsiType.INT.getName()), TuplesKt.to((Object)"reference[]", (Object)"int[]")});
    private static final Regex RESOURCE_REGEX = new Regex("^@[+]?(.+?:)?(.+?)/(.+)$");

    @NotNull
    public static final String[] getMODIFIERS_PUBLIC_CONSTRUCTOR() {
        return MODIFIERS_PUBLIC_CONSTRUCTOR;
    }

    @NotNull
    public static final String[] getMODIFIERS_PUBLIC_METHOD() {
        return MODIFIERS_PUBLIC_METHOD;
    }

    @NotNull
    public static final String[] getMODIFIERS_STATIC_PUBLIC_METHOD() {
        return MODIFIERS_STATIC_PUBLIC_METHOD;
    }

    @NotNull
    public static final PsiType parsePsiType(@NotNull String modulePackage, @Nullable String typeStr, @Nullable String defaultValue2, @NotNull PsiElement context) {
        PsiType psiType;
        String psiTypeStr = SafeArgsLightClassUtilsKt.getPsiTypeStr(modulePackage, typeStr, defaultValue2);
        try {
            psiType = PsiElementFactory.getInstance((Project)context.getProject()).createTypeFromText(psiTypeStr, context);
        }
        catch (IncorrectOperationException e) {
            psiType = PsiElementFactory.getInstance((Project)context.getProject()).createTypeFromText("java.lang.String", context);
        }
        return psiType;
    }

    @NotNull
    public static final String getPsiTypeStr(@NotNull String modulePackage, @Nullable String typeStr, @Nullable String defaultValue2) {
        String psiTypeStr = typeStr;
        if (psiTypeStr == null) {
            psiTypeStr = SafeArgsLightClassUtilsKt.guessFromDefaultValue(defaultValue2);
        }
        String string = psiTypeStr;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            string2 = "java.lang.String";
        }
        psiTypeStr = string2;
        psiTypeStr = NAV_TO_JAVA_TYPE_MAP.getOrDefault(psiTypeStr, psiTypeStr);
        return !StringsKt.startsWith$default((CharSequence)psiTypeStr, (char)'.', (boolean)false, (int)2, null) ? psiTypeStr : modulePackage + psiTypeStr;
    }

    private static final String guessFromDefaultValue(String defaultValue2) {
        if (defaultValue2 == null || Intrinsics.areEqual((Object)defaultValue2, (Object)"@null")) {
            return null;
        }
        String referenceTypeStr = SafeArgsLightClassUtilsKt.parseReference(defaultValue2);
        if (referenceTypeStr != null) {
            return referenceTypeStr;
        }
        String longTypeStr = SafeArgsLightClassUtilsKt.parseLong(defaultValue2);
        if (longTypeStr != null) {
            return longTypeStr;
        }
        String intTypeStr = SafeArgsLightClassUtilsKt.parseInt(defaultValue2);
        if (intTypeStr != null) {
            return intTypeStr;
        }
        String unsignedIntTypeStr = SafeArgsLightClassUtilsKt.parseUnsignedInt(defaultValue2);
        if (unsignedIntTypeStr != null) {
            return unsignedIntTypeStr;
        }
        String floatTypeStr = SafeArgsLightClassUtilsKt.parseFloat(defaultValue2);
        if (floatTypeStr != null) {
            return floatTypeStr;
        }
        String booleanTypeStr = SafeArgsLightClassUtilsKt.parseBoolean(defaultValue2);
        if (booleanTypeStr != null) {
            return booleanTypeStr;
        }
        return null;
    }

    private static final String parseReference(String $this$parseReference) {
        String string;
        MatchResult matchResult = RESOURCE_REGEX.matchEntire((CharSequence)$this$parseReference);
        if (matchResult != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            boolean bl2 = false;
            MatchResult it = matchResult2;
            boolean bl3 = false;
            string = "reference";
        } else {
            string = null;
        }
        return string;
    }

    private static final String parseLong(String $this$parseLong) {
        String string;
        if (!StringsKt.endsWith$default((CharSequence)$this$parseLong, (char)'L', (boolean)false, (int)2, null)) {
            return null;
        }
        Long l = StringsKt.toLongOrNull((String)StringsKt.substringBeforeLast$default((String)$this$parseLong, (char)'L', null, (int)2, null));
        if (l != null) {
            Long l2 = l;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l2).longValue();
            boolean bl3 = false;
            string = PsiType.LONG.getName();
        } else {
            string = null;
        }
        return string;
    }

    private static final String parseInt(String $this$parseInt) {
        String string;
        Integer n = StringsKt.toIntOrNull((String)$this$parseInt);
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            string = PsiType.INT.getName();
        } else {
            string = null;
        }
        return string;
    }

    private static final String parseUnsignedInt(String $this$parseUnsignedInt) {
        if (!StringsKt.startsWith$default((String)$this$parseUnsignedInt, (String)"0x", (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            String string = $this$parseUnsignedInt;
            int n = 2;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            Integer.parseUnsignedInt(string3, 16);
            return PsiType.INT.getName();
        }
        catch (NumberFormatException ignore) {
            return null;
        }
    }

    private static final String parseFloat(String $this$parseFloat) {
        String string;
        Float f = StringsKt.toFloatOrNull((String)$this$parseFloat);
        if (f != null) {
            Float f2 = f;
            boolean bl = false;
            boolean bl2 = false;
            float it = ((Number)f2).floatValue();
            boolean bl3 = false;
            string = PsiType.FLOAT.getName();
        } else {
            string = null;
        }
        return string;
    }

    private static final String parseBoolean(String $this$parseBoolean) {
        if (Intrinsics.areEqual((Object)$this$parseBoolean, (Object)"true") || Intrinsics.areEqual((Object)$this$parseBoolean, (Object)"false")) {
            return PsiType.BOOLEAN.getName();
        }
        return null;
    }

    @NotNull
    public static final LightMethodBuilder createConstructor(@NotNull PsiClass $this$createConstructor, @Nullable PsiElement navigationElement, @NotNull String[] modifiers) {
        PsiElement fallback = $this$createConstructor.getNavigationElement();
        LightMethodBuilder lightMethodBuilder = new LightMethodBuilder($this$createConstructor, (Language)JavaLanguage.INSTANCE).setConstructor(true).addModifiers(Arrays.copyOf(modifiers, modifiers.length));
        boolean bl = false;
        boolean bl2 = false;
        LightMethodBuilder $this$apply = lightMethodBuilder;
        boolean bl3 = false;
        PsiElement psiElement = navigationElement;
        if (psiElement == null) {
            psiElement = fallback;
        }
        $this$apply.setNavigationElement(psiElement);
        return lightMethodBuilder;
    }

    public static /* synthetic */ LightMethodBuilder createConstructor$default(PsiClass psiClass, PsiElement psiElement, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            psiElement = null;
        }
        if ((n & 2) != 0) {
            stringArray = MODIFIERS_PUBLIC_CONSTRUCTOR;
        }
        return SafeArgsLightClassUtilsKt.createConstructor(psiClass, psiElement, stringArray);
    }

    @NotNull
    public static final LightFieldBuilder createField(@NotNull PsiClass $this$createField, @NotNull NavArgumentData arg, @NotNull String modulePackage, @Nullable XmlTag xmlTag) {
        PsiType psiType = SafeArgsLightClassUtilsKt.parsePsiType(modulePackage, arg.getType(), arg.getDefaultValue(), (PsiElement)$this$createField);
        boolean nonNull = psiType instanceof PsiPrimitiveType || arg.isNonNull();
        NullabilityLightFieldBuilder nullabilityLightFieldBuilder = new NullabilityLightFieldBuilder($this$createField.getManager(), arg.getName(), psiType, nonNull, new String[]{"public", "final"});
        boolean bl = false;
        boolean bl2 = false;
        NullabilityLightFieldBuilder $this$apply = nullabilityLightFieldBuilder;
        boolean bl3 = false;
        XmlTag xmlTag2 = xmlTag;
        $this$apply.setNavigationElement(xmlTag2 != null ? (PsiElement)xmlTag2 : $this$apply.getNavigationElement());
        return (LightFieldBuilder)nullabilityLightFieldBuilder;
    }

    @NotNull
    public static final PsiType annotateNullability(@NotNull PsiClass $this$annotateNullability, @NotNull PsiType psiType, boolean isNonNull) {
        boolean nonNull = psiType instanceof PsiPrimitiveType || isNonNull;
        return NullabilityUtils.annotateType((Project)$this$annotateNullability.getProject(), (PsiType)psiType, (boolean)nonNull, (PsiElement)$this$annotateNullability.getContext());
    }

    public static /* synthetic */ PsiType annotateNullability$default(PsiClass psiClass, PsiType psiType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return SafeArgsLightClassUtilsKt.annotateNullability(psiClass, psiType, bl);
    }

    @NotNull
    public static final LightMethodBuilder createMethod(@NotNull PsiClass $this$createMethod, @NotNull String name, @Nullable PsiElement navigationElement, @NotNull String[] modifiers, @NotNull PsiType returnType) {
        LightMethodBuilder lightMethodBuilder = new LightMethodBuilder($this$createMethod.getManager(), (Language)JavaLanguage.INSTANCE, name).setContainingClass($this$createMethod).setModifiers(Arrays.copyOf(modifiers, modifiers.length)).setMethodReturnType(returnType);
        boolean bl = false;
        boolean bl2 = false;
        LightMethodBuilder $this$apply = lightMethodBuilder;
        boolean bl3 = false;
        PsiElement psiElement = navigationElement;
        if (psiElement == null) {
            psiElement = $this$createMethod.getNavigationElement();
        }
        $this$apply.setNavigationElement(psiElement);
        return lightMethodBuilder;
    }

    public static /* synthetic */ LightMethodBuilder createMethod$default(PsiClass psiClass, String string, PsiElement psiElement, String[] stringArray, PsiType psiType, int n, Object object) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        if ((n & 4) != 0) {
            stringArray = MODIFIERS_PUBLIC_METHOD;
        }
        if ((n & 8) != 0) {
            psiType = (PsiType)PsiType.VOID;
        }
        return SafeArgsLightClassUtilsKt.createMethod(psiClass, string, psiElement, stringArray, psiType);
    }

    @NotNull
    public static final String toCamelCase(@NotNull String $this$toCamelCase) {
        return StringHelper.usLocaleDecapitalize((String)SafeArgsLightClassUtilsKt.toUpperCamelCase($this$toCamelCase));
    }

    @NotNull
    public static final String toUpperCamelCase(@NotNull String $this$toUpperCamelCase) {
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$toUpperCamelCase, (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)toUpperCamelCase.1.INSTANCE, (int)30, null);
    }
}

