/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.lightpsi;

import com.android.tools.mlkit.TensorInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.apache.commons.lang.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class CodeUtils {
    @NotNull
    public static PsiClassType getPsiClassType(@NotNull TensorInfo tensorInfo, @NotNull Project project, @NotNull GlobalSearchScope scope2, boolean generateFallbackApiOnly) {
        if (generateFallbackApiOnly) {
            return PsiType.getTypeByName((String)"org.tensorflow.lite.support.tensorbuffer.TensorBuffer", (Project)project, (GlobalSearchScope)scope2);
        }
        if (tensorInfo.isRGBImage()) {
            return PsiType.getTypeByName((String)"org.tensorflow.lite.support.image.TensorImage", (Project)project, (GlobalSearchScope)scope2);
        }
        if (tensorInfo.getFileType() == TensorInfo.FileType.TENSOR_AXIS_LABELS) {
            PsiClass listClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.List", scope2);
            PsiClassType value2 = PsiType.getTypeByName((String)"org.tensorflow.lite.support.label.Category", (Project)project, (GlobalSearchScope)scope2);
            return PsiElementFactory.getInstance((Project)project).createType(listClass, (PsiType)value2);
        }
        return PsiType.getTypeByName((String)"org.tensorflow.lite.support.tensorbuffer.TensorBuffer", (Project)project, (GlobalSearchScope)scope2);
    }

    @NotNull
    public static String getTypeName(@NotNull PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            Object[] psiTypes = psiClassType.getParameters();
            if (ArrayUtils.isEmpty((Object[])psiTypes)) {
                return psiClassType.getClassName();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Object paramType : psiTypes) {
                stringBuilder.append(paramType.getPresentableText());
            }
            stringBuilder.append(psiClassType.getClassName());
            return stringBuilder.toString();
        }
        return psiType.getPresentableText();
    }
}

