/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.memorysettings.GradlePropertiesUtil;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class GradleUserProperties {
    private static final Logger LOG = Logger.getInstance(GradleUserProperties.class);
    private GradleProperties gradleUserHomeProperties;
    private File propertiesPath;
    private int gradleXmx = -1;
    private int kotlinXmx = -1;

    GradleUserProperties() {
        String userHome = System.getProperty("gradle.user.home");
        if (Strings.isNullOrEmpty((String)userHome)) {
            userHome = GradleUserProperties.getUserHome();
        }
        if (userHome != null) {
            this.gradleUserHomeProperties = GradleUserProperties.getProperties(userHome);
            if (this.gradleUserHomeProperties != null && GradlePropertiesUtil.hasJvmArgs(this.gradleUserHomeProperties)) {
                this.propertiesPath = this.gradleUserHomeProperties.getPath();
                this.findGradleDaemonXmx(this.gradleUserHomeProperties);
                this.findKotlinDaemonXmx(this.gradleUserHomeProperties);
            }
        }
    }

    File getPropertiesPath() {
        return this.propertiesPath;
    }

    int getGradleXmx() {
        return this.gradleXmx;
    }

    int getKotlinXmx() {
        return this.kotlinXmx;
    }

    private void findGradleDaemonXmx(GradleProperties properties2) {
        int xmx = GradlePropertiesUtil.getGradleDaemonXmx(properties2);
        if (xmx > 0) {
            this.gradleXmx = xmx;
            return;
        }
    }

    private void findKotlinDaemonXmx(GradleProperties properties2) {
        int xmx = GradlePropertiesUtil.getKotlinDaemonXmx(properties2);
        if (xmx > 0) {
            this.kotlinXmx = xmx;
            return;
        }
        xmx = GradlePropertiesUtil.getGradleDaemonXmx(properties2);
        if (xmx > 0) {
            this.kotlinXmx = xmx;
            return;
        }
    }

    @Nullable
    private static GradleProperties getProperties(String dir) {
        try {
            return new GradleProperties(new File(dir, "gradle.properties"));
        }
        catch (IOException e) {
            LOG.info("Failed to read gradle.properties from " + dir, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static String getUserHome() {
        String gradleUserHome = System.getenv("GRADLE_USER_HOME");
        if (gradleUserHome == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return gradleUserHome;
    }
}

