/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.google.wireless.android.sdk.stats.MemorySettingsEvent;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class AndroidLowMemoryNotifier
implements ApplicationComponent {
    private LowMemoryWatcher myWatcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    private final AtomicBoolean myNotificationShown = new AtomicBoolean();

    private void onLowMemorySignalReceived() {
        final int currentXmx = MemorySettingsUtil.getCurrentXmx();
        int xmxCap = MemorySettingsUtil.getIdeXmxCapInGB() * 1024;
        if (this.myNotificationShown.compareAndSet(false, true) && currentXmx < xmxCap) {
            Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"Low Memory", (String)IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0])), IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"low.memory.notification.content", (Object[])new Object[0]), NotificationType.WARNING);
            notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"low.memory.notification.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    MemorySettingsUtil.log(MemorySettingsEvent.EventKind.CONFIGURE, currentXmx, -1, -1, -1, -1, -1, -1, -1, -1);
                    Project project = e.getProject();
                    ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"memory.settings", (String)"");
                    notification.expire();
                }
            });
            Notifications.Bus.notify((Notification)notification);
        }
    }

    public void disposeComponent() {
        this.myWatcher.stop();
        this.myWatcher = null;
    }
}

