/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jetbrains.annotations.NotNull;

final class DeviceAndSearchPanel
extends JPanel {
    private final Component myDeviceComboBox;
    private final Component myClientComboBox;
    private final Component myLogFilterComboBox;
    private final Component mySearchTextField;
    private final Component myRegexCheckBox;
    private final Component myEditFiltersComboBox;

    DeviceAndSearchPanel(@NotNull DevicePanel devicePanel, @NotNull AndroidLogcatView logcatView) {
        AndroidLogConsole console = logcatView.getLogConsole();
        RegexFilterComponent component = (RegexFilterComponent)((Object)console.getTextFilterComponent());
        this.myDeviceComboBox = devicePanel.getDeviceComboBox();
        this.myClientComboBox = devicePanel.getClientComboBox();
        this.myLogFilterComboBox = console.getLogFilterComboBox();
        this.mySearchTextField = component.getSearchTextField();
        this.myRegexCheckBox = component.getRegexCheckBox();
        this.myEditFiltersComboBox = logcatView.createEditFiltersComboBox();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                DeviceAndSearchPanel.this.setLayout(DeviceAndSearchPanel.this.getWidth() > JBUI.scale((int)500) ? DeviceAndSearchPanel.this.createWideLayout() : DeviceAndSearchPanel.this.createNarrowLayout());
            }
        });
    }

    @NotNull
    private LayoutManager createWideLayout() {
        GroupLayout layout2 = new GroupLayout(this);
        int minimumWidth = new ComboBox().getMinimumSize().width;
        int preferredWidth = this.myEditFiltersComboBox.getPreferredSize().width;
        GroupLayout.SequentialGroup horizontalGroup = layout2.createSequentialGroup().addComponent(this.myDeviceComboBox, minimumWidth, preferredWidth, preferredWidth).addComponent(this.myClientComboBox, minimumWidth, preferredWidth, preferredWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myLogFilterComboBox, minimumWidth, -1, -2).addComponent(this.mySearchTextField, -1, preferredWidth, Short.MAX_VALUE).addComponent(this.myRegexCheckBox).addComponent(this.myEditFiltersComboBox, minimumWidth, preferredWidth, preferredWidth);
        GroupLayout.ParallelGroup verticalGroup = layout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myDeviceComboBox).addComponent(this.myClientComboBox).addComponent(this.myLogFilterComboBox).addComponent(this.mySearchTextField).addComponent(this.myRegexCheckBox).addComponent(this.myEditFiltersComboBox);
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        return layout2;
    }

    @NotNull
    private LayoutManager createNarrowLayout() {
        GroupLayout layout2 = new GroupLayout(this);
        int minimumWidth = new ComboBox().getMinimumSize().width;
        int preferredWidth = this.myEditFiltersComboBox.getPreferredSize().width;
        GroupLayout.ParallelGroup horizontalGroup = layout2.createParallelGroup().addGroup(layout2.createSequentialGroup().addComponent(this.myDeviceComboBox).addComponent(this.myClientComboBox)).addGroup(layout2.createSequentialGroup().addComponent(this.myLogFilterComboBox, minimumWidth, -1, -2).addComponent(this.mySearchTextField).addComponent(this.myRegexCheckBox).addComponent(this.myEditFiltersComboBox, minimumWidth, preferredWidth, preferredWidth));
        GroupLayout.SequentialGroup verticalGroup = layout2.createSequentialGroup().addGroup(layout2.createParallelGroup().addComponent(this.myDeviceComboBox).addComponent(this.myClientComboBox)).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLogFilterComboBox).addComponent(this.mySearchTextField).addComponent(this.myRegexCheckBox).addComponent(this.myEditFiltersComboBox));
        layout2.setAutoCreateContainerGaps(true);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        return layout2;
    }
}

