/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.gradle.model.IdeLintOptions;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.internal.annotations.VisibleForTesting;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.upgrade.DeprecatedConfigurationsUpgrade;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.lint.AndroidLintIdeClient;
import com.android.tools.idea.lint.AndroidLintIdeIssueRegistry;
import com.android.tools.idea.lint.AndroidLintIdeProject;
import com.android.tools.idea.lint.AndroidLintMissingConstraintsInspection;
import com.android.tools.idea.lint.LintIdeAnalytics;
import com.android.tools.idea.lint.ProvideLintFeedbackFix;
import com.android.tools.idea.lint.ProvideLintFeedbackIntentionAction;
import com.android.tools.idea.lint.ProvideLintFeedbackPanel;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintIdeSupportKt;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.SdkUtils;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.groovy.GroovyFileType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001eH\u0016J?\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u00182\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010 2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150&\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010'J.\u0010(\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0)2\u0006\u0010\"\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010*\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020+2\u0006\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u00100\u001a\u000201H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0016J\u001e\u00105\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u000207\u0018\u0001062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010\u0019\u001a\u00020\u001eH\u0016J\"\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u00020AH\u0016J\u001a\u0010D\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010E\u001a\u00020FH\u0016J\u001d\u0010G\u001a\n H*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010K\u001a\u0002092\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010L\u001a\u0002092\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010M\u001a\u00020\fH\u0016J\u0018\u0010N\u001a\u0002092\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010E\u001a\u00020FH\u0016R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006O"}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeSupport;", "Lcom/android/tools/idea/lint/common/LintIdeSupport;", "()V", "random", "Ljava/util/Random;", "getRandom$annotations", "getRandom", "()Ljava/util/Random;", "askForAttributeValue", "", "attributeName", "context", "Lcom/intellij/psi/PsiElement;", "canAnalyze", "", "project", "Lcom/intellij/openapi/project/Project;", "canAnnotate", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "canRequestFeedback", "createBatchClient", "Lcom/android/tools/idea/lint/common/LintIdeClient;", "lintResult", "Lcom/android/tools/idea/lint/common/LintBatchResult;", "createClient", "Lcom/android/tools/idea/lint/common/LintResult;", "createEditorClient", "Lcom/android/tools/idea/lint/common/LintEditorResult;", "createProject", "", "Lcom/android/tools/lint/detector/api/Project;", "client", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "(Lcom/android/tools/idea/lint/common/LintIdeClient;Ljava/util/List;[Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "createProjectForSingleFile", "Lcom/intellij/openapi/util/Pair;", "ensureNamespaceImported", "Lcom/intellij/psi/xml/XmlFile;", "namespaceUri", "suggestedPrefix", "getBaselineFile", "Ljava/io/File;", "getIssueRegistry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "getPlatforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "getSeverityOverrides", "", "", "logSession", "", "lint", "Lcom/android/tools/lint/client/api/LintDriver;", "recommendedAgpVersion", "Lcom/android/ide/common/repository/GradleVersion;", "requestFeedbackFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "requestFeedbackIntentionAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "resolveDynamic", "gc", "Lcom/android/ide/common/repository/GradleCoordinate;", "shouldOfferUpgradeAssistantForDeprecatedConfigurations", "kotlin.jvm.PlatformType", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;", "shouldRecommendUpdateAgpToLatest", "updateAgpToLatest", "updateDeprecatedConfigurations", "element", "updateToLatest", "intellij.android.core"})
public final class AndroidLintIdeSupport
extends LintIdeSupport {
    @NotNull
    private final Random random = new Random(0L);

    @NotNull
    public IssueRegistry getIssueRegistry() {
        return (IssueRegistry)new AndroidLintIdeIssueRegistry();
    }

    @Nullable
    public File getBaselineFile(@NotNull LintIdeClient client, @NotNull Module module2) {
        block7: {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module2);
            if (androidModuleModel == null) {
                return null;
            }
            AndroidModuleModel model2 = androidModuleModel;
            GradleVersion gradleVersion2 = model2.getModelVersion();
            if (gradleVersion2 == null) {
                return null;
            }
            GradleVersion version2 = gradleVersion2;
            if (version2.isAtLeast(2, 3, 1)) {
                IdeLintOptions options2 = model2.getAndroidProject().getLintOptions();
                try {
                    File baselineFile = options2.getBaselineFile();
                    if (baselineFile != null) {
                        return baselineFile;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            File file2 = LintIdeSupportKt.getModuleDir((Module)module2);
            if (file2 == null) break block7;
            File file3 = file2;
            boolean bl = false;
            boolean bl2 = false;
            File dir = file3;
            boolean bl3 = false;
            Object object = client.getConfiguration(dir);
            if (object != null && (object = object.getBaselineFile()) != null) {
                Object object2 = object;
                boolean bl4 = false;
                boolean bl5 = false;
                Object baseline = object2;
                boolean bl6 = false;
                return baseline;
            }
        }
        return null;
    }

    @Nullable
    public Map<String, Integer> getSeverityOverrides(@NotNull Module module2) {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module2);
        if (androidModuleModel == null) {
            return null;
        }
        AndroidModuleModel model2 = androidModuleModel;
        GradleVersion gradleVersion2 = model2.getModelVersion();
        if (gradleVersion2 == null) {
            return null;
        }
        GradleVersion version2 = gradleVersion2;
        if (version2.isAtLeast(2, 3, 1)) {
            IdeLintOptions options2 = model2.getAndroidProject().getLintOptions();
            try {
                return options2.getSeverityOverrides();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String askForAttributeValue(@NotNull String attributeName, @NotNull PsiElement context) {
        AttributeDefinition def;
        AttributeDefinitions attrDefs;
        FrameworkResourceManager srm;
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)context);
        String message2 = "Specify value of attribute '" + attributeName + '\'';
        String title = "Set Attribute Value";
        if (facet2 != null && (srm = ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager()) != null && (attrDefs = srm.getAttributeDefinitions()) != null && (def = attrDefs.getAttrDefByName(attributeName)) != null) {
            String[] variants;
            String[] stringArray = variants = def.getValues();
            boolean bl = false;
            String[] stringArray2 = stringArray;
            boolean bl2 = false;
            if (!(stringArray2.length == 0)) {
                return Messages.showEditableChooseDialog((String)message2, (String)title, (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
            }
        }
        return Messages.showInputDialog((com.intellij.openapi.project.Project)context.getProject(), (String)message2, (String)title, (Icon)Messages.getQuestionIcon());
    }

    public boolean canAnnotate(@NotNull PsiFile file2, @NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null && !AndroidLintIdeProject.hasAndroidModule(module2.getProject())) {
            return false;
        }
        FileType fileType = file2.getFileType();
        if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE || fileType == PropertiesFileType.INSTANCE) {
            return true;
        }
        if (fileType == XmlFileType.INSTANCE) {
            return facet2 != null && (ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getFileResourceFolderType(file2) != null || Intrinsics.areEqual((Object)"AndroidManifest.xml", (Object)file2.getName()));
        }
        if (fileType == FileTypes.PLAIN_TEXT) {
            return super.canAnnotate(file2, module2);
        }
        if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
            if (!SdkUtils.endsWithIgnoreCase((String)file2.getName(), (String)".gradle")) {
                return false;
            }
            com.intellij.openapi.project.Project project = file2.getProject();
            if (AndroidProjectInfo.getInstance(project).requiresAndroidModel()) {
                AndroidFileChangeListener.getInstance(project);
            }
            return true;
        }
        return false;
    }

    public boolean canAnalyze(@NotNull com.intellij.openapi.project.Project project) {
        return ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).hasFacets(AndroidFacet.ID);
    }

    @NotNull
    public List<Project> createProject(@NotNull LintIdeClient client, @Nullable List<? extends VirtualFile> files2, Module ... modules) {
        return AndroidLintIdeProject.create(client, files2, Arrays.copyOf(modules, modules.length));
    }

    @NotNull
    public Pair<Project, Project> createProjectForSingleFile(@NotNull LintIdeClient client, @Nullable VirtualFile file2, @NotNull Module module2) {
        return AndroidLintIdeProject.createForSingleFile(client, file2, module2);
    }

    @NotNull
    public LintIdeClient createClient(@NotNull com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        return new AndroidLintIdeClient(project, lintResult);
    }

    @NotNull
    public LintIdeClient createBatchClient(@NotNull LintBatchResult lintResult) {
        return new AndroidLintIdeClient(lintResult.getProject(), (LintResult)lintResult);
    }

    @NotNull
    public LintIdeClient createEditorClient(@NotNull LintEditorResult lintResult) {
        return new AndroidLintIdeClient(lintResult.getModule().getProject(), (LintResult)lintResult);
    }

    public void updateToLatest(@NotNull Module module2, @NotNull GradleCoordinate gc) {
        GradleCoordinate latest;
        StudioSdkUtil.reloadRemoteSdkWithModalProgress();
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidLintMissingConstraintsInspection.class);
        RepoPackage p = SdkMavenRepository.findLatestVersion((GradleCoordinate)gc, (AndroidSdkHandler)sdkHandler, null, (ProgressIndicator)((ProgressIndicator)progress));
        if (p != null && (latest = SdkMavenRepository.getCoordinateFromSdkPath((String)p.getPath())) != null) {
            GradleDependencyManager manager = GradleDependencyManager.getInstance(module2.getProject());
            manager.updateLibrariesToVersion(module2, CollectionsKt.listOf((Object)latest), null);
        }
    }

    @Nullable
    public GradleVersion recommendedAgpVersion(@NotNull com.intellij.openapi.project.Project project) {
        return GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
    }

    public boolean shouldRecommendUpdateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(project, null, null, 6, null);
    }

    public void updateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project){
            final /* synthetic */ com.intellij.openapi.project.Project $project;

            public final void run() {
                GradlePluginUpgrade.performRecommendedPluginUpgrade$default(this.$project, null, null, null, 14, null);
            }
            {
                this.$project = project;
            }
        });
    }

    public Boolean shouldOfferUpgradeAssistantForDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project) {
        return (Boolean)StudioFlags.AGP_UPGRADE_ASSISTANT.get();
    }

    public void updateDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement element2) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, element2){
            final /* synthetic */ com.intellij.openapi.project.Project $project;
            final /* synthetic */ PsiElement $element;

            public final void run() {
                DeprecatedConfigurationsUpgrade.performDeprecatedConfigurationsUpgrade(this.$project, this.$element);
            }
            {
                this.$project = project;
                this.$element = psiElement;
            }
        });
    }

    @Nullable
    public String resolveDynamic(@NotNull com.intellij.openapi.project.Project project, @NotNull GradleCoordinate gc) {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return RepositoryUrlManager.Companion.get().resolveDynamicCoordinateVersion(gc, project, sdkHandler);
    }

    @NotNull
    public EnumSet<Platform> getPlatforms() {
        return Platform.ANDROID_SET;
    }

    public boolean canRequestFeedback() {
        return ProvideLintFeedbackPanel.canRequestFeedback();
    }

    @NotNull
    public LocalQuickFix requestFeedbackFix(@NotNull Issue issue2) {
        return new ProvideLintFeedbackFix(issue2.getId());
    }

    @NotNull
    public IntentionAction requestFeedbackIntentionAction(@NotNull Issue issue2) {
        return new ProvideLintFeedbackIntentionAction(issue2.getId());
    }

    @VisibleForTesting
    public static /* synthetic */ void getRandom$annotations() {
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public void logSession(@NotNull LintDriver lint, @NotNull LintEditorResult lintResult) {
        if (this.random.nextDouble() < 0.01) {
            LintIdeAnalytics analytics = new LintIdeAnalytics(lintResult.getModule().getProject());
            analytics.logSession(LintSession.AnalysisType.IDE_FILE, lint, lintResult.getModule(), lintResult.getProblems(), null);
        }
    }

    public void logSession(@NotNull LintDriver lint, @Nullable Module module2, @NotNull LintBatchResult lintResult) {
        LintIdeAnalytics analytics = new LintIdeAnalytics(lintResult.getProject());
        analytics.logSession(LintSession.AnalysisType.IDE_BATCH, lint, module2, null, lintResult.getProblemMap());
    }

    @NotNull
    public String ensureNamespaceImported(@NotNull XmlFile file2, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        return IdeResourcesUtil.ensureNamespaceImported(file2, namespaceUri, suggestedPrefix);
    }
}

