/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InstantAppUrlFinder {
    @NotNull
    private final Collection<Element> myActivities;
    @NotNull
    private final AttributesResolver myResolver;

    public InstantAppUrlFinder(@NotNull Module module2) {
        this(new AttributesResolver(module2), MergedManifestManager.getSnapshot(module2).getActivities());
    }

    @VisibleForTesting
    InstantAppUrlFinder(@NotNull AttributesResolver resolver, @NotNull Collection<Element> activities) {
        this.myResolver = resolver;
        this.myActivities = activities;
    }

    @NotNull
    public ImmutableCollection<String> getAllUrls() {
        TreeMultimap allUrls = TreeMultimap.create();
        for (Element activity : this.myActivities) {
            for (Node node2 = activity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = new InstantAppIntentFilterWrapper(this.myResolver, node2);
                UrlData urlData = wrapper.getUrlData();
                if (!urlData.isValid()) continue;
                allUrls.put((Object)wrapper.getOrder(), (Object)urlData.getUrl());
            }
        }
        return ImmutableList.copyOf((Collection)allUrls.values());
    }

    @NotNull
    public String getDefaultUrl() {
        ImmutableCollection<String> urls = this.getAllUrls();
        if (!urls.isEmpty()) {
            return (String)urls.iterator().next();
        }
        return "";
    }

    public boolean matchesUrl(@NotNull String url) {
        for (Element activity : this.myActivities) {
            for (Node node2 = activity.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = new InstantAppIntentFilterWrapper(this.myResolver, node2);
                if (!wrapper.matchesUrl(url)) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    static class AttributesResolver {
        @Nullable
        private final ResourceResolver myResourceResolver;

        private AttributesResolver(@NotNull Module module2) {
            List<VirtualFile> manifestFiles = MergedManifestManager.getSnapshot(module2).getManifestFiles();
            this.myResourceResolver = manifestFiles == null || manifestFiles.isEmpty() ? null : ConfigurationManager.getOrCreateInstance(module2).getConfiguration(manifestFiles.get(0)).getResourceResolver();
        }

        @Nullable
        String resolveResource(@NotNull String name, @Nullable String value2) {
            if (this.myResourceResolver == null) {
                return value2;
            }
            ResourceValue resolvedResource = this.myResourceResolver.resolveResValue((ResourceValue)new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STRING, name, value2));
            return resolvedResource == null ? value2 : resolvedResource.getValue();
        }
    }

    @VisibleForTesting
    static class UrlData {
        @NotNull
        private AttributesResolver myResolver;
        @NotNull
        private final Collection<String> mySchemes = new HashSet<String>();
        @NotNull
        private final Collection<String> myHosts = new HashSet<String>();
        @NotNull
        private final Collection<String> myPaths = new HashSet<String>();
        @NotNull
        private final Collection<String> myPathPrefixes = new HashSet<String>();
        @NotNull
        private final Collection<String> myPathPatterns = new HashSet<String>();

        @VisibleForTesting
        UrlData(@NotNull AttributesResolver resolver) {
            this.myResolver = resolver;
        }

        @VisibleForTesting
        void addFromStrings(@NotNull String scheme, @NotNull String host, @NotNull String path2, @NotNull String pathPrefix, @NotNull String pathPattern) {
            UrlData.addTo(this.mySchemes, scheme);
            UrlData.addTo(this.myHosts, host);
            UrlData.addTo(this.myPaths, path2);
            UrlData.addTo(this.myPathPrefixes, pathPrefix);
            UrlData.addTo(this.myPathPatterns, pathPattern);
        }

        @VisibleForTesting
        void addFromNode(@NotNull Node node2) {
            if (node2.getNodeType() == 1 && "data".equals(node2.getNodeName())) {
                Element element2 = (Element)node2;
                UrlData.addTo(this.mySchemes, this.myResolver.resolveResource("scheme", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme")));
                UrlData.addTo(this.myHosts, this.myResolver.resolveResource("host", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "host")));
                UrlData.addTo(this.myPaths, this.myResolver.resolveResource("path", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "path")));
                UrlData.addTo(this.myPathPrefixes, this.myResolver.resolveResource("pathPrefix", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPrefix")));
                UrlData.addTo(this.myPathPatterns, this.myResolver.resolveResource("pathPattern", element2.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPattern")));
            }
        }

        private static void addTo(@NotNull Collection<String> collection2, @Nullable String string) {
            if (StringUtil.isNotEmpty((String)string)) {
                collection2.add(string);
            }
        }

        @NotNull
        @VisibleForTesting
        static String convertPatternToExample(@NotNull String pattern) {
            return pattern.replace(".*", "example");
        }

        @VisibleForTesting
        boolean isValid() {
            return !this.mySchemes.isEmpty() && !this.myHosts.isEmpty() && this.getEffectivePath().startsWith("/");
        }

        @NotNull
        private String getEffectivePath() {
            String path2;
            String string = path2 = this.myPaths.isEmpty() ? "" : this.myPaths.iterator().next();
            if (StringUtil.isEmpty((String)path2)) {
                String string2 = path2 = this.myPathPrefixes.isEmpty() ? "" : this.myPathPrefixes.iterator().next() + "/.*";
            }
            if (StringUtil.isEmpty((String)path2)) {
                path2 = this.myPathPatterns.isEmpty() ? "" : this.myPathPatterns.iterator().next();
            }
            return StringUtil.isNotEmpty((String)path2) ? path2 : "/";
        }

        @NotNull
        @VisibleForTesting
        String getUrl() {
            if (!this.isValid()) {
                return "";
            }
            String scheme = this.mySchemes.iterator().next();
            String host = this.myHosts.iterator().next();
            return String.format("%s://%s%s", scheme, host, UrlData.convertPatternToExample(this.getEffectivePath()));
        }

        @VisibleForTesting
        boolean matchesUrl(@NotNull String url) {
            if (!this.isValid()) {
                return false;
            }
            boolean schemeMatched = false;
            for (String scheme : this.mySchemes) {
                if (!url.startsWith(scheme + "://")) continue;
                url = url.replaceFirst(scheme + "://", "");
                schemeMatched = true;
                break;
            }
            if (!schemeMatched) {
                return false;
            }
            boolean hostMatched = false;
            for (String host : this.myHosts) {
                if (!url.startsWith(host)) continue;
                url = url.replaceFirst(host, "");
                hostMatched = true;
                break;
            }
            if (!hostMatched) {
                return false;
            }
            for (String path2 : this.myPaths) {
                if (!StringUtil.isNotEmpty((String)path2) || !new AndroidPatternMatcher(path2, 0).match(url)) continue;
                return true;
            }
            for (String pathPrefix : this.myPathPrefixes) {
                if (!StringUtil.isNotEmpty((String)pathPrefix) || !new AndroidPatternMatcher(pathPrefix, 1).match(url)) continue;
                return true;
            }
            for (String pathPattern : this.myPathPatterns) {
                if (!StringUtil.isNotEmpty((String)pathPattern) || !new AndroidPatternMatcher(pathPattern, 2).match(url)) continue;
                return true;
            }
            if (!(this.myPaths.isEmpty() && this.myPathPrefixes.isEmpty() && this.myPathPatterns.isEmpty())) {
                return false;
            }
            return url.isEmpty() || url.compareTo("/") == 0;
        }
    }

    @VisibleForTesting
    static class InstantAppIntentFilterWrapper {
        @NotNull
        AttributesResolver myResolver;
        @Nullable
        private final Element myElement;
        private final int myOrder;

        @VisibleForTesting
        InstantAppIntentFilterWrapper(@NotNull AttributesResolver resolver, @NotNull Node node2) {
            int order;
            Element element2;
            try {
                element2 = InstantAppIntentFilterWrapper.getElement(node2);
                order = InstantAppIntentFilterWrapper.getOrder(element2);
            }
            catch (IllegalArgumentException unused) {
                element2 = null;
                order = -1;
            }
            this.myElement = element2;
            this.myOrder = order;
            this.myResolver = resolver;
        }

        @NotNull
        @VisibleForTesting
        static Element getElement(@NotNull Node node2) {
            if (node2.getNodeType() == 1 && "intent-filter".equals(node2.getNodeName())) {
                return (Element)node2;
            }
            throw new IllegalArgumentException();
        }

        @VisibleForTesting
        static int getOrder(@NotNull Element element2) {
            String orderValue = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "order");
            if (StringUtil.isNotEmpty((String)orderValue)) {
                try {
                    return Integer.parseUnsignedInt(orderValue);
                }
                catch (NumberFormatException unused) {
                    throw new IllegalArgumentException();
                }
            }
            return 0;
        }

        @NotNull
        UrlData getUrlData() {
            UrlData urlData = new UrlData(this.myResolver);
            if (this.myElement != null) {
                for (Node node2 = this.myElement.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    urlData.addFromNode(node2);
                }
            }
            return urlData;
        }

        int getOrder() {
            return this.myOrder;
        }

        boolean matchesUrl(@NotNull String url) {
            return this.getUrlData().matchesUrl(url);
        }
    }
}

