/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolutionDialog;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConflictResolution {
    private ConflictResolution() {
    }

    public static boolean solveSelectionConflict(@NotNull Conflict conflict) {
        return ConflictResolution.solveSelectionConflict(conflict, true);
    }

    private static boolean solveSelectionConflict(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        NdkModuleModel ndkModel;
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)conflict.getSource());
        if (facet2 == null || !AndroidModel.isRequired(facet2)) {
            return true;
        }
        AndroidModuleModel source = AndroidModuleModel.get(facet2);
        if (source == null) {
            return false;
        }
        String newVariant = ConflictResolution.resolveNewVariant(conflict, showConflictResolutionDialog);
        if (StringUtil.isEmpty((String)newVariant)) {
            return false;
        }
        NdkFacet ndkFacet = NdkFacet.getInstance(conflict.getSource());
        NdkModuleModel ndkModuleModel = ndkModel = ndkFacet == null ? null : ndkFacet.getNdkModuleModel();
        if (ndkModel != null) {
            VariantAbi newVariantAbi = ConflictResolution.resolveNewVariantAbi(ndkFacet, ndkModel, newVariant);
            if (newVariantAbi == null) {
                return false;
            }
            ndkFacet.setSelectedVariantAbi(newVariantAbi);
            ndkFacet.setNdkModuleModel(ndkModel);
        }
        source.setSelectedVariantName(newVariant);
        source.syncSelectedVariantAndTestArtifact(facet2);
        return true;
    }

    @Nullable
    private static String resolveNewVariant(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        Collection<String> variants = conflict.getVariants();
        if (variants.size() == 1) {
            return (String)ContainerUtil.getFirstItem(variants);
        }
        if (!showConflictResolutionDialog) {
            return null;
        }
        ConflictResolutionDialog dialog2 = new ConflictResolutionDialog(conflict);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2.getSelectedVariant();
    }

    @Nullable
    private static VariantAbi resolveNewVariantAbi(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModel, @NotNull String newVariant) {
        VariantAbi selectedVariantAbi = ndkFacet.getSelectedVariantAbi();
        if (selectedVariantAbi != null) {
            String userSelectedAbi = selectedVariantAbi.getAbi();
            VariantAbi newVariantAbi = new VariantAbi(newVariant, userSelectedAbi);
            if (ndkModel.getAllVariantAbis().contains(newVariantAbi)) {
                return newVariantAbi;
            }
        }
        return ndkModel.getAllVariantAbis().stream().filter(variantAbi -> variantAbi.getVariant().equals(newVariant)).findFirst().orElse(null);
    }
}

